/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.internal.tests.di;

import java.lang.ref.WeakReference;
import javax.inject.Inject;
import javax.inject.Named;
import junit.framework.TestCase;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;

public class InjectionResultLeakTest
extends TestCase {
    public void testLeaks() {
        IEclipseContext context = EclipseContextFactory.create();
        Object part = new Object();
        WeakReference<Object> ref = new WeakReference<Object>(part);
        InjectionResultLeakTest.assertEquals((Object)part, ref.get());
        context.set("testGC", part);
        PartConsumer consumer = (PartConsumer)ContextInjectionFactory.make(PartConsumer.class, (IEclipseContext)context);
        InjectionResultLeakTest.assertEquals((Object)part, (Object)consumer.part);
        part = null;
        context.remove("testGC");
        InjectionResultLeakTest.assertNull((Object)consumer.part);
        System.runFinalization();
        System.gc();
        System.runFinalization();
        System.gc();
        System.runFinalization();
        System.gc();
        System.runFinalization();
        System.gc();
        InjectionResultLeakTest.assertNull((String)"The object should have been garbage collected", ref.get());
    }

    static class PartConsumer {
        Object part;

        PartConsumer() {
        }

        @Inject
        void setPart(@Optional @Named(value="testGC") Object part) {
            this.part = part;
        }
    }
}

