/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.internal.tests.contexts.inject;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.internal.tests.contexts.inject.ObjectBasic;
import org.eclipse.e4.core.internal.tests.contexts.inject.ObjectSubClass;
import org.eclipse.e4.core.internal.tests.contexts.inject.OptionalAnnotations;

public class AnnotationsInjectionTest
extends TestCase {
    public static Test suite() {
        return new TestSuite(AnnotationsInjectionTest.class);
    }

    public AnnotationsInjectionTest() {
    }

    public AnnotationsInjectionTest(String name) {
        super(name);
    }

    public void testContextSetOneArg() {
        IEclipseContext context = EclipseContextFactory.create();
        class TestData {
            TestData() {
            }
        }
        TestData methodValue = new TestData();
        context.set("testing123", (Object)methodValue);
        class Injected {
            int contextSetCalled = 0;
            int setMethodCalled = 0;
            public TestData value;

            Injected() {
            }

            @Inject
            public void settings(IEclipseContext context) {
                ++this.contextSetCalled;
            }

            @Inject
            public void injectedMethod(@Named(value="testing123") TestData arg) {
                ++this.setMethodCalled;
                this.value = arg;
            }
        }
        Injected object = new Injected();
        ContextInjectionFactory.inject((Object)object, (IEclipseContext)context);
        AnnotationsInjectionTest.assertEquals((int)1, (int)object.setMethodCalled);
        AnnotationsInjectionTest.assertEquals((int)1, (int)object.contextSetCalled);
        TestData methodValue2 = new TestData();
        context.set("testing123", (Object)methodValue2);
        AnnotationsInjectionTest.assertEquals((int)2, (int)object.setMethodCalled);
        AnnotationsInjectionTest.assertEquals((Object)methodValue2, (Object)object.value);
        AnnotationsInjectionTest.assertEquals((int)1, (int)object.contextSetCalled);
    }

    public void testPostConstruct() {
        IEclipseContext context = EclipseContextFactory.create();
        class TestData {
            TestData() {
            }
        }
        TestData methodValue = new TestData();
        context.set(TestData.class.getName(), (Object)methodValue);
        class Injected {
            int postConstructCalled = 0;
            int setMethodCalled = 0;
            public TestData value;

            Injected() {
            }

            @PostConstruct
            public void init() {
                ++this.postConstructCalled;
            }

            @Inject
            public void setData(TestData arg) {
                ++this.setMethodCalled;
                this.value = arg;
            }
        }
        Injected object = new Injected();
        ContextInjectionFactory.inject((Object)object, (IEclipseContext)context);
        AnnotationsInjectionTest.assertEquals((int)1, (int)object.setMethodCalled);
        AnnotationsInjectionTest.assertEquals((int)1, (int)object.postConstructCalled);
        TestData methodValue2 = new TestData();
        context.set(TestData.class.getName(), (Object)methodValue2);
        AnnotationsInjectionTest.assertEquals((int)2, (int)object.setMethodCalled);
        AnnotationsInjectionTest.assertEquals((int)1, (int)object.postConstructCalled);
        AnnotationsInjectionTest.assertEquals((Object)methodValue2, (Object)object.value);
    }

    public synchronized void testInjection() {
        Integer testInt = new Integer(123);
        String testString = new String("abc");
        Double testDouble = new Double(1.23);
        Float testFloat = new Float(12.3);
        Character testChar = new Character('v');
        IEclipseContext context = EclipseContextFactory.create();
        context.set(Integer.class.getName(), (Object)testInt);
        context.set(String.class.getName(), (Object)testString);
        context.set(Double.class.getName(), (Object)testDouble);
        context.set(Float.class.getName(), (Object)testFloat);
        context.set(Character.class.getName(), (Object)testChar);
        ObjectBasic userObject = new ObjectBasic();
        ContextInjectionFactory.inject((Object)userObject, (IEclipseContext)context);
        AnnotationsInjectionTest.assertEquals((String)testString, (String)userObject.injectedString);
        AnnotationsInjectionTest.assertEquals((Object)testInt, (Object)userObject.getInt());
        AnnotationsInjectionTest.assertEquals((Object)context, (Object)userObject.context);
        AnnotationsInjectionTest.assertEquals((int)1, (int)userObject.setMethodCalled);
        AnnotationsInjectionTest.assertEquals((int)1, (int)userObject.setMethodCalled2);
        AnnotationsInjectionTest.assertEquals((Object)testDouble, (Object)userObject.d);
        AnnotationsInjectionTest.assertEquals((Object)testFloat, (Object)userObject.f);
        AnnotationsInjectionTest.assertEquals((Object)testChar, (Object)userObject.c);
        AnnotationsInjectionTest.assertTrue((boolean)userObject.finalized);
    }

    public void testFieldMethodOrder() {
        AssertionFailedError[] error = new AssertionFailedError[1];
        IEclipseContext context = EclipseContextFactory.create();
        class TestData {
            TestData() {
            }
        }
        TestData fieldValue = new TestData();
        TestData methodValue = new TestData();
        context.set("valueField", (Object)fieldValue);
        context.set("valueMethod", (Object)methodValue);
        class Injected {
            @Inject
            @Named(value="valueField")
            Object injectedField;
            Object methodValue;
            private final /* synthetic */ AssertionFailedError[] val$error;

            Injected(AssertionFailedError[] assertionFailedErrorArray) {
                this.val$error = assertionFailedErrorArray;
            }

            @Inject
            public void injectedMethod(@Optional @Named(value="valueMethod") Object arg) {
                try {
                    AnnotationsInjectionTest.assertTrue((this.injectedField != null ? 1 : 0) != 0);
                }
                catch (AssertionFailedError e) {
                    this.val$error[0] = e;
                }
                this.methodValue = arg;
            }
        }
        Injected object = new Injected(error);
        ContextInjectionFactory.inject((Object)object, (IEclipseContext)context);
        if (error[0] != null) {
            throw error[0];
        }
        AnnotationsInjectionTest.assertEquals((Object)fieldValue, (Object)object.injectedField);
        AnnotationsInjectionTest.assertEquals((Object)methodValue, (Object)object.methodValue);
        context.remove("valueMethod");
        if (error[0] != null) {
            throw error[0];
        }
        AnnotationsInjectionTest.assertEquals((Object)fieldValue, (Object)object.injectedField);
        AnnotationsInjectionTest.assertNull((Object)object.methodValue);
        context.dispose();
        if (error[0] != null) {
            throw error[0];
        }
    }

    public void testOptionalInjection() {
        Integer testInt = new Integer(123);
        IEclipseContext context = EclipseContextFactory.create();
        context.set(Integer.class.getName(), (Object)testInt);
        OptionalAnnotations userObject = new OptionalAnnotations();
        ContextInjectionFactory.inject((Object)userObject, (IEclipseContext)context);
        AnnotationsInjectionTest.assertEquals((int)0, (int)userObject.methodOptionalCalled);
        AnnotationsInjectionTest.assertEquals((int)1, (int)userObject.methodRequiredCalled);
        AnnotationsInjectionTest.assertEquals((Object)testInt, (Object)userObject.i);
        AnnotationsInjectionTest.assertNull((Object)userObject.s);
        AnnotationsInjectionTest.assertNull((Object)userObject.d);
        AnnotationsInjectionTest.assertNull((Object)userObject.f);
        String testString = new String("abc");
        Double testDouble = new Double(1.23);
        Float testFloat = new Float(12.3);
        context.set(String.class.getName(), (Object)testString);
        context.set(Double.class.getName(), (Object)testDouble);
        context.set(Float.class.getName(), (Object)testFloat);
        AnnotationsInjectionTest.assertEquals((int)1, (int)userObject.methodOptionalCalled);
        AnnotationsInjectionTest.assertEquals((int)2, (int)userObject.methodRequiredCalled);
        AnnotationsInjectionTest.assertEquals((Object)testInt, (Object)userObject.i);
        AnnotationsInjectionTest.assertEquals((String)testString, (String)userObject.s);
        AnnotationsInjectionTest.assertEquals((Object)testDouble, (Object)userObject.d);
        AnnotationsInjectionTest.assertEquals((Object)testFloat, (Object)userObject.f);
    }

    public void testOptionalInvoke() {
        IEclipseContext context = EclipseContextFactory.create();
        Object notAnObject = new Object();
        class TestObject {
            public int called = 0;

            TestObject() {
            }

            @Execute
            public String something(@Optional String param) {
                ++this.called;
                return param;
            }
        }
        TestObject testObject = new TestObject();
        context.set(String.class.getName(), (Object)testObject);
        Object result = ContextInjectionFactory.invoke((Object)testObject, Execute.class, (IEclipseContext)context, (Object)notAnObject);
        AnnotationsInjectionTest.assertNull((Object)result);
        AnnotationsInjectionTest.assertEquals((int)1, (int)testObject.called);
        String string = "sample";
        context.set(String.class.getName(), (Object)string);
        result = ContextInjectionFactory.invoke((Object)testObject, Execute.class, (IEclipseContext)context, (Object)notAnObject);
        AnnotationsInjectionTest.assertEquals((Object)string, (Object)result);
        AnnotationsInjectionTest.assertEquals((int)2, (int)testObject.called);
    }

    public void testInheritedSpecialMethods() {
        IEclipseContext context = EclipseContextFactory.create();
        context.set(Integer.class.getName(), (Object)new Integer(123));
        context.set(String.class.getName(), (Object)new String("abc"));
        context.set(Float.class.getName(), (Object)new Float(12.3));
        ObjectSubClass userObject = new ObjectSubClass();
        ContextInjectionFactory.inject((Object)userObject, (IEclipseContext)context);
        AnnotationsInjectionTest.assertEquals((int)1, (int)userObject.superPostConstructCount);
        AnnotationsInjectionTest.assertEquals((int)1, (int)userObject.subPostConstructCount);
        AnnotationsInjectionTest.assertEquals((int)0, (int)userObject.superPreDestroyCount);
        AnnotationsInjectionTest.assertEquals((int)0, (int)userObject.subPreDestroyCount);
        AnnotationsInjectionTest.assertEquals((int)0, (int)userObject.overriddenPreDestroyCount);
        context.set(Float.class.getName(), (Object)new Float(45.6));
        AnnotationsInjectionTest.assertEquals((int)1, (int)userObject.superPostConstructCount);
        AnnotationsInjectionTest.assertEquals((int)1, (int)userObject.subPostConstructCount);
        AnnotationsInjectionTest.assertEquals((int)0, (int)userObject.superPreDestroyCount);
        AnnotationsInjectionTest.assertEquals((int)0, (int)userObject.subPreDestroyCount);
        AnnotationsInjectionTest.assertEquals((int)0, (int)userObject.overriddenPreDestroyCount);
        context.dispose();
        AnnotationsInjectionTest.assertEquals((int)1, (int)userObject.superPreDestroyCount);
        AnnotationsInjectionTest.assertEquals((int)1, (int)userObject.subPreDestroyCount);
        AnnotationsInjectionTest.assertEquals((int)1, (int)userObject.overriddenPreDestroyCount);
    }

    public void testInvoke() {
        IEclipseContext context = EclipseContextFactory.create();
        class TestData {
            public String value;

            public TestData(String tmp) {
                this.value = tmp;
            }
        }
        TestData methodValue = new TestData("abc");
        context.set("testing123", (Object)methodValue);
        class Injected {
            public String myString;

            @Execute
            public String something(@Named(value="testing123") TestData data) {
                this.myString = data.value;
                return "true";
            }
        }
        Injected object = new Injected();
        AnnotationsInjectionTest.assertNull((Object)object.myString);
        AnnotationsInjectionTest.assertEquals((Object)"true", (Object)ContextInjectionFactory.invoke((Object)object, Execute.class, (IEclipseContext)context, null));
        AnnotationsInjectionTest.assertEquals((String)"abc", (String)object.myString);
    }

    public void testPreDestroy() {
        IEclipseContext context = EclipseContextFactory.create();
        class TestData {
            TestData() {
            }
        }
        TestData methodValue = new TestData();
        context.set(TestData.class.getName(), (Object)methodValue);
        class Injected {
            int preDestoryCalled = 0;
            public TestData value;
            @Inject
            public TestData directFieldInjection;

            Injected() {
            }

            @PreDestroy
            public void aboutToClose() {
                ++this.preDestoryCalled;
                AnnotationsInjectionTest.assertNotNull((Object)this.value);
                AnnotationsInjectionTest.assertNotNull((Object)this.directFieldInjection);
            }

            @Inject
            public void setData(TestData arg) {
                this.value = arg;
            }
        }
        Injected object = new Injected();
        ContextInjectionFactory.inject((Object)object, (IEclipseContext)context);
        AnnotationsInjectionTest.assertNotNull((Object)object.value);
        AnnotationsInjectionTest.assertNotNull((Object)object.directFieldInjection);
        context.dispose();
        AnnotationsInjectionTest.assertEquals((int)1, (int)object.preDestoryCalled);
        AnnotationsInjectionTest.assertNotNull((Object)object.value);
        AnnotationsInjectionTest.assertNotNull((Object)object.directFieldInjection);
    }
}

