/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.emf.javascript.ui;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandlerListener;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.e4.emf.ecore.javascript.JavascriptSupport;
import org.eclipse.e4.emf.javascript.ui.Activator;
import org.eclipse.e4.emf.javascript.ui.ScriptSourceView;
import org.eclipse.e4.emf.javascript.ui.StringEditorInput;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.texteditor.AbstractDecoratedTextEditor;
import org.eclipse.ui.texteditor.IDocumentProvider;

public class EditJavascriptCommandHandler
extends AbstractHandler {
    private Logger log = Logger.getLogger(Activator.getDefault().getBundle().getSymbolicName());

    public void dispose() {
    }

    private EObject getScriptedSelection(IWorkbenchWindow wbw) {
        return wbw != null && wbw.getActivePage() != null ? this.getScriptedSelection(wbw.getActivePage().getSelection()) : null;
    }

    private IEditingDomainProvider getEditingDomainProvider(IWorkbenchWindow wbw) {
        if (wbw == null || wbw.getActivePage() == null) {
            return null;
        }
        IWorkbenchPart part = wbw.getActivePage().getActivePart();
        return part instanceof IEditingDomainProvider ? (IEditingDomainProvider)part : null;
    }

    private EObject getScriptedSelection(ISelection selection) {
        EObject eObject;
        EAttribute scriptAttr;
        if (selection instanceof IStructuredSelection && ((IStructuredSelection)selection).getFirstElement() instanceof EObject && (scriptAttr = JavascriptSupport.getScriptSourceAttribute((EObject)(eObject = (EObject)((IStructuredSelection)selection).getFirstElement()), (String)"js")) != null) {
            return eObject;
        }
        return null;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        EObject eObject = this.getScriptedSelection(HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event));
        this.openEditorForScriptedEObject(eObject, this.getEditingDomainProvider(HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event)));
        return eObject;
    }

    private void openEditorForScriptedEObject(EObject eObject, IEditingDomainProvider editingDomainProvider) {
        EAttribute scriptAttr;
        if (eObject != null && (scriptAttr = JavascriptSupport.getScriptSourceAttribute((EObject)eObject, (String)"js")) != null) {
            Object attrValue = eObject.eGet((EStructuralFeature)scriptAttr);
            String scriptSource = attrValue != null ? (String)attrValue : "";
            Resource resource = eObject.eResource();
            if (resource != null) {
                String fragment = String.valueOf(scriptAttr.getName()) + this.convertFragmentToTempName(resource.getURIFragment(eObject));
                URI resUri = resource.getURI();
                URI jsUri = resUri.trimSegments(1).appendSegment(String.valueOf(resUri.lastSegment()) + "." + fragment);
                jsUri = jsUri.appendFileExtension("js");
                Path storagePath = new Path(jsUri.toPlatformString(true));
                try {
                    String editorId = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(jsUri.lastSegment()).getId();
                    StringEditorInput editorInput = new StringEditorInput(resUri + "#" + fragment, (IPath)storagePath, scriptSource);
                    final IEditorPart editor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)editorInput, editorId);
                    editor.addPropertyListener(new IPropertyListener((IEditorInput)editorInput, eObject, editingDomainProvider){
                        private final /* synthetic */ IEditorInput val$editorInput;
                        private final /* synthetic */ EObject val$eObject;
                        private final /* synthetic */ IEditingDomainProvider val$editingDomainProvider;
                        {
                            this.val$editorInput = iEditorInput;
                            this.val$eObject = eObject;
                            this.val$editingDomainProvider = iEditingDomainProvider;
                        }

                        public void propertyChanged(Object source, int propId) {
                            if (257 == propId && editor instanceof AbstractDecoratedTextEditor && !editor.isDirty()) {
                                IDocumentProvider documentProvider = ((AbstractDecoratedTextEditor)editor).getDocumentProvider();
                                String newSource = documentProvider.getDocument((Object)this.val$editorInput).get();
                                try {
                                    ScriptSourceView.commitScriptText(this.val$eObject, newSource, this.val$editingDomainProvider);
                                }
                                catch (Exception e) {
                                    EditJavascriptCommandHandler.this.log.log(Level.WARNING, "Exception setting script text to " + newSource + ": " + e, e);
                                }
                            }
                        }
                    });
                }
                catch (PartInitException e) {
                    System.err.println((Object)e);
                }
            }
        }
    }

    private String convertFragmentToTempName(String fragment) {
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i < fragment.length()) {
            char c = fragment.charAt(i);
            builder.append(Character.isJavaIdentifierPart(c) ? c : (char)'_');
            ++i;
        }
        return builder.toString();
    }

    public boolean isEnabled() {
        EObject eObject = this.getScriptedSelection(PlatformUI.getWorkbench().getActiveWorkbenchWindow());
        return eObject != null;
    }

    public boolean isHandled() {
        return true;
    }

    public void addHandlerListener(IHandlerListener handlerListener) {
    }

    public void removeHandlerListener(IHandlerListener handlerListener) {
    }
}

