/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.application;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.services.contributions.IContributionFactory;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.internal.workbench.Activator;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.MContribution;
import org.eclipse.e4.ui.model.application.ui.MContext;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MGenericStack;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspectiveStack;
import org.eclipse.e4.ui.model.application.ui.advanced.MPlaceholder;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MStackElement;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.workbench.IPresentationEngine;
import org.eclipse.e4.ui.workbench.UIEvents;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.emf.ecore.EObject;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HeadlessContextPresentationEngine
implements IPresentationEngine {
    @Inject
    private IEventBroker eventBroker;
    @Inject
    private IContributionFactory contributionFactory;
    private EventHandler childHandler;
    private EventHandler activeChildHandler;
    private EventHandler toBeRenderedHandler;
    private Map<MUIElement, List<MPlaceholder>> renderedPlaceholders = new HashMap<MUIElement, List<MPlaceholder>>();
    private boolean createContributions = true;
    @Inject
    private EModelService modelService;

    protected IEclipseContext getParentContext(MUIElement element) {
        return this.modelService.getContainingContext(element);
    }

    private static void populateModelInterfaces(MContext contextModel, IEclipseContext context, Class<?>[] interfaces) {
        Class<?>[] classArray = interfaces;
        int n = interfaces.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> intf = classArray[n2];
            Activator.trace((String)"/trace/eclipse.context", (String)("Adding " + intf.getName() + " for " + contextModel.getClass().getName()), null);
            context.set(intf.getName(), (Object)contextModel);
            HeadlessContextPresentationEngine.populateModelInterfaces(contextModel, context, intf.getInterfaces());
            ++n2;
        }
    }

    @PostConstruct
    void postConstruct() {
        this.childHandler = new EventHandler(){

            public void handleEvent(Event event) {
                Object element;
                if ("ADD".equals(event.getProperty("EventType")) && (element = event.getProperty("NewValue")) instanceof MUIElement) {
                    IEclipseContext context;
                    Object parent = event.getProperty("ChangedElement");
                    IEclipseContext parentContext = HeadlessContextPresentationEngine.this.getParentContext((MUIElement)element);
                    if (element instanceof MContext && (context = ((MContext)element).getContext()) != null && context.getParent() != parentContext) {
                        context.deactivate();
                    }
                    HeadlessContextPresentationEngine.this.createGui((MUIElement)element, parent, parentContext);
                    if (parent instanceof MPartStack) {
                        MPartStack stack = (MPartStack)parent;
                        List children = stack.getChildren();
                        MStackElement stackElement = (MStackElement)element;
                        if (children.size() == 1 && stackElement.isVisible() && stackElement.isToBeRendered()) {
                            stack.setSelectedElement((MUIElement)stackElement);
                        }
                    }
                }
            }
        };
        this.eventBroker.subscribe(UIEvents.buildTopic((String)"org/eclipse/e4/ui/model/ui/ElementContainer", (String)"children"), this.childHandler);
        this.activeChildHandler = new EventHandler(){

            public void handleEvent(Event event) {
                Object element = event.getProperty("NewValue");
                if (element instanceof MUIElement) {
                    MUIElement uiElement = (MUIElement)element;
                    IEclipseContext parentContext = HeadlessContextPresentationEngine.this.getParentContext(uiElement);
                    Object parent = event.getProperty("ChangedElement");
                    HeadlessContextPresentationEngine.this.createGui(uiElement, parent, parentContext);
                    if (parent instanceof MPerspectiveStack) {
                        MPerspective perspective = (MPerspective)uiElement;
                        HeadlessContextPresentationEngine.this.adjustPlaceholders((MUIElement)perspective);
                        ((EPartService)parentContext.get(EPartService.class)).switchPerspective(perspective);
                    }
                }
            }
        };
        this.eventBroker.subscribe(UIEvents.buildTopic((String)"org/eclipse/e4/ui/model/ui/ElementContainer", (String)"selectedElement"), this.activeChildHandler);
        this.toBeRenderedHandler = new EventHandler(){

            public void handleEvent(Event event) {
                MUIElement element = (MUIElement)event.getProperty("ChangedElement");
                Boolean value = (Boolean)event.getProperty("NewValue");
                if (value.booleanValue()) {
                    HeadlessContextPresentationEngine.this.createGui(element, element.getParent(), HeadlessContextPresentationEngine.this.getParentContext(element));
                } else {
                    HeadlessContextPresentationEngine.this.removeGui(element);
                }
            }
        };
        this.eventBroker.subscribe(UIEvents.buildTopic((String)"org/eclipse/e4/ui/model/ui/UIElement", (String)"toBeRendered"), this.toBeRenderedHandler);
    }

    private void adjustPlaceholders(MUIElement element) {
        if (element.isToBeRendered()) {
            MPlaceholder placeholder;
            MUIElement ref;
            if (element instanceof MPlaceholder && (ref = (placeholder = (MPlaceholder)element).getRef()) != null) {
                ref.setCurSharedRef(placeholder);
                element = ref;
            }
            if (element instanceof MGenericStack) {
                MGenericStack stack = (MGenericStack)element;
                MUIElement selectedElement = stack.getSelectedElement();
                if (selectedElement != null) {
                    this.adjustPlaceholders(selectedElement);
                }
            } else if (element instanceof MElementContainer) {
                for (Object child : ((MElementContainer)element).getChildren()) {
                    this.adjustPlaceholders((MUIElement)child);
                }
            }
        }
    }

    public void setCreateContributions(boolean createContributions) {
        this.createContributions = createContributions;
    }

    public Object createGui(MUIElement element, Object parentWidget, IEclipseContext parentContext) {
        MPlaceholder placeholder;
        MUIElement ref;
        if (!element.isToBeRendered()) {
            return null;
        }
        MElementContainer parent = element.getParent();
        if (!(parent instanceof MApplication)) {
            Assert.isNotNull((Object)parentWidget);
        }
        element.setRenderer((Object)this);
        Object widget = new Object();
        element.setWidget(widget);
        if (element instanceof MContext) {
            MContext mcontext = (MContext)element;
            IEclipseContext createdContext = mcontext.getContext();
            if (createdContext == null) {
                MContribution contribution;
                String uri;
                String contextName = String.valueOf(element.getClass().getInterfaces()[0].getName()) + " eclipse context";
                createdContext = parentContext != null ? parentContext.createChild(contextName) : EclipseContextFactory.create((String)contextName);
                HeadlessContextPresentationEngine.populateModelInterfaces(mcontext, createdContext, element.getClass().getInterfaces());
                for (String variable : mcontext.getVariables()) {
                    createdContext.declareModifiable(variable);
                }
                mcontext.setContext(createdContext);
                if (element instanceof MContribution && this.createContributions && (uri = (contribution = (MContribution)element).getContributionURI()) != null) {
                    Object clientObject = this.contributionFactory.create(uri, createdContext);
                    contribution.setObject(clientObject);
                }
                if (parentContext != null && parentContext.getActiveChild() == null) {
                    createdContext.activate();
                }
            } else if (createdContext.getParent() != parentContext) {
                createdContext.setParent(parentContext);
            }
        }
        if (element instanceof MGenericStack) {
            MGenericStack container = (MGenericStack)element;
            MUIElement active = container.getSelectedElement();
            if (active != null) {
                this.createGui(active, container, this.getParentContext(active));
            } else {
                List children = container.getChildren();
                if (!children.isEmpty()) {
                    ((MElementContainer)element).setSelectedElement((MUIElement)children.get(0));
                }
            }
        } else if (element instanceof MElementContainer) {
            for (Object child : ((MElementContainer)element).getChildren()) {
                if (!(child instanceof MUIElement)) continue;
                this.createGui((MUIElement)child, element, this.getParentContext((MUIElement)child));
                if (!(child instanceof MContext)) continue;
                IEclipseContext childContext = ((MContext)child).getContext();
                IEclipseContext pContext = this.getParentContext((MUIElement)child);
                if (childContext == null || pContext.getActiveChild() != null) continue;
                childContext.activate();
            }
            if (element instanceof MWindow) {
                MWindow window = (MWindow)element;
                for (MWindow childWindow : window.getWindows()) {
                    this.createGui((MUIElement)childWindow, element, window.getContext());
                }
            }
            if (element instanceof MPerspective) {
                MPerspective perspective = (MPerspective)element;
                for (MWindow childWindow : perspective.getWindows()) {
                    this.createGui((MUIElement)childWindow, element, perspective.getContext());
                }
            }
        } else if (element instanceof MPlaceholder && (ref = (placeholder = (MPlaceholder)element).getRef()) != null) {
            ref.setCurSharedRef(placeholder);
            ref.setToBeRendered(true);
            this.createGui(ref);
            List<MPlaceholder> placeholders = this.renderedPlaceholders.get(ref);
            if (placeholders == null) {
                placeholders = new ArrayList<MPlaceholder>();
                this.renderedPlaceholders.put(ref, placeholders);
            } else if (placeholders.contains(placeholder)) {
                return null;
            }
            placeholders.add(placeholder);
        }
        return widget;
    }

    public Object createGui(MUIElement element) {
        MPlaceholder placeholder = element.getCurSharedRef();
        if (placeholder != null) {
            return this.createGui(element, placeholder.getWidget(), this.getParentContext(element));
        }
        MElementContainer parent = element.getParent();
        if (parent == null) {
            parent = (MUIElement)((EObject)element).eContainer();
        }
        return this.createGui(element, parent.getWidget(), this.getParentContext(element));
    }

    public void removeGui(MUIElement element) {
        if (element instanceof MElementContainer) {
            for (Object child : ((MElementContainer)element).getChildren()) {
                if (!(child instanceof MUIElement)) continue;
                this.removeGui((MUIElement)child);
            }
        }
        if (element instanceof MPlaceholder) {
            this.removePlaceholder((MPlaceholder)element);
        }
        if (element instanceof MContext) {
            IEclipseContext parentContext;
            MContext mcontext = (MContext)element;
            IEclipseContext context = mcontext.getContext();
            if (context != null && (parentContext = context.getParent()) != null && parentContext.getActiveChild() == context) {
                context.deactivate();
            }
            mcontext.setContext(null);
            if (context != null) {
                context.dispose();
            }
        }
    }

    private void removePlaceholder(MPlaceholder placeholder) {
        MUIElement ref = placeholder.getRef();
        List<MPlaceholder> placeholders = this.renderedPlaceholders.get(placeholder.getRef());
        placeholders.remove(placeholder);
        if (placeholders.isEmpty()) {
            this.removeGui(ref);
            this.renderedPlaceholders.remove(ref);
        } else {
            IEclipseContext currentContext = this.modelService.getContainingContext((MUIElement)placeholder);
            for (MPlaceholder other : placeholders) {
                IEclipseContext newParentContext = this.modelService.getContainingContext((MUIElement)other);
                if (newParentContext == null) continue;
                List contextElements = this.modelService.findElements(ref, null, MContext.class, null);
                for (MContext contextElement : contextElements) {
                    IEclipseContext context = contextElement.getContext();
                    if (context.getParent() != currentContext) continue;
                    context.setParent(newParentContext);
                }
                ref.setCurSharedRef(other);
                break;
            }
        }
    }

    public Object run(MApplicationElement uiRoot, IEclipseContext appContext) {
        return 0;
    }

    public void stop() {
    }
}

