/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.tests.snipppets;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.observable.Observables;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.ObservableMapLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class Snippet007ColorLabelProvider {
    public static void main(String[] args) {
        final ArrayList<Person> persons = new ArrayList<Person>();
        persons.add(new Person("Fiona Apple", 1));
        persons.add(new Person("Elliot Smith", 0));
        persons.add(new Person("Diana Krall", 1));
        persons.add(new Person("David Gilmour", 0));
        final Display display = new Display();
        Realm.runWithDefault((Realm)SWTObservables.getRealm((Display)display), (Runnable)new Runnable(){

            public void run() {
                Shell shell = new Shell(display);
                shell.setText("Gender Bender");
                shell.setLayout((Layout)new GridLayout());
                Table table = new Table((Composite)shell, 2820);
                GridData gridData = new GridData(4, 4, true, true);
                table.setLayoutData((Object)gridData);
                table.setHeaderVisible(true);
                table.setLinesVisible(true);
                TableColumn column = new TableColumn(table, 0);
                column.setText("No");
                column.setWidth(20);
                column = new TableColumn(table, 0);
                column.setText("Name");
                column.setWidth(100);
                final TableViewer viewer = new TableViewer(table);
                IObservableList observableList = Observables.staticObservableList((List)persons);
                ObservableListContentProvider contentProvider = new ObservableListContentProvider();
                viewer.setContentProvider((IContentProvider)contentProvider);
                IObservableMap[] attributes = BeansObservables.observeMaps((IObservableSet)contentProvider.getKnownElements(), Person.class, (String[])new String[]{"name", "gender"});
                class ColorLabelProvider
                extends ObservableMapLabelProvider
                implements ITableColorProvider {
                    Color male;
                    Color female;
                    private final /* synthetic */ List val$persons;

                    ColorLabelProvider(IObservableMap[] attributes, Display display, List list) {
                        this.val$persons = list;
                        super(attributes);
                        this.male = display.getSystemColor(9);
                        this.female = new Color((Device)display, 255, 192, 203);
                    }

                    public String getColumnText(Object element, int index) {
                        if (index == 0) {
                            return Integer.toString(this.val$persons.indexOf(element) + 1);
                        }
                        return ((Person)element).getName();
                    }

                    public Color getBackground(Object element, int index) {
                        return null;
                    }

                    public Color getForeground(Object element, int index) {
                        if (index == 0) {
                            return null;
                        }
                        Person person = (Person)element;
                        return person.getGender() == 0 ? this.male : this.female;
                    }

                    public void dispose() {
                        super.dispose();
                        this.female.dispose();
                    }
                }
                viewer.setLabelProvider((IBaseLabelProvider)new ColorLabelProvider(attributes, display, persons));
                viewer.setInput((Object)observableList);
                table.getColumn(0).pack();
                Button button = new Button((Composite)shell, 8);
                button.setText("Toggle Gender");
                button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent arg0) {
                        StructuredSelection selection = (StructuredSelection)viewer.getSelection();
                        if (selection != null && !selection.isEmpty()) {
                            Person person;
                            person.setGender((person = (Person)selection.getFirstElement()).getGender() == 0 ? 1 : 0);
                        }
                    }
                });
                shell.setSize(300, 400);
                shell.open();
                while (!shell.isDisposed()) {
                    if (display.readAndDispatch()) continue;
                    display.sleep();
                }
            }
        });
        display.dispose();
    }

    static class Person {
        static final int MALE = 0;
        static final int FEMALE = 1;
        private String name;
        private int gender;
        private PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);

        Person(String name, int gender) {
            this.name = name;
            this.gender = gender;
        }

        public String getName() {
            return this.name;
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.changeSupport.addPropertyChangeListener(listener);
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.changeSupport.removePropertyChangeListener(listener);
        }

        public int getGender() {
            return this.gender;
        }

        void setGender(int gender) {
            this.gender = gender;
            this.changeSupport.firePropertyChange("gender", this.gender, this.gender);
        }
    }
}

