/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.tests.snippet017.inner;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.e4.xwt.XWT;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Event;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableViewerWithDerivedColumns {
    private static Person UNKNOWN = new Person("unknown", null, null);

    public static void main(String[] args) {
        ViewModel viewModel = new ViewModel();
        URL url = TableViewerWithDerivedColumns.class.getResource(String.valueOf(TableViewerWithDerivedColumns.class.getSimpleName()) + ".xwt");
        try {
            XWT.open((URL)url, (Object)viewModel);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected Person findPerson(List<Person> people, String name) {
        for (Person person : people) {
            if (!name.equals(person.getName())) continue;
            return person;
        }
        return null;
    }

    public void changeMother(Object sender, Event event) {
        ViewModel dataContext = (ViewModel)XWT.getDataContext((Object)event.widget);
        ComboViewer comboViewer = (ComboViewer)XWT.findElementByName((Object)event.widget, (String)"MotherCombo");
        TableViewer tableViewer = (TableViewer)XWT.findElementByName((Object)event.widget, (String)"TableViewer");
        IObservableValue singleSelection = XWT.observableValue((Object)tableViewer, null, (String)"singleSelection");
        Object selected = singleSelection.getValue();
        IObservableValue motherValue = XWT.observableValue((Object)comboViewer, (Object)selected, (String)"mother");
        Person newMother = this.findPerson(dataContext.getPeople(), "Della Duck");
        motherValue.setValue((Object)newMother);
    }

    public static abstract class AbstractModelObject {
        private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.propertyChangeSupport.addPropertyChangeListener(listener);
        }

        public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
            this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.propertyChangeSupport.removePropertyChangeListener(listener);
        }

        public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
            this.propertyChangeSupport.removePropertyChangeListener(propertyName, listener);
        }

        protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
            this.propertyChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    public static class Person
    extends AbstractModelObject {
        String name = "Donald Duck";
        Person mother;
        Person father;

        public Person(String name, Person mother, Person father) {
            this.name = name;
            this.mother = mother;
            this.father = father;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            String oldValue = this.name;
            this.name = name;
            this.firePropertyChange("name", oldValue, name);
        }

        public Person getMother() {
            return this.mother;
        }

        public void setMother(Person mother) {
            this.mother = mother;
            this.firePropertyChange("mother", this.mother, this.mother);
        }

        public Person getFather() {
            return this.father;
        }

        public void setFather(Person father) {
            this.father = father;
            this.firePropertyChange("father", this.father, this.father);
        }

        public String toString() {
            return this.name;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ViewModel {
        private ArrayList<Person> people = new ArrayList();

        public ViewModel() {
            Person fergus = new Person("Fergus McDuck", UNKNOWN, UNKNOWN);
            Person downy = new Person("Downy O'Drake", UNKNOWN, UNKNOWN);
            Person scrooge = new Person("Scrooge McDuck", downy, fergus);
            Person hortense = new Person("Hortense McDuck", downy, fergus);
            Person quackmore = new Person("Quackmore Duck", UNKNOWN, UNKNOWN);
            Person della = new Person("Della Duck", hortense, quackmore);
            Person donald = new Person("Donald Duck", hortense, quackmore);
            donald.setFather(quackmore);
            donald.setMother(hortense);
            della.setFather(quackmore);
            della.setMother(hortense);
            hortense.setMother(downy);
            hortense.setFather(fergus);
            scrooge.setMother(downy);
            scrooge.setFather(fergus);
            this.people.add(UNKNOWN);
            this.people.add(downy);
            this.people.add(fergus);
            this.people.add(scrooge);
            this.people.add(quackmore);
            this.people.add(hortense);
            this.people.add(della);
            this.people.add(donald);
        }

        public ArrayList<Person> getPeople() {
            return this.people;
        }
    }
}

