/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.css.swt;

import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.tests.css.swt.CSSSWTTestCase;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public abstract class TextTransformTest
extends CSSSWTTestCase {
    private CSSEngine engine;

    protected abstract String getWidgetName();

    protected abstract Control createControl(Composite var1);

    protected abstract String getText(Control var1);

    protected abstract void setText(Control var1, String var2);

    private Control createTestControl(String styleSheet) {
        Display display = Display.getDefault();
        this.engine = this.createEngine(styleSheet, display);
        Shell shell = new Shell(display, 1264);
        FillLayout layout = new FillLayout();
        shell.setLayout((Layout)layout);
        Control controlToTest = this.createControl((Composite)shell);
        this.setText(controlToTest, "Some label text");
        this.engine.applyStyles((Object)shell, true);
        shell.pack();
        return controlToTest;
    }

    public void testTextTransformCapitalize() {
        Control controlToTest = this.createTestControl(String.valueOf(this.getWidgetName()) + " { text-transform: capitalize; }");
        TextTransformTest.assertEquals((String)"Some Label Text", (String)this.getText(controlToTest));
    }

    public void testTextTransformUpperCase() {
        Control controlToTest = this.createTestControl(String.valueOf(this.getWidgetName()) + " { text-transform: uppercase; }");
        TextTransformTest.assertEquals((String)"SOME LABEL TEXT", (String)this.getText(controlToTest));
    }

    public void testTextTransformLowerCase() {
        Control controlToTest = this.createTestControl(String.valueOf(this.getWidgetName()) + " { text-transform: lowercase; }");
        TextTransformTest.assertEquals((String)"some label text", (String)this.getText(controlToTest));
    }
}

