/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.deeplink.internal;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.eclipse.e4.core.deeplink.internal.DeepLinkProperties;
import org.eclipse.e4.core.functionalprog.optionmonad.None;
import org.eclipse.e4.core.functionalprog.optionmonad.Option;
import org.eclipse.e4.core.functionalprog.optionmonad.Some;

public class InstallationLauncher {
    private String rootFolder;
    private DeepLinkProperties properties;
    String[] startupCommands = new String[]{"eclipse.exe", "eclipse", "launcher.exe", "launcher"};

    public InstallationLauncher(String rootFolder, DeepLinkProperties properties) {
        this.rootFolder = rootFolder;
        this.properties = properties;
    }

    public void startInstallation(String installation, String deepLinkURL) {
        String command = this.properties.getInstallationCommand(installation);
        Option<String> commandLine = this.computeStartupCommandLine(installation, command);
        if (!commandLine.hasValue()) {
            throw new IllegalArgumentException("Unable to launch installation: " + installation);
        }
        String commandDir = String.valueOf(this.rootFolder) + File.separator + installation;
        this.startApplication((String)commandLine.get(), commandDir);
    }

    private void startApplication(String command, String commandDir) {
        try {
            Process p = Runtime.getRuntime().exec(command, null, new File(commandDir));
            new StreamGobbler(p.getInputStream(), "STDOUT").start();
            new StreamGobbler(p.getErrorStream(), "STDERR").start();
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to launch: " + command, e);
        }
    }

    private Option<String> computeStartupCommandLine(String installation, String command) {
        Option<String> result = this.validateCommand(installation, command);
        if (result.hasValue()) {
            return result;
        }
        String[] stringArray = this.startupCommands;
        int n = this.startupCommands.length;
        int n2 = 0;
        while (n2 < n) {
            String possibleCommand = stringArray[n2];
            Option<String> possibleResult = this.validateCommand(installation, possibleCommand);
            if (possibleResult.hasValue()) {
                return possibleResult;
            }
            ++n2;
        }
        return None.none();
    }

    private Option<String> validateCommand(String installation, String command) {
        if (command != null) {
            String commandLine = String.valueOf(this.rootFolder) + File.separator + installation + File.separator + command;
            if (new File(commandLine).exists()) {
                return Some.some((Object)commandLine);
            }
            return None.none();
        }
        return None.none();
    }

    class StreamGobbler
    extends Thread {
        InputStream is;
        String type;

        StreamGobbler(InputStream is, String type) {
            this.is = is;
            this.type = type;
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try {
                InputStreamReader isr = new InputStreamReader(this.is);
                BufferedReader br = new BufferedReader(isr);
                String line = null;
                while ((line = br.readLine()) != null) {
                    System.out.println(String.valueOf(this.type) + ">" + line);
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }
}

