/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.deeplink.internal;

import org.eclipse.e4.core.deeplink.internal.DeepLinkProperties;

public class DeeplinkPortAssigner {
    private final DeepLinkProperties properties;
    private boolean regeneratePortNumbersOnClash;

    public DeeplinkPortAssigner(DeepLinkProperties props, boolean regeneratePortNumbersOnClash) {
        this.regeneratePortNumbersOnClash = regeneratePortNumbersOnClash;
        if (props == null) {
            throw new IllegalArgumentException("Properties object passed to DeeplinkPortAssigner was null.");
        }
        this.properties = props;
    }

    public int getPortNumberForInstallation(String myInstallation) {
        String installationPortNumberString = this.properties.getInstallationPort(myInstallation);
        if (installationPortNumberString == null) {
            int portNumber = this.properties.calculateNextPortNumber();
            this.properties.setInstallationPort(myInstallation, portNumber);
            return portNumber;
        }
        if (!this.properties.isPortNumberUnique(myInstallation, installationPortNumberString)) {
            return this.regeneratePortNumber(myInstallation);
        }
        return Integer.parseInt(installationPortNumberString);
    }

    private int regeneratePortNumber(String myInstallation) {
        if (!this.regeneratePortNumbersOnClash) {
            throw new RuntimeException("Port number already assigned to another installation.");
        }
        this.properties.removeInstallationPort(myInstallation);
        int portNumber = this.properties.calculateNextPortNumber();
        this.properties.setInstallationPort(myInstallation, portNumber);
        return portNumber;
    }
}

