/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.server.bespin;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.eclipse.e4.server.bespin.Activator;
import org.eclipse.e4.server.bespin.JSONUtil;

public class AuthenticationServlet
extends HttpServlet {
    private File users = Activator.bundleContext.getDataFile("users");

    public AuthenticationServlet() {
        this.users.mkdir();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String pathInfo = req.getPathInfo();
        if (pathInfo.equals("/userinfo/")) {
            HttpSession session = req.getSession();
            if (session == null) {
                resp.setStatus(401);
                return;
            }
            String username = (String)session.getAttribute("username");
            if (username == null) {
                resp.setStatus(401);
                return;
            }
            Map userMap = this.loadUserMap(username);
            if (userMap == null) {
                resp.setStatus(401);
                return;
            }
            String project = (String)userMap.get("project");
            resp.setContentType("application/json; charset=UTF-8");
            HashMap<String, Object> jsonObject = new HashMap<String, Object>();
            jsonObject.put("project", new Integer(project.hashCode()));
            jsonObject.put("username", username);
            resp.getWriter().write(JSONUtil.write(jsonObject));
            return;
        }
        if (pathInfo.equals("/logout/")) {
            HttpSession session = req.getSession();
            if (session != null) {
                session.invalidate();
            }
            return;
        }
        super.doGet(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String pathInfo = req.getPathInfo();
        if (pathInfo.startsWith("/new/")) {
            String username = pathInfo.substring("/new/".length());
            Map userMap = this.loadUserMap(username);
            if (userMap != null) {
                resp.getWriter().write("Username " + username + " is already in use");
                resp.setStatus(409);
                return;
            }
            userMap = this.createUserMap();
            String password = req.getParameter("password");
            userMap.put("password", password);
            String email = req.getParameter("email");
            userMap.put("email", email);
            String project = String.valueOf(username) + "_Project";
            userMap.put("project", project);
            this.saveUserMap(username, userMap);
            req.getSession(true).setAttribute("username", (Object)username);
            resp.setContentType("application/json; charset=UTF-8");
            HashMap<String, Integer> jsonObject = new HashMap<String, Integer>();
            jsonObject.put("project", new Integer(project.hashCode()));
            resp.getWriter().write(JSONUtil.write(jsonObject));
            return;
        }
        if (pathInfo.startsWith("/login/")) {
            String username = pathInfo.substring("/login/".length());
            Map userMap = this.loadUserMap(username);
            if (userMap == null) {
                resp.setStatus(401);
                return;
            }
            String project = (String)userMap.get("project");
            req.getSession(true).setAttribute("username", (Object)username);
            resp.setContentType("application/json; charset=UTF-8");
            HashMap<String, Integer> jsonObject = new HashMap<String, Integer>();
            jsonObject.put("project", new Integer(project.hashCode()));
            resp.getWriter().write(JSONUtil.write(jsonObject));
            return;
        }
        super.doPost(req, resp);
    }

    private Map createUserMap() {
        return new Properties();
    }

    private void saveUserMap(String username, Map userMap) {
        File userFile = new File(this.users, String.valueOf(username) + ".properties");
        Properties props = (Properties)userMap;
        try {
            props.store(new FileOutputStream(userFile), null);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private Map loadUserMap(String username) {
        File userFile = new File(this.users, String.valueOf(username) + ".properties");
        if (!userFile.isFile()) {
            return null;
        }
        Properties props = new Properties();
        try {
            props.load(new FileInputStream(userFile));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return props;
    }
}

