/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tm.ui.builders;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.e4.emf.ecore.javascript.ScriptClassLoader;
import org.eclipse.emf.common.util.URI;
import org.mozilla.javascript.CompilerEnvirons;
import org.mozilla.javascript.optimizer.ClassCompiler;

public class JavascriptBuilder
extends IncrementalProjectBuilder {
    public static final String BUILDER_NAME = "JavascriptBuilder";
    private List<IProject> dependentProjects = new ArrayList<IProject>();
    private IResourceVisitor buildVisitor = new IResourceVisitor(){

        public boolean visit(IResource resource) throws CoreException {
            if (resource instanceof IContainer) {
                return true;
            }
            if (resource instanceof IFile && JavascriptBuilder.this.changeShouldTriggerBuild((IFile)resource)) {
                JavascriptBuilder.this.build((IFile)resource);
            }
            return false;
        }
    };
    private IResourceVisitor cleanVisitor = new IResourceVisitor(){

        public boolean visit(IResource resource) throws CoreException {
            if (resource instanceof IContainer) {
                return true;
            }
            if (resource instanceof IFile) {
                JavascriptBuilder.this.clean((IFile)resource);
            }
            return false;
        }
    };
    private IResourceDeltaVisitor buildDeltaVisitor = new IResourceDeltaVisitor(){

        public boolean visit(IResourceDelta delta) throws CoreException {
            int kind = delta.getKind();
            if (kind == 4 || kind == 1) {
                return JavascriptBuilder.this.buildVisitor.visit(delta.getResource());
            }
            return false;
        }
    };
    private CompilerEnvirons compilerEnvironment = new CompilerEnvirons();
    private ClassCompiler compiler = new ClassCompiler(this.compilerEnvironment);

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        this.dependentProjects.clear();
        if (kind == 6) {
            this.fullBuild(monitor);
        } else if (kind == 10 || kind == 9) {
            IResourceDelta delta = this.getDelta(this.getProject());
            if (delta == null) {
                this.fullBuild(monitor);
            } else {
                this.incrementalBuild(delta, monitor);
            }
        }
        return this.dependentProjects.toArray(new IProject[this.dependentProjects.size()]);
    }

    protected void clean(IProgressMonitor monitor) {
        try {
            super.clean(monitor);
            this.getProject().accept(this.cleanVisitor);
        }
        catch (CoreException coreException) {}
    }

    private void fullBuild(IProgressMonitor monitor) {
        try {
            this.getProject().accept(this.buildVisitor);
        }
        catch (CoreException coreException) {}
    }

    protected boolean changeShouldTriggerBuild(IFile file) {
        return "js".equals(file.getFileExtension());
    }

    protected void incrementalBuild(IResourceDelta delta, IProgressMonitor monitor) throws CoreException {
        delta.accept(this.buildDeltaVisitor);
    }

    protected void startupOnInitialize() {
        super.startupOnInitialize();
    }

    private void clean(IFile file) throws CoreException {
        String name;
        if (this.changeShouldTriggerBuild(file)) {
            file.deleteMarkers("org.eclipse.core.resources.problemmarker", true, 0);
        } else if ("class".equals(file.getFileExtension()) && ScriptClassLoader.hasUriClassNameMarker((String)(name = file.getName()).substring(0, name.lastIndexOf(46)))) {
            try {
                file.delete(true, null);
            }
            catch (CoreException coreException) {}
        }
    }

    protected void build(IFile jsFile) {
        String fileName = jsFile.getName();
        StringBuilder stringBuilder = new StringBuilder();
        Object[] compiled = null;
        try {
            jsFile.deleteMarkers("org.eclipse.core.resources.problemmarker", true, 0);
        }
        catch (CoreException coreException) {}
        String fullClassName = ScriptClassLoader.getUriClassName((URI)URI.createPlatformResourceURI((String)jsFile.getFullPath().toString(), (boolean)true));
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(jsFile.getContents()));
            String line = null;
            while (reader.ready() && (line = reader.readLine()) != null) {
                stringBuilder.append(line);
                stringBuilder.append("\n");
            }
            compiled = this.compiler.compileToClassFiles(stringBuilder.toString(), fileName, 1, fullClassName);
        }
        catch (Exception e) {
            JavascriptBuilder.createMarker((IResource)jsFile, null, e.getMessage(), 2);
            return;
        }
        int pos = fullClassName.lastIndexOf(46);
        String packageName = pos > 0 ? fullClassName.substring(0, pos + 1) : "";
        int i = 0;
        while (i < compiled.length) {
            String className = (String)compiled[i];
            String classFileName = className.startsWith(packageName) ? className.substring(packageName.length()) : className;
            IFile classFile = jsFile.getParent().getFile((IPath)new Path(String.valueOf(classFileName) + ".class"));
            byte[] bytes = (byte[])compiled[i + 1];
            try {
                if (!classFile.exists()) {
                    classFile.create((InputStream)new ByteArrayInputStream(bytes), true, null);
                } else {
                    classFile.setContents((InputStream)new ByteArrayInputStream(bytes), true, true, null);
                }
            }
            catch (CoreException e) {
                JavascriptBuilder.createMarker((IResource)jsFile, null, e.getMessage(), 2);
            }
            i += 2;
        }
    }

    public static IMarker createMarker(IResource resource, String problemType, String message, int severity) {
        IMarker marker = null;
        try {
            marker = resource.createMarker("org.eclipse.core.resources.problemmarker");
            marker.setAttribute("message", (Object)message);
            marker.setAttribute("severity", severity);
            int priority = 1;
            if (severity == 0) {
                priority = 0;
            } else if (severity == 2) {
                priority = 2;
            }
            marker.setAttribute("priority", priority);
        }
        catch (CoreException coreException) {}
        return marker;
    }
}

