/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tm.ui;

import java.util.Iterator;
import java.util.StringTokenizer;
import org.eclipse.e4.tm.builder.IBuilderListener;
import org.eclipse.e4.tm.ui.EditingDomainModelContext;
import org.eclipse.e4.tm.ui.TmLabelProvider;
import org.eclipse.e4.tm.ui.TmPartStyle;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EcorePaletteView
extends ViewPart {
    private TmPartStyle partStyle = new TmPartStyle.SashStyle();
    private EditingDomainModelContext editingDomainModelContext = new EditingDomainModelContext(this.partStyle);
    private TreeViewer viewer;
    public static final String FRAGMENT_SEPARATOR = "#";
    private static final String STORE_URIS = "EcorePaletteView.uris";
    private IAction deleteAction;

    public void createPartControl(Composite parent) {
        final Transfer[] dragTransfers = new Transfer[]{TextTransfer.getInstance()};
        final DragSourceListener dragSourceListener = new DragSourceListener(){
            private String uris;

            public void dragFinished(DragSourceEvent event) {
                this.uris = null;
            }

            public void dragSetData(DragSourceEvent event) {
                if (TextTransfer.getInstance().isSupportedType(event.dataType)) {
                    event.data = this.uris;
                }
            }

            public void dragStart(DragSourceEvent event) {
                Control control = ((DragSource)event.getSource()).getControl();
                this.uris = null;
                if (control == EcorePaletteView.this.viewer.getControl() && EcorePaletteView.this.viewer.getSelection() instanceof IStructuredSelection) {
                    this.uris = EcorePaletteView.this.getUriString(((IStructuredSelection)EcorePaletteView.this.viewer.getSelection()).iterator());
                } else {
                    Object controlData = control.getData("modelUri");
                    if (controlData != null) {
                        this.uris = controlData.toString();
                    }
                }
                event.doit = this.uris != null;
            }
        };
        this.editingDomainModelContext.addBuilderListener(new IBuilderListener(){

            public void objectHandled(int id, EObject eObject, Object object) {
                if (id == 1 && object instanceof Control) {
                    Control control = (Control)object;
                    DragSource ds = new DragSource(control, 1);
                    ds.setTransfer(dragTransfers);
                    ds.addDragListener(dragSourceListener);
                }
            }
        });
        this.editingDomainModelContext.createControls(parent);
        this.partStyle.getTreeParent().setLayout((Layout)new FillLayout());
        this.viewer = new TreeViewer(new Tree(this.partStyle.getTreeParent(), 516));
        this.viewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider(this.editingDomainModelContext.getAdapterFactory()));
        this.viewer.setLabelProvider((IBaseLabelProvider)new TmLabelProvider((ILabelProvider)new AdapterFactoryLabelProvider(this.editingDomainModelContext.getAdapterFactory())));
        this.viewer.setInput((Object)this.editingDomainModelContext.getResourceSet());
        this.viewer.addDragSupport(1, dragTransfers, dragSourceListener);
        final Transfer[] dropTransfers = new Transfer[]{FileTransfer.getInstance()};
        this.viewer.addDropSupport(5, dropTransfers, (DropTargetListener)new ViewerDropAdapter((Viewer)this.viewer){

            public boolean validateDrop(Object target, int operation, TransferData transferType) {
                this.setFeedbackEnabled(false);
                int i = 0;
                while (i < dropTransfers.length) {
                    if (dropTransfers[i].isSupportedType(transferType)) {
                        return true;
                    }
                    ++i;
                }
                return false;
            }

            public boolean performDrop(Object data) {
                boolean result = false;
                if (data instanceof String[]) {
                    String[] filenames = (String[])data;
                    int i = 0;
                    while (i < filenames.length) {
                        result |= EcorePaletteView.this.editingDomainModelContext.addResource(URI.createFileURI((String)filenames[i]));
                        ++i;
                    }
                }
                return result;
            }
        });
        this.createActions();
        this.createMenu();
        this.createToolbar();
    }

    public void dispose() {
        this.editingDomainModelContext.dispose();
        super.dispose();
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    private String getUriString(Iterator<?> it) {
        String uris = null;
        while (it.hasNext()) {
            Object o = it.next();
            URI uri = null;
            if (o instanceof EObject) {
                uri = EcoreUtil.getURI((EObject)((EObject)o));
            } else if (o instanceof Resource) {
                uri = ((Resource)o).getURI();
            }
            if (uri == null) continue;
            uris = uris == null ? uri.toString() : String.valueOf(uris) + " " + uri;
        }
        return uris;
    }

    public void saveState(IMemento memento) {
        super.saveState(memento);
        memento.putString(STORE_URIS, this.getUriString(this.editingDomainModelContext.getResourceSet().getResources().iterator()));
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        String uris;
        super.init(site, memento);
        if (memento != null && (uris = memento.getString(STORE_URIS)) != null) {
            StringTokenizer tokens = new StringTokenizer(uris);
            while (tokens.hasMoreTokens()) {
                this.editingDomainModelContext.addResource(URI.createURI((String)tokens.nextToken()));
            }
        }
    }

    private void createActions() {
        this.deleteAction = new Action("Delete"){

            public void run() {
                ISelection selection = EcorePaletteView.this.viewer.getSelection();
                if (selection instanceof IStructuredSelection) {
                    for (Object o : (IStructuredSelection)selection) {
                        if (!(o instanceof Resource)) continue;
                        Resource resource = (Resource)o;
                        EcorePaletteView.this.editingDomainModelContext.getResourceSet().getResources().remove((Object)resource);
                    }
                }
            }
        };
    }

    private void createMenu() {
        IMenuManager menuManager = this.getViewSite().getActionBars().getMenuManager();
        menuManager.add(this.editingDomainModelContext.loadResourceAction);
    }

    private void createToolbar() {
        IToolBarManager toolBarManager = this.getViewSite().getActionBars().getToolBarManager();
        toolBarManager.add(this.editingDomainModelContext.loadResourceAction);
    }
}

