/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.resources.semantic.examples;

import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.semantic.ISemanticFolder;
import org.eclipse.core.resources.semantic.examples.Messages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class CreateRemotelyPage
extends WizardPage {
    public static final String PAGENAME = CreateRemotelyPage.class.getName();
    private final ISemanticFolder parentFolder;
    Text childNameText;
    Group fileContentGroup;
    Text fileContentText;
    Button addFile;
    boolean folderMode;
    String childName = "";
    String fileText = "";

    public CreateRemotelyPage(ISemanticFolder parent) {
        super(PAGENAME);
        this.parentFolder = parent;
    }

    public String getChildName() {
        return this.childName;
    }

    public String getContent() {
        return this.fileText;
    }

    public boolean isFolderMode() {
        return this.folderMode;
    }

    public void createControl(Composite parent) {
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)parent);
        final Composite myParent = new Composite(parent, 0);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)myParent);
        myParent.setLayout((Layout)new GridLayout(2, false));
        Label parentFolderLabel = new Label(myParent, 0);
        parentFolderLabel.setText(Messages.AddFileOrFolderFromRemotePage_ParentFolder_XFLD);
        Text parentPath = new Text(myParent, 2048);
        parentPath.setText(this.parentFolder.getAdaptedContainer().getFullPath().toString());
        parentPath.setEditable(false);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)parentPath);
        this.addFile = new Button(myParent, 16);
        this.addFile.setText(Messages.AddFileOrFolderFromRemotePage_File_XRBL);
        this.addFile.setSelection(!this.folderMode);
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)this.addFile);
        Button addFolder = new Button(myParent, 16);
        addFolder.setSelection(this.folderMode);
        addFolder.setText(Messages.AddFileOrFolderFromRemotePage_Folder_XRBL);
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)addFolder);
        this.addFile.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                CreateRemotelyPage.this.folderMode = !CreateRemotelyPage.this.addFile.getSelection();
                CreateRemotelyPage.this.check();
                GridData gd = (GridData)CreateRemotelyPage.this.fileContentGroup.getLayoutData();
                gd.exclude = CreateRemotelyPage.this.folderMode;
                CreateRemotelyPage.this.fileContentGroup.setVisible(!gd.exclude);
                CreateRemotelyPage.this.fileContentText.setEnabled(!gd.exclude);
                myParent.layout(true);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Label nameLabel = new Label(myParent, 0);
        nameLabel.setText(Messages.AddFileOrFolderFromRemotePage_ChildName_XFLD);
        this.childNameText = new Text(myParent, 2048);
        this.childNameText.setText(this.childName);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.childNameText);
        this.childNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CreateRemotelyPage.this.childName = CreateRemotelyPage.this.childNameText.getText();
                CreateRemotelyPage.this.check();
            }
        });
        this.fileContentGroup = new Group(myParent, 16);
        GridDataFactory.fillDefaults().span(2, 1).grab(true, true).applyTo((Control)this.fileContentGroup);
        this.fileContentGroup.setLayout((Layout)new GridLayout(2, false));
        this.fileContentGroup.setText(Messages.CreateRemotelyPage_FileContent_XGRP);
        Label fileContentLabel = new Label((Composite)this.fileContentGroup, 0);
        fileContentLabel.setText(Messages.CreateRemotelyPage_TextContent_XFLD);
        this.fileContentText = new Text((Composite)this.fileContentGroup, 2050);
        this.fileContentText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CreateRemotelyPage.this.fileText = CreateRemotelyPage.this.fileContentText.getText();
            }
        });
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.fileContentText);
        this.setMessage(Messages.AddFileOrFolderFromRemotePage_Select_XMSG);
        this.setControl((Control)myParent);
        this.setPageComplete(!this.childName.equals(""));
    }

    void check() {
        this.setErrorMessage(null);
        this.setPageComplete(false);
        if (this.childNameText.getText().equals("")) {
            this.setErrorMessage(Messages.AddFileOrFolderFromRemotePage_NameMissing_XMSG);
            return;
        }
        IPath validationPath = this.parentFolder.getAdaptedContainer().getFullPath().append(this.childNameText.getText());
        int type = this.folderMode ? 2 : 1;
        IStatus stat = ResourcesPlugin.getWorkspace().validatePath(validationPath.toString(), type);
        if (!stat.isOK()) {
            this.setErrorMessage(stat.getMessage());
            return;
        }
        try {
            if (this.parentFolder.hasResource(this.childNameText.getText())) {
                this.setErrorMessage(NLS.bind((String)Messages.AddFileOrFolderFromRemotePage_NameInUse_XMSG, (Object)this.childNameText.getText()));
                return;
            }
        }
        catch (CoreException coreException) {}
        this.setPageComplete(!this.childName.equals(""));
    }
}

