/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.forms;

import org.eclipse.e4.xwt.forms.XWTForms;
import org.eclipse.e4.xwt.forms.metaclass.FormMetaclass;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class ToolKitUtil {
    private static final String FORM_SIGNATURE_KEY = XWTForms.class.getName();

    public static synchronized FormToolkit getToolkit(Control c) {
        FormToolkit tk = ToolKitUtil.findToolkit(c);
        if (tk == null) {
            tk = new FormToolkit(c.getDisplay());
            c.getDisplay().setData(FormMetaclass.class.getName(), (Object)tk);
        }
        return tk;
    }

    public static synchronized FormToolkit findToolkit(Control c) {
        return (FormToolkit)c.getDisplay().getData(FormMetaclass.class.getName());
    }

    public static void tagForm(Control control) {
        control.setData(FORM_SIGNATURE_KEY, (Object)Boolean.TRUE);
    }

    public static void adapt(Control element) {
        FormToolkit tk = ToolKitUtil.getToolkit(element);
        if (tk != null && element.getData(FORM_SIGNATURE_KEY) != Boolean.TRUE) {
            tk.adapt(element, true, true);
        }
    }

    private static void adaptRecursive(Control root, FormToolkit tk) {
        if (root instanceof Composite) {
            if (root.getData(FORM_SIGNATURE_KEY) == Boolean.TRUE) {
                tk = ToolKitUtil.getToolkit(root);
            } else if (tk != null) {
                tk.adapt((Composite)root);
            }
            Control[] children = ((Composite)root).getChildren();
            if (root instanceof ExpandableComposite) {
                boolean firstLabel = true;
                int i = 0;
                while (i < children.length) {
                    Control child = children[i];
                    if (firstLabel) {
                        if (child instanceof Label) {
                            firstLabel = false;
                        }
                    } else {
                        ToolKitUtil.adaptRecursive(child, tk);
                    }
                    ++i;
                }
            } else {
                Control[] controlArray = children;
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    Control child = controlArray[n2];
                    ToolKitUtil.adaptRecursive(child, tk);
                    ++n2;
                }
            }
        } else if (root.getData(FORM_SIGNATURE_KEY) != Boolean.TRUE) {
            tk.adapt(root, true, true);
        }
    }
}

