/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tm.builder;

import java.util.List;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.eclipse.e4.tm.builder.AbstractBuilder;
import org.eclipse.e4.tm.builder.swt.SwtBuilder;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TmTestCase
extends TestCase {
    private Display display;
    private Shell shell;
    protected AbstractBuilder builder;

    protected void setUp() throws Exception {
        super.setUp();
        this.display = Display.getDefault();
        this.shell = new Shell(this.display);
        this.builder = this.createBuilder();
        URI binUri = URI.createURI((String)String.valueOf(((Object)((Object)this)).getClass().getResource(".")));
        String binUriString = binUri.toString();
        String pluginId = "org.eclipse.e4.tm.builder.tests";
        int pos = binUriString.indexOf(pluginId);
        if (pos >= 0) {
            String platformPrefix = String.valueOf(binUriString.substring(0, pos)) + pluginId + "/";
            this.builder.getUriConverter().getURIMap().put(URI.createURI((String)("platform:/plugin/" + pluginId + "/")), URI.createURI((String)platformPrefix));
        }
        this.shell.setSize(600, 600);
    }

    protected AbstractBuilder createBuilder() {
        return new SwtBuilder();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.shell.dispose();
        this.builder.dispose();
    }

    protected Composite getTopLevel() {
        return this.shell;
    }

    protected EObject getChild(EObject comp, int i, EClass c) {
        EList contents = comp.eContents();
        Assert.assertTrue((contents.size() > i ? 1 : 0) != 0);
        EObject child = (EObject)contents.get(i);
        Assert.assertEquals((Object)c, (Object)child.eClass());
        return child;
    }

    protected <T> T getChild(Composite comp, int i, Class<T> c, boolean assertClass) {
        Control[] children = comp.getChildren();
        Assert.assertTrue((children.length > i ? 1 : 0) != 0);
        Control control = children[i];
        if (!c.isInstance(control)) {
            Assert.fail();
        }
        if (assertClass) {
            Assert.assertEquals(c, control.getClass());
        }
        return (T)control;
    }

    protected <T> T getChild(Composite comp, int i, Class<T> c) {
        return this.getChild(comp, i, c, true);
    }

    protected <T> T getChild(int i, Class<T> c, boolean assertClass) {
        return this.getChild(this.getTopLevel(), i, c, assertClass);
    }

    protected <T> T getChild(int i, Class<T> c) {
        return this.getChild(i, c, true);
    }

    protected List getListFeature(EObject eObject, String featureName) {
        Object value = eObject.eGet(eObject.eClass().getEStructuralFeature(featureName));
        Assert.assertTrue((boolean)(value instanceof List));
        return (List)value;
    }

    protected Object setFeature(EObject eObject, String featureName, Object value) {
        eObject.eSet(eObject.eClass().getEStructuralFeature(featureName), value);
        return value;
    }

    protected Object getFeature(EObject eObject, String featureName) {
        return eObject.eGet(eObject.eClass().getEStructuralFeature(featureName));
    }

    public static void doRun(Class c) {
        TestRunner runner = new TestRunner();
        runner.doRun((Test)new TestSuite(c));
    }

    protected void testColor(Color col, int expectedRed, int expectedGreen, int expectedBlue) {
        Assert.assertEquals((int)expectedRed, (int)col.getRed());
        Assert.assertEquals((int)expectedGreen, (int)col.getGreen());
        Assert.assertEquals((int)expectedBlue, (int)col.getBlue());
    }

    protected void testColor(Color col1, Color expected) {
        this.testColor(col1, expected.getRed(), expected.getGreen(), expected.getBlue());
    }

    protected void testColor(Color col1, RGB expected) {
        this.testColor(col1, expected.red, expected.green, expected.blue);
    }

    protected void testStyle(Control control, int style) {
        Assert.assertTrue(((control.getStyle() & style) == style ? 1 : 0) != 0);
    }

    protected void testFont(Font font, String name, int style, int size) {
        FontData fontData = font.getFontData()[0];
        TmTestCase.assertEquals((String)name, (String)fontData.getName());
        TmTestCase.assertEquals((int)style, (int)fontData.getStyle());
        TmTestCase.assertEquals((int)size, (int)fontData.getHeight());
    }
}

