/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.runtime.internal.persistence.xp;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.platform.discovery.runtime.api.persistence.IMementoStoreProvider;
import org.eclipse.platform.discovery.runtime.internal.persistence.model.descriptions.IMementoStoreProviderDescription;
import org.eclipse.platform.discovery.runtime.internal.persistence.xp.IMementoStoreProviderExtensionParser;
import org.eclipse.platform.discovery.runtime.internal.xp.impl.AbstractExtensionPointParser;

public class MementoStoreProvidersExtensionParser
extends AbstractExtensionPointParser
implements IMementoStoreProviderExtensionParser {
    private static final String XP_ID = "org.eclipse.platform.discovery.integration.persistence.mementostoreprovider";
    private static final String XP_ELEMENT_NAME = "provider";
    private static final String CLASS_ATTR = "class";

    public MementoStoreProvidersExtensionParser() {
        super(Platform.getExtensionRegistry(), XP_ID, XP_ELEMENT_NAME);
    }

    @Override
    public Set<IMementoStoreProviderDescription> readContributions() {
        HashSet<IMementoStoreProviderDescription> result = new HashSet<IMementoStoreProviderDescription>();
        for (IConfigurationElement element : this.getConfigurationElements()) {
            result.add(this.createMementoStoreProvider(element));
        }
        return result;
    }

    private IMementoStoreProviderDescription createMementoStoreProvider(final IConfigurationElement element) {
        return new IMementoStoreProviderDescription(){

            @Override
            public IMementoStoreProvider createInstance() {
                try {
                    return (IMementoStoreProvider)element.createExecutableExtension(MementoStoreProvidersExtensionParser.CLASS_ATTR);
                }
                catch (CoreException e) {
                    throw new IllegalStateException("Store provider could not be instantiated", e);
                }
            }
        };
    }
}

