/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources.semantic.ui.team;

import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.internal.resources.semantic.ui.sync.SemanticSubscriber;
import org.eclipse.core.internal.resources.semantic.ui.team.Messages;
import org.eclipse.core.internal.resources.semantic.ui.team.SemanticFileRevisionSelectionDialog;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.semantic.ISemanticResource;
import org.eclipse.core.resources.semantic.spi.ISemanticFileStore;
import org.eclipse.core.resources.semantic.spi.SemanticFileRevision;
import org.eclipse.core.resources.semantic.spi.SemanticResourceVariantComparator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.MenuDetectEvent;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.history.IFileHistory;
import org.eclipse.team.core.history.IFileHistoryProvider;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.core.variants.IResourceVariant;
import org.eclipse.team.core.variants.IResourceVariantComparator;
import org.eclipse.team.ui.history.HistoryPage;
import org.eclipse.team.ui.synchronize.SyncInfoCompareInput;

public class SemanticHistoryPage
extends HistoryPage {
    private static final String EMPTY = "";
    private Composite main;
    TableViewer tv;
    private final IStructuredContentProvider contentProvider = new IStructuredContentProvider(){

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object inputElement) {
            ArrayList<IFileRevision> sortable = new ArrayList<IFileRevision>();
            if (inputElement != null) {
                IFileRevision[] history;
                IFileRevision[] iFileRevisionArray = history = ((IFileHistory)inputElement).getFileRevisions();
                int n = history.length;
                int n2 = 0;
                while (n2 < n) {
                    IFileRevision rev = iFileRevisionArray[n2];
                    sortable.add(rev);
                    ++n2;
                }
                Collections.sort(sortable, new Comparator<IFileRevision>(){

                    @Override
                    public int compare(IFileRevision o1, IFileRevision o2) {
                        return (int)(o2.getTimestamp() - o1.getTimestamp());
                    }
                });
                return sortable.toArray();
            }
            return new Object[0];
        }
    };

    public SemanticHistoryPage(IResource object) {
    }

    public boolean inputSet() {
        if (!(this.getInput() instanceof IFile)) {
            this.tv.setInput(null);
        } else {
            IFile input = (IFile)this.getInput();
            RepositoryProvider repositoryProvider = RepositoryProvider.getProvider((IProject)input.getProject(), (String)"org.eclipse.core.internal.resources.semantic.DelegatingRepositoryProvider");
            IFileHistoryProvider historyProvider = repositoryProvider.getFileHistoryProvider();
            IFileHistory history = historyProvider.getFileHistoryFor((IResource)input, 0, null);
            this.tv.setInput((Object)history);
        }
        return true;
    }

    public void createControl(Composite parent) {
        this.main = new Composite(parent, 0);
        this.main.setLayout((Layout)new GridLayout(2, false));
        this.tv = new TableViewer(this.main, 65538);
        final Table table = this.tv.getTable();
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)table);
        SemanticFileRevisionLabelProvider.initColumns(this.tv);
        this.tv.setContentProvider((IContentProvider)this.contentProvider);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        table.addMenuDetectListener(new MenuDetectListener(){

            public void menuDetected(MenuDetectEvent e) {
                SemanticHistoryPage.this.fillContextMenu(table);
            }
        });
    }

    void fillContextMenu(Table table) {
        Menu menu = new Menu((Control)table);
        final int count = ((IStructuredSelection)this.tv.getSelection()).size();
        try {
            MenuItem item;
            if (count == 1) {
                item = new MenuItem(menu, 8);
                item.setText(Messages.SemanticHistoryPage_Compare_XMIT);
            } else if (count == 2) {
                item = new MenuItem(menu, 8);
                item.setText(Messages.SemanticHistoryPage_ThreeWayCompare_XMIT);
            } else {
                return;
            }
            item.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent evt) {
                    try {
                        IFile file = (IFile)SemanticHistoryPage.this.getInput();
                        IFileRevision[] revs = new IFileRevision[2];
                        if (count == 2) {
                            Object[] selection = ((IStructuredSelection)SemanticHistoryPage.this.tv.getSelection()).toArray();
                            SemanticFileRevision[] revInput = new SemanticFileRevision[selection.length];
                            System.arraycopy(selection, 0, revInput, 0, selection.length);
                            SemanticFileRevisionSelectionDialog dialog = new SemanticFileRevisionSelectionDialog(SemanticHistoryPage.this.getSite().getShell(), revInput, Messages.SemanticHistoryPage_SelectCommonAncestor_XGRP);
                            if (dialog.open() != 0) {
                                return;
                            }
                            SemanticFileRevision ancestor = dialog.getSelection();
                            revs[0] = ancestor;
                            revs[1] = revInput[0] == ancestor ? revInput[1] : revInput[0];
                        } else {
                            revs[1] = (IFileRevision)((IStructuredSelection)SemanticHistoryPage.this.tv.getSelection()).getFirstElement();
                        }
                        ISemanticFileStore store = (ISemanticFileStore)EFS.getStore((URI)file.getLocationURI());
                        IResourceVariant[] var = SemanticSubscriber.toVariants(revs, store);
                        SyncInfo syncinfo = new SyncInfo((IResource)file, var[0], var[1], (IResourceVariantComparator)new SemanticResourceVariantComparator(var[0] != null));
                        syncinfo.init();
                        SyncInfoCompareInput input = new SyncInfoCompareInput(SemanticHistoryPage.EMPTY, syncinfo);
                        input.getCompareConfiguration().setLeftEditable(false);
                        CompareUI.openCompareEditor((CompareEditorInput)input);
                    }
                    catch (CoreException ex) {
                        throw new RuntimeException(ex);
                    }
                }

                public void widgetDefaultSelected(SelectionEvent evt) {
                }
            });
        }
        finally {
            table.setMenu(menu);
        }
    }

    public Control getControl() {
        return this.main;
    }

    public void setFocus() {
    }

    public String getDescription() {
        return Messages.SemanticHistoryPage_SemHistPage_XGRP;
    }

    public String getName() {
        return ((IResource)this.getInput()).getName();
    }

    public boolean isValidInput(Object object) {
        ISemanticResource res = (ISemanticResource)((IResource)object).getAdapter(ISemanticResource.class);
        return res != null;
    }

    public void refresh() {
        this.inputSet();
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public static final class SemanticFileRevisionLabelProvider
    extends BaseLabelProvider
    implements ITableLabelProvider {
        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            IFileRevision revision = (IFileRevision)element;
            switch (columnIndex) {
                case 0: {
                    if (revision.getContentIdentifier() == null) {
                        return SemanticHistoryPage.EMPTY;
                    }
                    return revision.getContentIdentifier();
                }
                case 1: {
                    long timestamp = revision.getTimestamp();
                    if (timestamp < 0L) {
                        return SemanticHistoryPage.EMPTY;
                    }
                    return new SimpleDateFormat().format(new Date(revision.getTimestamp()));
                }
                case 2: {
                    return revision.getAuthor();
                }
                case 3: {
                    String comment = revision.getComment();
                    if (comment != null) {
                        return comment;
                    }
                    return SemanticHistoryPage.EMPTY;
                }
            }
            return SemanticHistoryPage.EMPTY;
        }

        public static void initColumns(TableViewer viewer) {
            Table table = viewer.getTable();
            int colIndex = 0;
            TableColumn revName = new TableColumn(table, 0);
            revName.setText(Messages.SemanticHistoryPage_Revision_XCOL);
            revName.setWidth(100);
            SemanticFileRevisionLabelProvider.setSorter(viewer, revName, colIndex++);
            TableColumn revTime = new TableColumn(table, 0);
            revTime.setText(Messages.SemanticHistoryPage_Timestamp_XCOL);
            revTime.setWidth(150);
            SemanticFileRevisionLabelProvider.setSorter(viewer, revTime, colIndex++);
            TableColumn user = new TableColumn(table, 0);
            user.setText(Messages.SemanticHistoryPage_User_XCOL);
            user.setWidth(80);
            SemanticFileRevisionLabelProvider.setSorter(viewer, user, colIndex++);
            TableColumn comment = new TableColumn(table, 0);
            comment.setText(Messages.SemanticHistoryPage_Comment_XCOL);
            comment.setWidth(250);
            SemanticFileRevisionLabelProvider.setSorter(viewer, comment, colIndex++);
            viewer.setLabelProvider((IBaseLabelProvider)new SemanticFileRevisionLabelProvider());
        }

        private static void setSorter(TableViewer viewer, TableColumn actColumn, int colIndex) {
            new TableColumnSorter(viewer, actColumn, colIndex);
        }
    }

    private static class TableColumnSorter
    extends ViewerComparator {
        int direction = 0;
        private final TableColumn myColumn;
        final TableViewer myViewer;
        private final int myIndex;

        TableColumnSorter(TableViewer viewer, TableColumn column, int colIndex) {
            this.myViewer = viewer;
            this.myColumn = column;
            this.myIndex = colIndex;
            this.myColumn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (TableColumnSorter.this.myViewer.getComparator() != null) {
                        if (TableColumnSorter.this.myViewer.getComparator() == TableColumnSorter.this) {
                            int tdirection = TableColumnSorter.this.direction;
                            if (tdirection == 128) {
                                TableColumnSorter.this.setSorter(TableColumnSorter.this, 1024);
                            } else if (tdirection == 1024) {
                                TableColumnSorter.this.setSorter(TableColumnSorter.this, 0);
                            }
                        } else {
                            TableColumnSorter.this.setSorter(TableColumnSorter.this, 128);
                        }
                    } else {
                        TableColumnSorter.this.setSorter(TableColumnSorter.this, 128);
                    }
                }
            });
            this.setSorter(this, 128);
        }

        public void setSorter(TableColumnSorter sorter, int direction) {
            if (direction == 0) {
                this.myColumn.getParent().setSortColumn(null);
                this.myColumn.getParent().setSortDirection(0);
                this.myViewer.setComparator(null);
            } else {
                this.myColumn.getParent().setSortColumn(this.myColumn);
                sorter.direction = direction;
                if (direction == 128) {
                    this.myColumn.getParent().setSortDirection(1024);
                } else {
                    this.myColumn.getParent().setSortDirection(128);
                }
                if (this.myViewer.getComparator() == sorter) {
                    this.myViewer.refresh();
                } else {
                    this.myViewer.setComparator((ViewerComparator)sorter);
                }
            }
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            switch (this.direction) {
                case 128: {
                    return this.doCompare(e1, e2);
                }
                case 1024: {
                    return -1 * this.doCompare(e1, e2);
                }
            }
            return 0;
        }

        private int doCompare(Object e1, Object e2) {
            ITableLabelProvider lp = (ITableLabelProvider)this.myViewer.getLabelProvider();
            String t1 = lp.getColumnText(e1, this.myIndex);
            String t2 = lp.getColumnText(e2, this.myIndex);
            return t1.compareTo(t2);
        }
    }
}

