/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources.semantic.ui.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.internal.resources.semantic.ui.actions.ActionBase;
import org.eclipse.core.internal.resources.semantic.ui.actions.Messages;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.semantic.ISemanticResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;

public class RemoveAction
extends ActionBase {
    public void selectionChanged(IAction action, ISelection selection) {
        super.selectionChanged(action, selection);
        action.setEnabled(this.checkSelectionSemanticResource());
    }

    public void run(IAction action) {
        boolean askForForceRemoval = false;
        for (ISemanticResource resource : this.getSelection()) {
            IStatus status = resource.validateRemove(0, null);
            if (status.isOK()) continue;
            askForForceRemoval = true;
        }
        if (askForForceRemoval && !MessageDialog.openConfirm((Shell)this.getShell(), (String)Messages.RemoveAction_ConfirmResourceRemoval_XGRP, (String)Messages.RemoveAction_DoYouWantToRemove_XMSG)) {
            return;
        }
        IRunnableWithProgress outerRunnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor outerMonitor) throws InvocationTargetException, InterruptedException {
                for (final ISemanticResource resource : RemoveAction.this.getSelection()) {
                    outerMonitor.subTask(NLS.bind((String)Messages.RemoveAction_Removing_XMSG, (Object)resource.getAdaptedResource().getName()));
                    if (outerMonitor.isCanceled()) {
                        throw new InterruptedException();
                    }
                    IWorkspaceRunnable myRunnable = new IWorkspaceRunnable(){

                        public void run(IProgressMonitor monitor) throws CoreException {
                            resource.remove(0, monitor);
                        }
                    };
                    IWorkspace workspace = ResourcesPlugin.getWorkspace();
                    try {
                        workspace.run(myRunnable, workspace.getRuleFactory().refreshRule(resource.getAdaptedResource()), 0, null);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e, NLS.bind((String)Messages.RemoveAction_CouldNotRemoveResource_XMSG, (Object)resource.getAdaptedResource().getFullPath().toString()));
                    }
                }
            }
        };
        this.run(outerRunnable);
    }
}

