/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.integration.internal.viewcustomization;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.platform.discovery.core.api.ISearchContext;
import org.eclipse.platform.discovery.core.internal.favorites.IPersistenceUtil;
import org.eclipse.platform.discovery.integration.internal.plugin.DiscoveryIntegrationPlugin;
import org.eclipse.platform.discovery.integration.internal.viewcustomization.IConfigurableContributedAction;
import org.eclipse.platform.discovery.runtime.api.ISearchDestination;
import org.eclipse.platform.discovery.runtime.api.persistence.DestinationItemPair;
import org.eclipse.platform.discovery.runtime.internal.persistence.MementoContentManagerException;
import org.eclipse.platform.discovery.util.api.env.IErrorHandler;
import org.eclipse.platform.discovery.util.api.longop.ILongOperationRunner;
import org.eclipse.platform.discovery.util.internal.ContractChecker;
import org.eclipse.ui.WorkbenchException;

public class SaveInFavoritesContributedAction
implements IConfigurableContributedAction {
    public static final String ACTION_ID = "org.eclipse.platform.discovery.integration.internal.viewcustomization.SaveInFavoritesContributedAction";
    private ISearchContext searchContext;
    private IErrorHandler errorHandler;

    public Object getActionId() {
        return ACTION_ID;
    }

    public void perform(ILongOperationRunner operationRunner, Set<Object> selectedObjects) {
        ContractChecker.nullCheckField((Object)this.searchContext, (String)"searchContext");
        ContractChecker.nullCheckField((Object)this.errorHandler, (String)"errorHandler");
        IPersistenceUtil persistenceUtil = this.createPersistenceUtil();
        try {
            persistenceUtil.addItems(this.toPairs(selectedObjects, this.searchContext.searchParameters().getSearchDestination()), operationRunner);
        }
        catch (WorkbenchException e) {
            this.errorHandler.handleException((Exception)((Object)e));
        }
        catch (IOException e) {
            this.errorHandler.handleException((Exception)e);
        }
        catch (MementoContentManagerException e) {
            this.errorHandler.handleException((Exception)((Object)e));
        }
    }

    private Set<DestinationItemPair> toPairs(Set<Object> items, ISearchDestination destination) {
        HashSet<DestinationItemPair> result = new HashSet<DestinationItemPair>(items.size());
        for (Object o : items) {
            result.add(new DestinationItemPair(destination, o));
        }
        return result;
    }

    protected IPersistenceUtil createPersistenceUtil() {
        return DiscoveryIntegrationPlugin.getDefault().createFavoritesPersistenceUtil();
    }

    @Override
    public void setSearchContext(ISearchContext searchContext) {
        this.searchContext = searchContext;
    }

    @Override
    public void setErrorHandler(IErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }
}

