/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.tools.ui.designer.utils;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.e4.xwt.XWT;
import org.eclipse.e4.xwt.metadata.IMetaclass;
import org.eclipse.e4.xwt.metadata.IProperty;
import org.eclipse.e4.xwt.tools.ui.xaml.XamlAttribute;
import org.eclipse.e4.xwt.tools.ui.xaml.XamlElement;
import org.eclipse.e4.xwt.tools.ui.xaml.XamlNode;

public class XWTUtility {
    private static Map<String, IMetaclass> metaclassCache = new HashMap<String, IMetaclass>();

    public static IMetaclass getMetaclass(XamlNode node) {
        if (node == null) {
            return null;
        }
        if (node instanceof XamlElement) {
            XamlElement e = (XamlElement)node;
            String name = e.getName();
            String ns = e.getNamespace();
            return XWTUtility.getMetaclass(name, ns);
        }
        return null;
    }

    public static IMetaclass getMetaclass(String tagName, String ns) {
        String key;
        IMetaclass metaclass;
        if ("#comment".equals(tagName) || "Array".equals(tagName)) {
            return null;
        }
        if (tagName != null && tagName.length() > 1) {
            tagName = String.valueOf(Character.toUpperCase(tagName.charAt(0))) + tagName.substring(1);
        }
        if ((metaclass = metaclassCache.get(key = String.valueOf(tagName) + "=&&=" + ns)) == null) {
            try {
                metaclass = XWT.getMetaclass((String)tagName, (String)ns);
                metaclassCache.put(key, metaclass);
            }
            catch (Exception exception) {}
        }
        return metaclass;
    }

    public static IProperty getProperty(XamlNode node, String name) {
        IMetaclass metaclass = XWTUtility.getMetaclass(node);
        if (metaclass == null) {
            return null;
        }
        return metaclass.findProperty(name);
    }

    public static IProperty getProperty(XamlAttribute attribute) {
        if (attribute == null) {
            return null;
        }
        XamlNode node = (XamlNode)attribute.eContainer();
        return XWTUtility.getProperty(node, attribute.getName());
    }
}

