/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.tools.ui.designer.properties.tabbed.sections;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.e4.xwt.tools.ui.designer.databinding.BindingContext;
import org.eclipse.e4.xwt.tools.ui.designer.databinding.BindingInfo;
import org.eclipse.e4.xwt.tools.ui.designer.databinding.IObservable;
import org.eclipse.e4.xwt.tools.ui.designer.databinding.Observable;
import org.eclipse.e4.xwt.tools.ui.designer.databinding.ObservableUtil;
import org.eclipse.e4.xwt.tools.ui.designer.databinding.Property;
import org.eclipse.e4.xwt.tools.ui.designer.databinding.ui.ObserveModelGroup;
import org.eclipse.e4.xwt.tools.ui.designer.parts.WidgetEditPart;
import org.eclipse.e4.xwt.tools.ui.designer.resources.ImageShop;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class DataBindingSection
extends AbstractPropertySection {
    private ComboViewer propertiesComboViewer;
    private WidgetEditPart editPart;
    private ObserveModelGroup observeModelGroup;
    private Button bindButton;
    private List<BindingInfo> createdBindings;
    private BindingContext bindingContext;
    private boolean needToRefresh = false;

    public boolean isNeedToRefresh() {
        return this.needToRefresh;
    }

    public void setNeedToRefresh(boolean needToRefresh) {
        this.needToRefresh = needToRefresh;
    }

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        Composite composite = this.getWidgetFactory().createComposite(parent);
        composite.setLayout((Layout)new GridLayout(4, false));
        this.getWidgetFactory().createCLabel(composite, "Properties");
        CCombo propertiesCombo = this.getWidgetFactory().createCCombo(composite, 8);
        this.propertiesComboViewer = new ComboViewer(propertiesCombo);
        this.propertiesComboViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof IObservable) {
                    return ((IObservable)inputElement).getProperties();
                }
                return new Object[0];
            }
        });
        this.propertiesComboViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof Property) {
                    return ((Property)element).getName();
                }
                return super.getText(element);
            }

            public Image getImage(Object element) {
                if (element instanceof Property) {
                    return ImageShop.getImageForType(((Property)element).getType());
                }
                return super.getImage(element);
            }
        });
        this.propertiesComboViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                DataBindingSection.this.bindingContext.setTargetProperty((Property)selection.getFirstElement());
            }
        });
        this.bindButton = this.getWidgetFactory().createButton(composite, "Bind", 8);
        this.bindButton.setEnabled(false);
        this.bindButton.setImage(ImageShop.get("/icons/full/tools/binding/binding_add.png"));
        this.bindButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                DataBindingSection.this.createBinding();
            }
        });
        this.createClearAction(composite);
        this.bindingContext = new BindingContext();
        this.bindingContext.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                DataBindingSection.this.bindButton.setEnabled(DataBindingSection.this.bindingContext.isValid());
            }
        });
        this.observeModelGroup = new ObserveModelGroup(this.bindingContext, null);
        Composite modelsGroup = this.observeModelGroup.createGroup(composite, 2);
        GridData layoutData = new GridData(768);
        layoutData.horizontalSpan = 4;
        this.getWidgetFactory().adapt(modelsGroup);
        modelsGroup.setBackgroundMode(2);
        modelsGroup.setLayoutData((Object)layoutData);
    }

    public void setObserveModel(IObservable observeModel) {
        if (this.bindButton != null && !this.bindButton.isDisposed()) {
            this.bindButton.setEnabled(observeModel != null);
        }
    }

    protected void createBinding() {
        if (this.editPart == null || this.editPart.getWidget() == null) {
            return;
        }
        BindingInfo bindingInfo = new BindingInfo(this.bindingContext);
        Command bound = bindingInfo.bindWithCommand();
        this.editPart.getViewer().getEditDomain().getCommandStack().execute(bound);
        if (this.createdBindings == null) {
            this.createdBindings = new ArrayList<BindingInfo>();
        }
        this.createdBindings.add(bindingInfo);
    }

    protected void createClearAction(Composite parent) {
        ToolBar toolBar = new ToolBar(parent, 0x800000);
        toolBar.setBackground(parent.getDisplay().getSystemColor(1));
        ToolItem clearAction = new ToolItem(toolBar, 8);
        clearAction.setImage(ImageShop.get("/icons/full/tools/clear_filter.gif"));
        clearAction.setToolTipText("Clear setting values.");
        clearAction.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                DataBindingSection.this.deleteBinding();
            }
        });
    }

    protected void deleteBinding() {
        if (this.createdBindings == null) {
            return;
        }
        CompoundCommand commands = new CompoundCommand();
        for (BindingInfo binding : this.createdBindings) {
            commands.add(binding.deleteWithCommand());
        }
        this.editPart.getViewer().getEditDomain().getCommandStack().execute((Command)commands);
    }

    private EditPart getRoot(EditPart child) {
        if (child == null) {
            return null;
        }
        if (child instanceof WidgetEditPart && ((WidgetEditPart)child).isRoot()) {
            return child;
        }
        return this.getRoot(child.getParent());
    }

    public void refresh() {
        if (this.editPart == null || this.propertiesComboViewer == null || this.observeModelGroup == null) {
            return;
        }
        if (!this.isNeedToRefresh()) {
            return;
        }
        this.setNeedToRefresh(false);
        Widget widget = this.editPart.getWidget();
        if (widget == null || widget.isDisposed()) {
            return;
        }
        Observable observable = ObservableUtil.getObservable(widget);
        this.bindingContext.setTarget(observable);
        this.propertiesComboViewer.setInput((Object)observable);
        EditPart root = this.getRoot((EditPart)this.editPart);
        this.observeModelGroup.setRootEditPart(root);
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        Object object = ((IStructuredSelection)selection).getFirstElement();
        if (object instanceof WidgetEditPart) {
            this.editPart = (WidgetEditPart)((Object)object);
        }
        this.setNeedToRefresh(true);
    }
}

