/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.tools.ui.designer.dialogs;

import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.e4.xwt.utils.PathHelper;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.StandardJavaElementContentProvider;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class ImageDialog
extends Dialog {
    private IProject project;
    private IFile file;
    private String imagePath;
    private Label imageLabel;
    private Label previewLable;
    private Image image;

    public ImageDialog(Shell parentShell, IFile file) {
        super(parentShell);
        this.file = file;
        if (file != null) {
            this.project = file.getProject();
        }
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Image Dialog");
    }

    protected boolean isResizable() {
        return true;
    }

    protected Point getInitialSize() {
        Point point = super.getInitialSize();
        if (point.y < 343) {
            point.y = 343;
        }
        if (point.x < 440) {
            point.x = 440;
        }
        return point;
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = (GridLayout)dialogArea.getLayout();
        layout.numColumns = 2;
        Group leftComp = new Group(dialogArea, 0);
        leftComp.setText("types");
        layout = new GridLayout(2, false);
        leftComp.setLayout((Layout)layout);
        leftComp.setLayoutData((Object)new GridData(1808));
        final Button projRadio = new Button((Composite)leftComp, 16);
        projRadio.setText("Project");
        projRadio.setSelection(true);
        projRadio.setLayoutData((Object)new GridData(4));
        new Label((Composite)leftComp, 0);
        final Button fileRadio = new Button((Composite)leftComp, 16);
        fileRadio.setText("File System");
        fileRadio.setLayoutData((Object)new GridData(4));
        final Button browserButton = new Button((Composite)leftComp, 8);
        browserButton.setText("Browser");
        browserButton.setEnabled(false);
        Group previewer = new Group(dialogArea, 0);
        previewer.setText("Preview");
        previewer.setLayout((Layout)new FillLayout());
        this.previewLable = new Label((Composite)previewer, 0x1000004);
        GridData gd = new GridData(1808);
        previewer.setLayoutData((Object)gd);
        final TreeViewer viewer = new TreeViewer(dialogArea, 2048);
        GridData layoutData = new GridData(1808);
        layoutData.horizontalSpan = 2;
        viewer.getControl().setLayoutData((Object)layoutData);
        viewer.setContentProvider((IContentProvider)new ImageContentProvider());
        JavaElementLabelProvider labelProvider = new JavaElementLabelProvider(){

            public String getText(Object element) {
                String result = super.getText(element);
                if (element instanceof IPackageFragmentRoot) {
                    result = MessageFormat.format("{0} - {1}", result, ((IPackageFragmentRoot)element).getJavaProject().getElementName());
                }
                return result;
            }
        };
        viewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        if (this.project != null) {
            viewer.setInput((Object)JavaCore.create((IProject)this.project));
        }
        viewer.expandToLevel(2);
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)viewer.getSelection();
                Object firstElement = selection.getFirstElement();
                if (firstElement instanceof IFile) {
                    IPath fullPath = ((IFile)firstElement).getLocation();
                    String path = fullPath.toString();
                    if (ImageDialog.this.file != null) {
                        String sourcePath = ImageDialog.this.file.getLocation().toString();
                        path = PathHelper.getRelativePath((String)sourcePath, (String)path);
                    }
                    ImageDialog.this.setImagePath(path);
                }
            }
        });
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                ImageDialog.this.setImagePath(null);
                if (event.widget == projRadio) {
                    viewer.getControl().setEnabled(true);
                    browserButton.setEnabled(false);
                } else if (event.widget == fileRadio) {
                    viewer.getControl().setEnabled(false);
                    browserButton.setEnabled(true);
                } else if (event.widget == browserButton) {
                    ImageDialog.this.chooseImage();
                }
            }
        };
        projRadio.addListener(13, listener);
        fileRadio.addListener(13, listener);
        browserButton.addListener(13, listener);
        Composite bottomComp = new Composite(dialogArea, 0);
        layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        bottomComp.setLayout((Layout)layout);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        bottomComp.setLayoutData((Object)gd);
        new Label(bottomComp, 0).setText("Image:");
        this.imageLabel = new Label(bottomComp, 0);
        this.imageLabel.setLayoutData((Object)new GridData(768));
        return dialogArea;
    }

    protected void chooseImage() {
        FileDialog dialog = new FileDialog(this.getShell());
        dialog.setFilterExtensions(new String[]{"*.png", "*.gif", "*.*"});
        this.setImagePath(dialog.open());
    }

    private void setImagePath(String imagePath) {
        this.imagePath = imagePath;
        if (imagePath != null) {
            this.imageLabel.setText(imagePath);
        } else {
            this.imageLabel.setText("");
        }
        this.previewImage(imagePath);
    }

    private void previewImage(String imagePath) {
        if (this.image != null) {
            this.image.dispose();
        }
        if (imagePath == null) {
            this.previewLable.setImage(null);
        } else {
            String absolutePath;
            File imageFile = new File(imagePath);
            if (imageFile.exists()) {
                this.image = new Image(null, imageFile.getAbsolutePath());
            } else if (this.file != null && (imageFile = new File(absolutePath = PathHelper.getAbsolutePath((String)this.file.getLocation().toString(), (String)imagePath))).exists()) {
                this.image = new Image(null, imageFile.getAbsolutePath());
            }
        }
        if (this.image != null && !this.image.isDisposed()) {
            this.previewLable.setImage(this.image);
        }
    }

    public boolean close() {
        boolean close = super.close();
        if (this.image != null) {
            this.image.dispose();
        }
        return close;
    }

    public String getImagePath() {
        return this.imagePath;
    }

    private static class ImageContentProvider
    extends StandardJavaElementContentProvider {
        private ImageContentProvider() {
        }

        private boolean validRoot(IPackageFragmentRoot root) {
            return !root.isExternal() && !root.isArchive();
        }

        public Object[] getElements(Object inputElement) {
            try {
                if (inputElement instanceof IJavaProject) {
                    IPackageFragmentRoot[] roots = ((IJavaProject)inputElement).getAllPackageFragmentRoots();
                    ArrayList<IPackageFragmentRoot> newRoots = new ArrayList<IPackageFragmentRoot>(roots.length);
                    int i = 0;
                    while (i < roots.length) {
                        if (this.validRoot(roots[i])) {
                            newRoots.add(roots[i]);
                        }
                        ++i;
                    }
                    return newRoots.toArray();
                }
            }
            catch (JavaModelException javaModelException) {}
            return StandardJavaElementContentProvider.NO_CHILDREN;
        }

        public Object[] getChildren(Object parentElement) {
            try {
                if (parentElement instanceof IPackageFragmentRoot) {
                    return ((IPackageFragmentRoot)parentElement).getChildren();
                }
                if (parentElement instanceof IJavaElement) {
                    Object[] children = super.getChildren(parentElement);
                    ArrayList<Object> result = new ArrayList<Object>();
                    Object[] objectArray = children;
                    int n = children.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String ext;
                        Object child = objectArray[n2];
                        if (child instanceof IFile && (ext = ((IFile)child).getFileExtension()) != null && ("png".equals(ext) || "gif".equals(ext))) {
                            result.add(child);
                        }
                        ++n2;
                    }
                    return result.toArray(new Object[0]);
                }
            }
            catch (JavaModelException javaModelException) {}
            return StandardJavaElementContentProvider.NO_CHILDREN;
        }

        public boolean hasChildren(Object element) {
            return super.hasChildren(element);
        }

        protected Object skipProjectPackageFragmentRoot(IPackageFragmentRoot root) {
            return root;
        }
    }
}

