/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.tools.ui.designer.databinding;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.eclipse.e4.xwt.tools.ui.designer.databinding.IObservable;
import org.eclipse.e4.xwt.tools.ui.designer.databinding.Property;

public class BindingContext {
    private IObservable target;
    private Property targetProperty;
    private IObservable model;
    private Property modelProperty;
    private PropertyChangeSupport support = null;

    public BindingContext() {
        this(null, null, null, null);
    }

    public BindingContext(IObservable target, Property targetProperty, IObservable model, Property modelProperty) {
        this.target = target;
        this.targetProperty = targetProperty;
        this.model = model;
        this.modelProperty = modelProperty;
        this.support = new PropertyChangeSupport(this);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    public IObservable getTarget() {
        return this.target;
    }

    public void setTarget(IObservable target) {
        IObservable oldValue = this.target;
        this.target = target;
        this.support.firePropertyChange("target", oldValue, this.target);
    }

    public Property getTargetProperty() {
        return this.targetProperty;
    }

    public void setTargetProperty(Property targetProperty) {
        Property oldValue = this.targetProperty;
        this.targetProperty = targetProperty;
        this.support.firePropertyChange("targetProperty", oldValue, this.targetProperty);
    }

    public IObservable getModel() {
        return this.model;
    }

    public void setModel(IObservable model) {
        IObservable oldValue = this.model;
        this.model = model;
        this.support.firePropertyChange("model", oldValue, this.model);
    }

    public Property getModelProperty() {
        return this.modelProperty;
    }

    public void setModelProperty(Property modelProperty) {
        Property oldValue = this.modelProperty;
        this.modelProperty = modelProperty;
        this.support.firePropertyChange("modelProperty", oldValue, this.modelProperty);
    }

    public boolean isValid() {
        boolean valid;
        boolean bl = valid = this.model != null && this.modelProperty != null && this.target != null && this.targetProperty != null;
        if (valid && this.modelProperty.equals(this.targetProperty)) {
            return !this.model.equals(this.target);
        }
        return valid;
    }
}

