/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolox.nodes;

import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.util.PAffineTransform;
import edu.umd.cs.piccolo.util.PPaintContext;
import edu.umd.cs.piccolo.util.PUtil;
import edu.umd.cs.piccolox.util.MutablePoints;
import edu.umd.cs.piccolox.util.Points;
import edu.umd.cs.piccolox.util.XYArray;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.eclipse.e4.tm.graphics.util.Point;
import org.eclipse.e4.tm.graphics.util.Rectangle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.LineAttributes;
import org.eclipse.swt.graphics.RGB;

public class PLine
extends PNode {
    private static final PAffineTransform TEMP_TRANSFORM = new PAffineTransform();
    private static final LineAttributes DEFAULT_STROKE = new LineAttributes(1.0f);
    private static final RGB DEFAULT_STROKE_PAINT = new RGB(0, 0, 0);
    private transient MutablePoints line;
    private LineAttributes stroke;
    private Color strokePaint = this.createColor(DEFAULT_STROKE_PAINT);

    public PLine(MutablePoints line) {
        this.stroke = DEFAULT_STROKE;
        if (line == null) {
            line = new XYArray();
        }
        this.line = line;
    }

    public PLine() {
        this(null);
    }

    public PLine(MutablePoints line, LineAttributes aStroke) {
        this(line);
        this.stroke = aStroke;
    }

    public Color getStrokePaint() {
        return this.strokePaint;
    }

    public void setStrokePaint(Color aPaint) {
        Color old = this.strokePaint;
        this.strokePaint = aPaint;
        this.invalidatePaint();
        this.firePropertyChange(65536, "strokePaint", old, this.strokePaint);
    }

    public LineAttributes getStroke() {
        return this.stroke;
    }

    public void setStroke(LineAttributes aStroke) {
        LineAttributes old = this.stroke;
        this.stroke = aStroke;
        this.updateBoundsFromLine();
        this.invalidatePaint();
        this.firePropertyChange(131072, "stroke", old, this.stroke);
    }

    public boolean setBounds(double x, double y, double width, double height) {
        if (this.line == null || !super.setBounds(x, y, width, height)) {
            return false;
        }
        Rectangle lineBounds = this.line.getBounds(new Rectangle());
        Rectangle lineStrokeBounds = this.getLineBoundsWithStroke();
        double strokeOutset = Math.max(lineStrokeBounds.getWidth() - lineBounds.getWidth(), lineStrokeBounds.getHeight() - lineBounds.getHeight());
        TEMP_TRANSFORM.setToIdentity();
        TEMP_TRANSFORM.translate(x += strokeOutset / 2.0, y += strokeOutset / 2.0);
        TEMP_TRANSFORM.scale((width -= strokeOutset) / lineBounds.getWidth(), (height -= strokeOutset) / lineBounds.getHeight());
        TEMP_TRANSFORM.translate(-lineBounds.getX(), -lineBounds.getY());
        this.line.transformPoints(TEMP_TRANSFORM);
        return true;
    }

    private Rectangle getLineBounds(Points line, Rectangle dest, LineAttributes stroke) {
        if (dest == null) {
            dest = new Rectangle();
        }
        line.getBounds(dest);
        PPath.adjustForStroke(dest, stroke);
        return dest;
    }

    public Rectangle getLineBoundsWithStroke() {
        return this.getLineBounds(this.line, null, this.stroke);
    }

    public void updateBoundsFromLine() {
        if (this.line.getPointCount() == 0) {
            this.resetBounds();
        } else {
            super.setBounds(this.getLineBoundsWithStroke());
        }
    }

    protected void paint(PPaintContext paintContext) {
        GC g2 = paintContext.getGraphics();
        if (this.stroke != null && this.strokePaint != null && this.line.getPointCount() > 0) {
            g2.setForeground(this.strokePaint);
            g2.setLineAttributes(this.stroke);
            double x1 = this.line.getX(0);
            double y1 = this.line.getY(0);
            int i = 1;
            while (i < this.line.getPointCount()) {
                double x2 = this.line.getX(i);
                double y2 = this.line.getY(i);
                g2.drawLine((int)x1, (int)y1, (int)x2, (int)y2);
                x1 = x2;
                y1 = y2;
                ++i;
            }
        }
    }

    public Points getLineReference() {
        return this.line;
    }

    public int getPointCount() {
        return this.line.getPointCount();
    }

    public Point getPoint(int i, Point dst) {
        if (dst == null) {
            dst = new Point();
        }
        return this.line.getPoint(i, dst);
    }

    protected void lineChanged() {
        this.firePropertyChange(262144, "path", null, this.line);
        this.updateBoundsFromLine();
        this.invalidatePaint();
    }

    public void setPoint(int i, double x, double y) {
        this.line.setPoint(i, x, y);
        this.lineChanged();
    }

    public void addPoint(int i, double x, double y) {
        this.line.addPoint(i, x, y);
        this.lineChanged();
    }

    public void removePoints(int i, int n) {
        this.line.removePoints(i, n);
        this.lineChanged();
    }

    public void removeAllPoints() {
        this.line.removePoints(0, this.line.getPointCount());
        this.lineChanged();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        PUtil.writeStroke(this.stroke, out);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.stroke = PUtil.readStroke(in);
    }
}

