/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolo.util;

import edu.umd.cs.piccolo.PCamera;
import edu.umd.cs.piccolo.util.PAffineTransform;
import edu.umd.cs.piccolo.util.PStack;
import org.eclipse.e4.tm.graphics.util.Point;
import org.eclipse.e4.tm.graphics.util.Transform;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;

public class PPaintContext {
    public static final int LOW_QUALITY_RENDERING = 0;
    public static final int HIGH_QUALITY_RENDERING = 1;
    public static PPaintContext CURRENT_PAINT_CONTEXT;
    private GC graphics;
    protected PStack compositeStack;
    protected PStack clipStack;
    protected PStack localClipStack;
    protected PStack cameraStack;
    protected PStack transformStack;
    protected int renderQuality;
    private static double[] tempDoubles4;
    private static org.eclipse.swt.graphics.Transform tempSwtTransform;
    private static float[] tempFloats6;
    private static Transform tempTransform;

    static {
        tempDoubles4 = new double[4];
        tempSwtTransform = new org.eclipse.swt.graphics.Transform(null);
        tempFloats6 = new float[6];
        tempTransform = new Transform();
    }

    public PPaintContext(GC aGraphics) {
        this.graphics = aGraphics;
        this.compositeStack = new PStack();
        this.clipStack = new PStack();
        this.localClipStack = new PStack();
        this.cameraStack = new PStack();
        this.transformStack = new PStack();
        Rectangle clip = aGraphics.getClipping();
        if (clip == null) {
            clip = new Rectangle(-1073741823, -1073741823, Integer.MAX_VALUE, Integer.MAX_VALUE);
            aGraphics.setClipping(clip);
        }
        this.localClipStack.push(new org.eclipse.e4.tm.graphics.util.Rectangle(clip.x, clip.y, clip.width, clip.height));
        CURRENT_PAINT_CONTEXT = this;
    }

    public GC getGraphics() {
        return this.graphics;
    }

    public org.eclipse.e4.tm.graphics.util.Rectangle getLocalClip() {
        return (org.eclipse.e4.tm.graphics.util.Rectangle)this.localClipStack.peek();
    }

    public double getScale() {
        PPaintContext.tempDoubles4[0] = 0.0;
        PPaintContext.tempDoubles4[1] = 0.0;
        PPaintContext.tempDoubles4[2] = 1.0;
        PPaintContext.tempDoubles4[3] = 0.0;
        Transform t = PPaintContext.getTransform(this.graphics, tempTransform);
        t.transform(tempDoubles4, 0, tempDoubles4, 0, 2);
        return Point.distance(tempDoubles4[0], tempDoubles4[1], tempDoubles4[2], tempDoubles4[3]);
    }

    public static Transform getTransform(GC graphics, Transform dest) {
        if (dest == null) {
            dest = new Transform();
        }
        graphics.getTransform(tempSwtTransform);
        tempSwtTransform.getElements(tempFloats6);
        return dest.setTransform(tempFloats6[0], tempFloats6[2], tempFloats6[1], tempFloats6[3], tempFloats6[4], tempFloats6[5]);
    }

    public static org.eclipse.swt.graphics.Transform setTransform(Transform transform, GC graphics) {
        org.eclipse.swt.graphics.Transform swtTransform = new org.eclipse.swt.graphics.Transform(null, (float)transform.a11, (float)transform.a12, (float)transform.a21, (float)transform.a22, (float)transform.b1, (float)transform.b2);
        graphics.setTransform(swtTransform);
        return swtTransform;
    }

    public void pushCamera(PCamera aCamera) {
        this.cameraStack.push(aCamera);
    }

    public void popCamera(PCamera aCamera) {
        this.cameraStack.pop();
    }

    public PCamera getCamera() {
        return (PCamera)this.cameraStack.peek();
    }

    public void pushClip(org.eclipse.e4.tm.graphics.util.Rectangle aClip) {
        Rectangle currentClip = this.graphics.getClipping();
        this.clipStack.push(new org.eclipse.e4.tm.graphics.util.Rectangle(currentClip.x, currentClip.y, currentClip.width, currentClip.height));
        org.eclipse.e4.tm.graphics.util.Rectangle newLocalClip = new org.eclipse.e4.tm.graphics.util.Rectangle(aClip);
        org.eclipse.e4.tm.graphics.util.Rectangle.intersect(this.getLocalClip(), newLocalClip, newLocalClip);
        this.graphics.setClipping((int)newLocalClip.x, (int)newLocalClip.y, (int)newLocalClip.width, (int)newLocalClip.height);
        this.localClipStack.push(newLocalClip);
    }

    public void popClip(org.eclipse.e4.tm.graphics.util.Rectangle aClip) {
        org.eclipse.e4.tm.graphics.util.Rectangle newClip = (org.eclipse.e4.tm.graphics.util.Rectangle)this.clipStack.pop();
        this.graphics.setClipping((int)newClip.x, (int)newClip.y, (int)newClip.width, (int)newClip.height);
        this.localClipStack.pop();
    }

    public void pushTransparency(float transparency) {
        if (transparency == 1.0f) {
            return;
        }
        int current = this.graphics.getAlpha();
        this.compositeStack.push(current);
        this.graphics.setAlpha((int)(transparency * 255.0f));
    }

    public void popTransparency(float transparency) {
        if (transparency == 1.0f) {
            return;
        }
        int c = (Integer)this.compositeStack.pop();
        this.graphics.setAlpha(c);
    }

    public void pushTransform(PAffineTransform aTransform) {
        if (aTransform == null) {
            return;
        }
        org.eclipse.e4.tm.graphics.util.Rectangle newLocalClip = (org.eclipse.e4.tm.graphics.util.Rectangle)this.getLocalClip().clone();
        aTransform.inverseTransform(newLocalClip, newLocalClip);
        Transform transform = PPaintContext.getTransform(this.graphics, tempTransform);
        this.transformStack.push(new Transform(transform));
        this.localClipStack.push(newLocalClip);
        PPaintContext.setTransform(transform.concatenate(aTransform), this.graphics);
    }

    public void popTransform(PAffineTransform aTransform) {
        if (aTransform == null) {
            return;
        }
        Transform transform = (Transform)this.transformStack.pop();
        this.graphics.setTransform(new org.eclipse.swt.graphics.Transform(this.graphics.getDevice(), (float)transform.a11, (float)transform.a12, (float)transform.a21, (float)transform.a22, (float)transform.b1, (float)transform.b2));
        this.localClipStack.pop();
    }

    public int getRenderQuality() {
        return this.renderQuality;
    }

    public void setRenderQuality(int requestedQuality) {
        this.renderQuality = requestedQuality;
        switch (this.renderQuality) {
            case 1: {
                break;
            }
        }
    }
}

