/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolo.util;

import edu.umd.cs.piccolo.util.PBounds;
import org.eclipse.e4.tm.graphics.util.Dimension;
import org.eclipse.e4.tm.graphics.util.Point;
import org.eclipse.e4.tm.graphics.util.Rectangle;
import org.eclipse.e4.tm.graphics.util.Transform;

public class PAffineTransform
extends Transform {
    private static double[] PTS1 = new double[8];
    private static double[] PTS2 = new double[8];

    public PAffineTransform() {
    }

    public PAffineTransform(double[] flatmatrix) {
        super(flatmatrix);
    }

    public PAffineTransform(float[] flatmatrix) {
        super(flatmatrix);
    }

    public PAffineTransform(double m00, double m10, double m01, double m11, double m02, double m12) {
        super(m00, m10, m01, m11, m02, m12);
    }

    public PAffineTransform(float m00, float m10, float m01, float m11, float m02, float m12) {
        super(m00, m10, m01, m11, m02, m12);
    }

    public PAffineTransform(Transform tx) {
        super(tx);
    }

    public void scaleAboutPoint(double scale, double x, double y) {
        this.translate(x, y);
        this.scale(scale, scale);
        this.translate(-x, -y);
    }

    public double getScale() {
        PAffineTransform.PTS1[0] = 0.0;
        PAffineTransform.PTS1[1] = 0.0;
        PAffineTransform.PTS1[2] = 1.0;
        PAffineTransform.PTS1[3] = 0.0;
        this.transform(PTS1, 0, PTS2, 0, 2);
        return Point.distance(PTS2[0], PTS2[1], PTS2[2], PTS2[3]);
    }

    public void setScale(double scale) {
        if (scale == 0.0) {
            throw new RuntimeException("Can't set scale to 0");
        }
        this.scaleAboutPoint(scale / this.getScale(), 0.0, 0.0);
    }

    public void setOffset(double tx, double ty) {
        this.setTransform(this.getScaleX(), this.getShearY(), this.getShearX(), this.getScaleY(), tx, ty);
    }

    public double getRotation() {
        PAffineTransform.PTS1[0] = 0.0;
        PAffineTransform.PTS1[1] = 0.0;
        PAffineTransform.PTS1[2] = 1.0;
        PAffineTransform.PTS1[3] = 0.0;
        this.transform(PTS1, 0, PTS2, 0, 2);
        double dy = Math.abs(PTS2[3] - PTS2[1]);
        double l = Point.distance(PTS2[0], PTS2[1], PTS2[2], PTS2[3]);
        double rotation = Math.asin(dy / l);
        if (PTS2[3] - PTS2[1] > 0.0) {
            if (PTS2[2] - PTS2[0] < 0.0) {
                rotation = Math.PI - rotation;
            }
        } else {
            rotation = PTS2[2] - PTS2[0] > 0.0 ? Math.PI * 2 - rotation : (rotation += Math.PI);
        }
        return rotation;
    }

    public void setRotation(double theta) {
        this.rotate(theta - this.getRotation());
    }

    public Dimension transform(Dimension dimSrc, Dimension dimDst) {
        if (dimDst == null) {
            dimDst = (Dimension)dimSrc.clone();
        }
        PAffineTransform.PTS1[0] = dimSrc.getWidth();
        PAffineTransform.PTS1[1] = dimSrc.getHeight();
        this.deltaTransform(PTS1, 0, PTS2, 0, 1);
        dimDst.setSize(PTS2[0], PTS2[1]);
        return dimDst;
    }

    public Dimension inverseTransform(Dimension dimSrc, Dimension dimDst) {
        if (dimDst == null) {
            dimDst = (Dimension)dimSrc.clone();
        }
        double width = dimSrc.getWidth();
        double height = dimSrc.getHeight();
        double det = this.a11 * this.a22 - this.a12 * this.a21;
        try {
            if (Math.abs(det) <= Double.MIN_VALUE) {
                throw new Exception(this + " is not invertible");
            }
            dimDst.setSize((width * this.a22 - height * this.a12) / det, (height * this.a11 - width * this.a21) / det);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dimDst;
    }

    public Rectangle transform(Rectangle rectSrc, Rectangle rectDst) {
        if (rectDst == null) {
            rectDst = (Rectangle)rectSrc.clone();
        }
        if (rectSrc.isEmpty()) {
            rectDst.setRect(rectSrc);
            if (rectDst instanceof PBounds) {
                ((PBounds)rectDst).reset();
            }
            return rectDst;
        }
        switch (this.getType()) {
            case 0: {
                if (rectSrc == rectDst) break;
                rectDst.setRect(rectSrc);
                break;
            }
            case 1: {
                rectDst.setRect(rectSrc.getX() + this.getTranslateX(), rectSrc.getY() + this.getTranslateY(), rectSrc.getWidth(), rectSrc.getHeight());
                break;
            }
            case 2: {
                double scale = this.getScaleX();
                rectDst.setRect(rectSrc.getX() * scale, rectSrc.getY() * scale, rectSrc.getWidth() * scale, rectSrc.getHeight() * scale);
                break;
            }
            case 3: {
                double scale = this.getScaleX();
                rectDst.setRect(rectSrc.getX() * scale + this.getTranslateX(), rectSrc.getY() * scale + this.getTranslateY(), rectSrc.getWidth() * scale, rectSrc.getHeight() * scale);
                break;
            }
            default: {
                double[] pts = PAffineTransform.rectToArray(rectSrc);
                this.transform(pts, 0, pts, 0, 4);
                PAffineTransform.rectFromArray(rectDst, pts);
            }
        }
        return rectDst;
    }

    public Rectangle inverseTransform(Rectangle rectSrc, Rectangle rectDst) {
        if (rectDst == null) {
            rectDst = (Rectangle)rectSrc.clone();
        }
        if (rectSrc.isEmpty()) {
            rectDst.setRect(rectSrc);
            if (rectDst instanceof PBounds) {
                ((PBounds)rectDst).reset();
            }
            return rectDst;
        }
        switch (this.getType()) {
            case 0: {
                if (rectSrc == rectDst) break;
                rectDst.setRect(rectSrc);
                break;
            }
            case 1: {
                rectDst.setRect(rectSrc.getX() - this.getTranslateX(), rectSrc.getY() - this.getTranslateY(), rectSrc.getWidth(), rectSrc.getHeight());
                break;
            }
            case 2: {
                double scale = 1.0 / this.getScaleX();
                rectDst.setRect(rectSrc.getX() * scale, rectSrc.getY() * scale, rectSrc.getWidth() * scale, rectSrc.getHeight() * scale);
                break;
            }
            case 3: {
                double scale = 1.0 / this.getScaleX();
                rectDst.setRect((rectSrc.getX() - this.getTranslateX()) * scale, (rectSrc.getY() - this.getTranslateY()) * scale, rectSrc.getWidth() * scale, rectSrc.getHeight() * scale);
                break;
            }
            default: {
                double[] pts = PAffineTransform.rectToArray(rectSrc);
                try {
                    this.inverseTransform(pts, 0, pts, 0, 4);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                PAffineTransform.rectFromArray(rectDst, pts);
            }
        }
        return rectDst;
    }

    private static double[] rectToArray(Rectangle aRectangle) {
        PAffineTransform.PTS1[0] = aRectangle.getX();
        PAffineTransform.PTS1[1] = aRectangle.getY();
        PAffineTransform.PTS1[2] = PTS1[0] + aRectangle.getWidth();
        PAffineTransform.PTS1[3] = PTS1[1];
        PAffineTransform.PTS1[4] = PTS1[0] + aRectangle.getWidth();
        PAffineTransform.PTS1[5] = PTS1[1] + aRectangle.getHeight();
        PAffineTransform.PTS1[6] = PTS1[0];
        PAffineTransform.PTS1[7] = PTS1[1] + aRectangle.getHeight();
        return PTS1;
    }

    private static void rectFromArray(Rectangle aRectangle, double[] pts) {
        double minX = pts[0];
        double minY = pts[1];
        double maxX = pts[0];
        double maxY = pts[1];
        int i = 1;
        while (i < 4) {
            double x = pts[2 * i];
            double y = pts[2 * i + 1];
            if (x < minX) {
                minX = x;
            }
            if (y < minY) {
                minY = y;
            }
            if (x > maxX) {
                maxX = x;
            }
            if (y > maxY) {
                maxY = y;
            }
            ++i;
        }
        aRectangle.setRect(minX, minY, maxX - minX, maxY - minY);
    }
}

