/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolo.nodes;

import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolo.util.PPaintContext;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.Rectangle;

public class PImage
extends PNode {
    public static final String PROPERTY_IMAGE = "image";
    public static final int PROPERTY_CODE_IMAGE = 32768;
    private transient Image image;

    public PImage() {
    }

    public PImage(Image newImage) {
        this();
        this.setImage(newImage);
    }

    public PImage(String fileName) {
        this();
        ImageData[] imageData = new ImageLoader().load(fileName);
        this.setImage(imageData);
    }

    private void setImage(ImageData[] imageData) {
        if (imageData.length > 0 && imageData[0] != null) {
            this.setImage(new Image((Device)this.getDisplay(), imageData[0]));
        }
    }

    public PImage(URL url) {
        this();
        ImageData[] imageData = null;
        if (url != null) {
            try {
                imageData = new ImageLoader().load(url.openStream());
            }
            catch (IOException e) {
                System.err.println("Couldn't load image data from " + url + ": " + e);
            }
        }
        this.setImage(imageData);
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(String fileName) {
        this.setImage(new ImageLoader().load(fileName));
    }

    public void setImage(Image newImage) {
        Image old = this.image;
        this.image = newImage;
        if (this.image != null) {
            Rectangle bounds = this.image.getBounds();
            this.setBounds(0.0, 0.0, bounds.width, bounds.height);
            this.invalidatePaint();
        }
        this.firePropertyChange(32768, PROPERTY_IMAGE, old, this.image);
    }

    protected void paint(PPaintContext paintContext) {
        if (this.getImage() != null) {
            Rectangle imageBounds = this.image.getBounds();
            PBounds bounds = this.getBoundsReference();
            GC g2 = paintContext.getGraphics();
            if (bounds.x != 0.0 || bounds.y != 0.0 || bounds.width != (double)imageBounds.width || bounds.height != (double)imageBounds.height) {
                g2.drawImage(this.image, 0, 0, imageBounds.width, imageBounds.height, (int)bounds.x, (int)bounds.y, (int)this.getWidth(), (int)this.getHeight());
            } else {
                g2.drawImage(this.image, 0, 0);
            }
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    protected String paramString() {
        StringBuffer result = new StringBuffer();
        result.append("image=" + (this.image == null ? "null" : this.image.toString()));
        result.append(',');
        result.append(super.paramString());
        return result.toString();
    }
}

