/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolo.event;

import edu.umd.cs.piccolo.PCamera;
import edu.umd.cs.piccolo.event.PDragSequenceEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.event.PInputEventFilter;
import edu.umd.cs.piccolo.util.PBounds;
import org.eclipse.e4.tm.graphics.util.Dimension;
import org.eclipse.e4.tm.graphics.util.Point;

public class PPanEventHandler
extends PDragSequenceEventHandler {
    private boolean autopan;
    private double minAutopanSpeed = 250.0;
    private double maxAutopanSpeed = 750.0;

    public PPanEventHandler() {
        this.setEventFilter(new PInputEventFilter(524288));
        this.setAutopan(true);
    }

    protected void drag(PInputEvent e) {
        super.drag(e);
        this.pan(e);
    }

    protected void pan(PInputEvent e) {
        PCamera c = e.getCamera();
        Point l = e.getPosition();
        if (c.getViewBounds().contains(l.x, l.y)) {
            Dimension d = e.getDelta();
            c.translateView(d.getWidth(), d.getHeight());
        }
    }

    public void setAutopan(boolean autopan) {
        this.autopan = autopan;
    }

    public boolean getAutopan() {
        return this.autopan;
    }

    public void setMinAutopanSpeed(double minAutopanSpeed) {
        this.minAutopanSpeed = minAutopanSpeed;
    }

    public void setMaxAutopanSpeed(double maxAutopanSpeed) {
        this.maxAutopanSpeed = maxAutopanSpeed;
    }

    protected void dragActivityStep(PInputEvent aEvent) {
        if (!this.autopan) {
            return;
        }
        PCamera c = aEvent.getCamera();
        PBounds b = c.getBoundsReference();
        Point l = aEvent.getPositionRelativeTo(c);
        Dimension delta = new Dimension();
        if (l.y < b.y) {
            delta.height = this.validatePanningSpeed(-1.0 - 0.5 * Math.abs(l.getY() - b.getY()));
        } else if (l.y > b.y + b.width) {
            delta.height = this.validatePanningSpeed(1.0 + 0.5 * Math.abs(l.getY() - (b.getY() + b.getHeight())));
        }
        if (l.x > b.x + b.width) {
            delta.width = this.validatePanningSpeed(1.0 + 0.5 * Math.abs(l.getX() - (b.getX() + b.getWidth())));
        } else if (l.x < b.x) {
            delta.width = this.validatePanningSpeed(-1.0 - 0.5 * Math.abs(l.getX() - b.getX()));
        }
        c.localToView(delta);
        if (delta.width != 0.0 || delta.height != 0.0) {
            c.translateView(delta.width, delta.height);
        }
    }

    protected double validatePanningSpeed(double delta) {
        double minDelta = this.minAutopanSpeed / (double)(1000L / this.getDragActivity().getStepRate());
        double maxDelta = this.maxAutopanSpeed / (double)(1000L / this.getDragActivity().getStepRate());
        boolean deltaNegative = delta < 0.0;
        if ((delta = Math.abs(delta)) < minDelta) {
            delta = minDelta;
        }
        if (delta > maxDelta) {
            delta = maxDelta;
        }
        if (deltaNegative) {
            delta = -delta;
        }
        return delta;
    }

    protected String paramString() {
        StringBuffer result = new StringBuffer();
        result.append("minAutopanSpeed=" + this.minAutopanSpeed);
        result.append(",maxAutopanSpeed=" + this.maxAutopanSpeed);
        if (this.autopan) {
            result.append(",autopan");
        }
        result.append(',');
        result.append(super.paramString());
        return result.toString();
    }
}

