/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.util.internal.property;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.platform.discovery.util.internal.property.Access;
import org.eclipse.platform.discovery.util.internal.property.AccessCheckingList;
import org.eclipse.platform.discovery.util.internal.property.IListProperty;
import org.eclipse.platform.discovery.util.internal.property.IListPropertyListener;
import org.eclipse.platform.discovery.util.internal.property.IPropertyAttributeListener;
import org.eclipse.platform.discovery.util.internal.property.ListChangeListenerMaintainer;
import org.eclipse.platform.discovery.util.internal.property.NotifyingList;
import org.eclipse.platform.discovery.util.internal.property.Property;
import org.eclipse.platform.discovery.util.internal.property.PropertyAttribute;
import org.eclipse.platform.discovery.util.internal.property.PropertyListChangedEvent;

public class ListProperty<T>
extends Property<List<T>>
implements IListProperty<T> {
    private final Set<IListPropertyListener<T>> listeners = new HashSet<IListPropertyListener<T>>();
    private final PropertyAttribute<Access> listAccess = new PropertyAttribute<Access>(Access.READ_WRITE, this);
    private final ListChangeListenerMaintainer<T> eventing = new ListenerMaintainerImpl();

    public ListProperty() {
        this(new ArrayList());
    }

    public ListProperty(List<T> initialList) {
        this.set(initialList);
    }

    @Override
    public void set(List<T> l) {
        ArrayList<T> copy = new ArrayList<T>(l.size());
        copy.addAll(l);
        NotifyingList notifyinList = new NotifyingList(copy, this.eventing);
        super.set(new AccessCheckingList(notifyinList, this));
    }

    @Override
    public void registerListAccessListener(IPropertyAttributeListener<Access> listener, boolean current) {
        this.listAccess.registerListener(listener, current);
    }

    @Override
    public boolean removeListAccesssListener(IPropertyAttributeListener<Access> listener) {
        return this.listAccess.removeListener(listener);
    }

    @Override
    public void setListAccess(Access attribute) {
        if (attribute == null) {
            throw new NullPointerException();
        }
        this.listAccess.set(attribute);
    }

    @Override
    public Access getListAccess() {
        return this.listAccess.get();
    }

    @Override
    public boolean registerCollectionChangedListener(IListPropertyListener<T> l, boolean current) {
        boolean added = this.listeners.add(l);
        if (((List)this.get()).size() > 0 && added && current) {
            this.eventing.fireEvent(PropertyListChangedEvent.ChangeKind.ELEMENT_ADDED, (Collection)this.get());
        }
        return added;
    }

    @Override
    public boolean removeCollectionChangedListener(IListPropertyListener<T> l) {
        return this.listeners.remove(l);
    }

    private class ListenerMaintainerImpl
    implements ListChangeListenerMaintainer<T> {
        private ListenerMaintainerImpl() {
        }

        @Override
        public void fireEvent(PropertyListChangedEvent.ChangeKind kind, Collection<? extends T> elements) {
            PropertyListChangedEvent event = new PropertyListChangedEvent(ListProperty.this, kind, elements);
            this.fireEvent(event);
        }

        @Override
        public void fireSingleEvent(PropertyListChangedEvent.ChangeKind kind, T element) {
            PropertyListChangedEvent<Object> event = new PropertyListChangedEvent<Object>(ListProperty.this, kind, Arrays.asList(element));
            this.fireEvent(event);
        }

        private void fireEvent(PropertyListChangedEvent<T> event) {
            for (IListPropertyListener l : ListProperty.this.listeners) {
                l.listChanged(event);
            }
        }
    }
}

