/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tm.stringconverters;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.e4.tm.stringconverter.AbstractStringConverter;
import org.eclipse.e4.tm.stringconverter.StringConverterContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleObjectStringConverter
extends AbstractStringConverter {
    private char classNamePropertyNameSeparator = (char)58;
    private char propertyNameValueSeparator = (char)61;
    private char propertyDelimiter = (char)59;
    private String nameSyntax = "\\w+";
    private String classNameSyntax = String.valueOf(this.nameSyntax) + "(?:\\." + this.nameSyntax + ")*";
    private String valueSyntax = "[^" + this.propertyDelimiter + "]*";
    private String propertySyntax = "(?:(" + this.classNameSyntax + ")" + this.separator(this.classNamePropertyNameSeparator) + ")?(" + this.nameSyntax + ")" + this.separator(this.propertyNameValueSeparator) + "(" + this.valueSyntax + ")" + this.separator(this.propertyDelimiter);
    private Pattern propertyPattern = Pattern.compile(this.propertySyntax);

    private String separator(char separator) {
        return "\\s*\\" + separator + "\\s*";
    }

    @Override
    public <T> T convert(String source, Class<T> klass, StringConverterContext context) {
        int pos1 = source.indexOf("{");
        int pos2 = source.lastIndexOf("}");
        if (pos1 < 0 || pos2 < 0 || pos2 < source.length() - 1) {
            return null;
        }
        Class resultClass = this.convertThrowing(source.substring(0, pos1).trim(), Class.class, context);
        T result = null;
        if (klass.isAssignableFrom(resultClass)) {
            try {
                Object o = resultClass.newInstance();
                result = (T)(klass.isInstance(o) ? o : null);
            }
            catch (Exception exception) {}
        }
        if (result == null) {
            return null;
        }
        String propertiesString = source.substring(pos1 + 1, pos2);
        Matcher matcher = this.propertyPattern.matcher(propertiesString);
        int start = 0;
        while (matcher.find(start)) {
            if (matcher.start() != start) {
                return null;
            }
            int count = matcher.groupCount();
            if (count == 0) {
                return null;
            }
            String valueClassName = count > 2 ? matcher.group(1) : null;
            String propertyName = matcher.group(valueClassName != null ? 2 : 1);
            String valueString = matcher.group(valueClassName != null ? 3 : 2);
            try {
                Class valueClass = context.convert(valueClassName, Class.class);
                Object value = context.convert(valueString, valueClass);
                context.setProperty(result, propertyName, value);
            }
            catch (Exception e) {
                this.throwConversionException(source, klass, e);
            }
            start = matcher.end();
        }
        return start < propertiesString.length() ? null : result;
    }
}

