/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tm.builder;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.e4.tm.builder.AbstractBinder;
import org.eclipse.e4.tm.builder.AbstractBuilder;
import org.eclipse.e4.tm.builder.IBinder;
import org.eclipse.e4.tm.builder.ReflectionSupport;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BinderFactory {
    protected AbstractBuilder builder;
    protected Map<EClass, IBinder> binderMap;

    protected BinderFactory(AbstractBuilder builder) {
        this.builder = builder;
    }

    public IBinder getBinder(EObject eObject) {
        IBinder binder;
        EClass eClass = eObject.eClass();
        if (this.binderMap == null) {
            this.binderMap = new HashMap<EClass, IBinder>();
        }
        if ((binder = this.binderMap.get(eClass)) == null) {
            binder = this.createBinder(eClass);
            this.binderMap.put(eClass, binder);
        }
        return binder;
    }

    protected String getBinderClassName(EClass eClass) {
        String packageName;
        String className = AbstractBuilder.getClassAnnotation(eClass, AbstractBinder.ANNOTATION_URI, "binderClass", null);
        if (className == null) {
            className = String.valueOf(eClass.getName()) + "Binder";
        }
        if ((packageName = AbstractBuilder.getClassAnnotation(eClass, AbstractBinder.ANNOTATION_URI, "binderPackage", null)) == null && className.indexOf(46) < 0) {
            String name = this.builder.getClass().getName();
            packageName = name.substring(0, name.lastIndexOf(46));
        }
        if (packageName != null && className != null) {
            className = String.valueOf(packageName) + "." + className;
        }
        return className;
    }

    protected Class<?> getBinderClassForName(String className) {
        return this.builder.getClassResolver().resolve(className);
    }

    protected IBinder createBinder(EClass eClass) {
        String className = this.getBinderClassName(eClass);
        Class<?> c = this.getBinderClassForName(className);
        return c != null && IBinder.class.isAssignableFrom(c) ? this.createBinderOfClass(c) : null;
    }

    protected IBinder createBinderOfClass(Class<? extends IBinder> c) {
        IBinder binder = null;
        if (c != null && IBinder.class.isAssignableFrom(c)) {
            try {
                binder = c.newInstance();
                this.builder.setProperty(binder, "builder", this);
            }
            catch (Exception exception) {}
            if (binder == null) {
                Constructor<?>[] constructors = c.getConstructors();
                int i = 0;
                while (i < constructors.length) {
                    if (ReflectionSupport.hasSingleParameterForValue(constructors[i].getParameterTypes(), this, false)) {
                        try {
                            binder = (IBinder)constructors[i].newInstance(this);
                        }
                        catch (Exception exception) {}
                    }
                    ++i;
                }
            }
        }
        return binder;
    }
}

