/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.resources.semantic.test;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import junit.framework.Assert;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.semantic.ISemanticFile;
import org.eclipse.core.resources.semantic.ISemanticFolder;
import org.eclipse.core.resources.semantic.examples.providers.SampleCompositeResourceContentProvider;
import org.eclipse.core.resources.semantic.spi.Util;
import org.eclipse.core.resources.semantic.test.TestsContentProviderUtil;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.junit.Test;

public class TestsSampleCompositeResourceProvider
extends TestsContentProviderUtil {
    public TestsSampleCompositeResourceProvider() {
        super(false, "SampleCompositeResourceProviderTests", SampleCompositeResourceContentProvider.class.getName());
    }

    @Test
    public void testAddRemoveFileByURI() throws Exception {
        IFolder root = this.testProject.getFolder("root");
        IFolder parent = root.getFolder("Folder1");
        Assert.assertEquals((String)"Folder existence", (boolean)false, (boolean)parent.exists());
        final IFile testFile = parent.getFile("test.txt");
        Assert.assertEquals((String)"File existence", (boolean)false, (boolean)testFile.exists());
        final IFile test_enFile = parent.getFile("test_en.txt");
        Assert.assertEquals((String)"File existence", (boolean)false, (boolean)testFile.exists());
        final IFile test2File = parent.getFile("test2.txt");
        Assert.assertEquals((String)"File existence", (boolean)false, (boolean)testFile.exists());
        URI testFileURI = this.createTempFile("test.txt", "test content 1");
        URI test_enFileURI = this.createTempFile("test_en.txt", "test content 2");
        URI test2FileURI = this.createTempFile("test2.txt", "test content 3");
        this.addFile(parent, "test.txt", testFile, testFileURI);
        this.addFile(parent, "test_en.txt", test_enFile, test_enFileURI);
        this.addFile(parent, "test2.txt", test2File, test2FileURI);
        Assert.assertEquals((String)"Folder existence", (boolean)true, (boolean)parent.exists());
        Assert.assertEquals((String)"File existence", (boolean)true, (boolean)testFile.exists());
        Assert.assertEquals((String)"File existence", (boolean)true, (boolean)test_enFile.exists());
        Assert.assertEquals((String)"File existence", (boolean)true, (boolean)test2File.exists());
        Object runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                ISemanticFile sf = (ISemanticFile)testFile.getAdapter(ISemanticFile.class);
                ISemanticFile sf_en = (ISemanticFile)test_enFile.getAdapter(ISemanticFile.class);
                ISemanticFile sf2 = (ISemanticFile)test2File.getAdapter(ISemanticFile.class);
                Assert.assertTrue((String)"Should be read-only", (boolean)sf.getAdaptedFile().isReadOnly());
                Assert.assertTrue((String)"Should be read-only", (boolean)sf_en.getAdaptedFile().isReadOnly());
                Assert.assertTrue((String)"Should be read-only", (boolean)sf2.getAdaptedFile().isReadOnly());
                IStatus stat = sf.validateEdit(null);
                Assert.assertTrue((String)"ValidateEdit should have returned OK", (boolean)stat.isOK());
                Assert.assertTrue((String)"Should be writable", (!sf.getAdaptedFile().isReadOnly() ? 1 : 0) != 0);
                Assert.assertTrue((String)"Should be writable", (!sf_en.getAdaptedFile().isReadOnly() ? 1 : 0) != 0);
                Assert.assertTrue((String)"Should be still read-only", (boolean)sf2.getAdaptedFile().isReadOnly());
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, (IProgressMonitor)new NullProgressMonitor());
        runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                ISemanticFile sf = (ISemanticFile)testFile.getAdapter(ISemanticFile.class);
                ISemanticFile sf_en = (ISemanticFile)test_enFile.getAdapter(ISemanticFile.class);
                ISemanticFile sf2 = (ISemanticFile)test2File.getAdapter(ISemanticFile.class);
                IStatus status = sf.validateRemove(0, monitor);
                Assert.assertTrue((String)"ValidateRemove should have returned not OK", (!status.isOK() ? 1 : 0) != 0);
                status = sf_en.validateRemove(0, monitor);
                Assert.assertTrue((String)"ValidateRemove should have returned not OK", (!status.isOK() ? 1 : 0) != 0);
                status = sf2.validateRemove(0, monitor);
                Assert.assertTrue((String)"ValidateRemove should have returned OK", (boolean)status.isOK());
                status = sf.validateRemove(2, monitor);
                Assert.assertTrue((String)"ValidateRemove should have returned not OK", (!status.isOK() ? 1 : 0) != 0);
                status = sf_en.validateRemove(2, monitor);
                Assert.assertTrue((String)"ValidateRemove should have returned not OK", (!status.isOK() ? 1 : 0) != 0);
                status = sf2.validateRemove(2, monitor);
                Assert.assertTrue((String)"ValidateRemove should have returned OK", (boolean)status.isOK());
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, (IProgressMonitor)new NullProgressMonitor());
        runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                ISemanticFile sf = (ISemanticFile)testFile.getAdapter(ISemanticFile.class);
                ISemanticFile sf_en = (ISemanticFile)test_enFile.getAdapter(ISemanticFile.class);
                ISemanticFile sf2 = (ISemanticFile)test2File.getAdapter(ISemanticFile.class);
                Assert.assertTrue((String)"Should be writable", (!sf.getAdaptedFile().isReadOnly() ? 1 : 0) != 0);
                Assert.assertTrue((String)"Should be writable", (!sf_en.getAdaptedFile().isReadOnly() ? 1 : 0) != 0);
                Assert.assertTrue((String)"Should be read-only", (boolean)sf2.getAdaptedFile().isReadOnly());
                sf_en.revertChanges(TestsSampleCompositeResourceProvider.this.options, monitor);
                Assert.assertTrue((String)"Should be read-only", (boolean)sf.getAdaptedFile().isReadOnly());
                Assert.assertTrue((String)"Should be read-only", (boolean)sf_en.getAdaptedFile().isReadOnly());
                Assert.assertTrue((String)"Should be read-only", (boolean)sf2.getAdaptedFile().isReadOnly());
                IStatus status = sf.validateRemove(2, monitor);
                Assert.assertTrue((String)"ValidateRemove should have returned not OK", (!status.isOK() ? 1 : 0) != 0);
                status = sf_en.validateRemove(2, monitor);
                Assert.assertTrue((String)"ValidateRemove should have returned not OK", (!status.isOK() ? 1 : 0) != 0);
                status = sf2.validateRemove(0, monitor);
                Assert.assertTrue((String)"ValidateRemove should have returned OK", (boolean)status.isOK());
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, (IProgressMonitor)new NullProgressMonitor());
        runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                ISemanticFile sf2 = (ISemanticFile)test2File.getAdapter(ISemanticFile.class);
                IStatus status = sf2.validateEdit(null);
                Assert.assertTrue((String)"ValidateEdit should have returned OK", (boolean)status.isOK());
                status = sf2.validateRemove(0, monitor);
                Assert.assertTrue((String)"ValidateRemove should have returned not OK", (!status.isOK() ? 1 : 0) != 0);
                status = sf2.validateRemove(2, monitor);
                Assert.assertTrue((String)"ValidateRemove should have returned not OK", (!status.isOK() ? 1 : 0) != 0);
                status = sf2.validateRemove(6, monitor);
                Assert.assertTrue((String)"ValidateRemove should have returned OK", (boolean)status.isOK());
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, (IProgressMonitor)new NullProgressMonitor());
        runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                ISemanticFile sf = (ISemanticFile)testFile.getAdapter(ISemanticFile.class);
                sf.remove(TestsSampleCompositeResourceProvider.this.options, monitor);
                if (!TestsSampleCompositeResourceProvider.this.autoRefresh) {
                    Assert.assertEquals((String)"File existence", (boolean)true, (boolean)testFile.exists());
                    testFile.getParent().refreshLocal(2, monitor);
                }
                Assert.assertEquals((String)"File existence", (boolean)false, (boolean)testFile.exists());
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertFalse((String)"File should not exist", (boolean)testFile.exists());
        Assert.assertFalse((String)"File should not exist", (boolean)test_enFile.exists());
        Assert.assertTrue((String)"File should exist", (boolean)test2File.exists());
    }

    private void addFile(final IFolder parent, final String testFileName, final IFile file, final URI testFileURI) throws CoreException {
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                ISemanticFolder sfr = (ISemanticFolder)parent.getAdapter(ISemanticFolder.class);
                ISemanticFile sfile = sfr.addFile(testFileName, testFileURI, TestsSampleCompositeResourceProvider.this.options, monitor);
                Assert.assertTrue((boolean)sfile.getAdaptedFile().equals((Object)file));
                if (!TestsSampleCompositeResourceProvider.this.autoRefresh) {
                    Assert.assertEquals((String)"File existence", (boolean)false, (boolean)file.exists());
                    file.getParent().refreshLocal(2, monitor);
                }
                Assert.assertEquals((String)"File existence", (boolean)true, (boolean)file.exists());
                InputStream is = null;
                try {
                    is = sfile.getAdaptedFile().getContents();
                    try {
                        Assert.assertTrue((String)"Too few bytes available", (is.available() > 0 ? 1 : 0) != 0);
                    }
                    catch (IOException e) {
                        Assert.fail((String)e.getMessage());
                    }
                }
                finally {
                    Util.safeClose((InputStream)is);
                }
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, (ISchedulingRule)this.testProject, 0, (IProgressMonitor)new NullProgressMonitor());
    }

    private URI createTempFile(String name, String content) throws IOException {
        String tmproot = System.getProperty("java.io.tmpdir");
        File tmpdirRoot = new File(tmproot);
        if (!tmpdirRoot.exists()) {
            throw new FileNotFoundException(tmproot);
        }
        File tmpdir = new File(tmpdirRoot, "SFSTestSuite");
        tmpdir.mkdirs();
        if (!tmpdir.exists()) {
            throw new FileNotFoundException(tmpdir.getAbsolutePath());
        }
        File file = new File(tmpdir, name);
        file.delete();
        FileOutputStream os = new FileOutputStream(file);
        ((OutputStream)os).write(content.getBytes("UTF-8"));
        ((OutputStream)os).close();
        file.deleteOnExit();
        return file.toURI();
    }
}

