/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.resources.semantic.test;

import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.semantic.ISemanticFileSystem;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.ui.IConfigurationWizard;
import org.eclipse.ui.PlatformUI;
import org.junit.Assert;
import org.junit.Test;

public class TestsRepositoryProvider {
    @Test
    public void testRepositoryConfigurationWizard() throws CoreException {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint("org.eclipse.team.ui.configurationWizards");
        IExtension[] iExtensionArray = extensionPoint.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            if (extension.getNamespaceIdentifier().equals("org.eclipse.ui.resources.semantic")) {
                IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
                int n3 = iConfigurationElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement element = iConfigurationElementArray[n4];
                    if ("wizard".equals(element.getName())) {
                        final Object test = element.createExecutableExtension("class");
                        Assert.assertNotNull((String)"Wizard should not be null", (Object)test);
                        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

                            public void run(IProgressMonitor monitor) throws CoreException {
                                IConfigurationWizard cw = (IConfigurationWizard)test;
                                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("RepositoryProviderWizardTest");
                                project.create(monitor);
                                project.open(monitor);
                                RepositoryProvider test1 = RepositoryProvider.getProvider((IProject)project, (String)"org.eclipse.core.internal.resources.semantic.DelegatingRepositoryProvider");
                                Assert.assertNull((String)"Repository provider should not be mapped", (Object)test1);
                                cw.init(PlatformUI.getWorkbench(), project);
                                cw.performFinish();
                                test1 = RepositoryProvider.getProvider((IProject)project, (String)"org.eclipse.core.internal.resources.semantic.DelegatingRepositoryProvider");
                                Assert.assertNotNull((String)"Repository provider should be mapped", (Object)test1);
                                project.close(monitor);
                                project.delete(false, monitor);
                            }
                        };
                        ResourcesPlugin.getWorkspace().run(runnable, (IProgressMonitor)new NullProgressMonitor());
                        return;
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        Assert.fail((String)"Should have been executed");
    }

    @Test
    public void testPathToDb() throws Exception {
        ISemanticFileSystem sfs = (ISemanticFileSystem)EFS.getFileSystem((String)"semanticfs");
        Assert.assertNotNull((String)"Path to db should not be null", (Object)sfs.getPathToDb());
    }
}

