/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources.semantic.cacheservice;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.eclipse.core.internal.resources.semantic.cacheservice.FileHandleFactory;
import org.eclipse.core.internal.resources.semantic.cacheservice.ICachedContentHandle;
import org.eclipse.core.resources.semantic.SemanticResourceException;
import org.eclipse.core.resources.semantic.SemanticResourceStatusCode;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

class CachedFileHandle
implements ICachedContentHandle {
    private final File cacheFile;
    private final FileHandleFactory factory;

    public CachedFileHandle(FileHandleFactory factory, File cacheFile) {
        this.factory = factory;
        this.cacheFile = cacheFile;
    }

    public boolean exists() {
        return this.factory.checkFileExists(this.cacheFile);
    }

    public void delete() {
        this.factory.tryDelete(this.cacheFile);
    }

    public InputStream openInputStream() throws CoreException {
        try {
            return this.factory.openInputStream(this.cacheFile);
        }
        catch (FileNotFoundException e) {
            throw new SemanticResourceException(SemanticResourceStatusCode.CACHED_CONTENT_NOT_FOUND, (IPath)new Path(this.cacheFile.getAbsolutePath()), null, e);
        }
    }
}

