/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources.semantic;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.internal.resources.semantic.model.SemanticResourceDB.TreeNodeType;

public class SemanticQueryParser {
    private String providerID;
    private TreeNodeType type = TreeNodeType.UNKNOWN;
    private QueryParam[] params;
    private String uri;
    private boolean shouldCreate;

    public SemanticQueryParser(String query) {
        this.params = SemanticQueryParser.getQueryParameters(query);
        this.applyQueryParameters(query);
    }

    public static QueryParam[] getQueryParameters(String query) {
        ArrayList<QueryParam> params = new ArrayList<QueryParam>();
        Pattern p1 = Pattern.compile("([^;&]+)");
        Pattern p2 = Pattern.compile("([^=]*)=([^=]*)");
        Matcher m1 = p1.matcher(query);
        while (m1.find()) {
            Matcher m2 = p2.matcher(m1.group());
            if (!m2.find()) continue;
            QueryParam param = new QueryParam();
            param.name = m2.group(1);
            param.value = m2.group(2);
            params.add(param);
        }
        return params.toArray(new QueryParam[0]);
    }

    public String getProviderID() {
        return this.providerID;
    }

    public TreeNodeType getType() {
        return this.type;
    }

    public QueryParam[] getAllParameters() {
        return this.params;
    }

    public boolean getShouldCreate() {
        return this.shouldCreate;
    }

    public String getURI() {
        return this.uri;
    }

    private void applyQueryParameters(String queryString) {
        if (queryString != null) {
            QueryParam[] queryParamArray = this.params = SemanticQueryParser.getQueryParameters(queryString);
            int n = this.params.length;
            int n2 = 0;
            while (n2 < n) {
                QueryParam param = queryParamArray[n2];
                if (param.name.equals("provider")) {
                    this.providerID = param.value;
                } else if (param.name.equals("type")) {
                    if (param.value.equals("folder")) {
                        this.type = TreeNodeType.FOLDER;
                    } else if (param.value.equals("project")) {
                        this.type = TreeNodeType.PROJECT;
                    } else if (param.value.equals("file")) {
                        this.type = TreeNodeType.FILE;
                    }
                } else if (param.name.equals("uri")) {
                    try {
                        this.uri = URLDecoder.decode(param.value, "UTF-8");
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {}
                } else if (param.name.equals("create") && param.value.equals("true")) {
                    this.shouldCreate = true;
                }
                ++n2;
            }
        }
    }

    public static class QueryParam {
        String name;
        String value;
    }
}

