/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources.semantic;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.provider.FileStore;
import org.eclipse.core.internal.resources.semantic.ISemanticFileStoreInternal;
import org.eclipse.core.internal.resources.semantic.Messages;
import org.eclipse.core.internal.resources.semantic.SemanticFileInfo;
import org.eclipse.core.internal.resources.semantic.SemanticFileSystem;
import org.eclipse.core.internal.resources.semantic.SemanticFileSystemCore;
import org.eclipse.core.internal.resources.semantic.SemanticProperties;
import org.eclipse.core.internal.resources.semantic.SemanticResourceInfo;
import org.eclipse.core.internal.resources.semantic.SfsTraceLocation;
import org.eclipse.core.internal.resources.semantic.Util;
import org.eclipse.core.internal.resources.semantic.model.SemanticResourceDB.ResourceTreeNode;
import org.eclipse.core.internal.resources.semantic.model.SemanticResourceDB.SemanticResourceDBFactory;
import org.eclipse.core.internal.resources.semantic.model.SemanticResourceDB.TreeNodeType;
import org.eclipse.core.internal.resources.semantic.model.SemanticResourceDB.TreeRoot;
import org.eclipse.core.internal.resources.semantic.util.ISemanticFileSystemLog;
import org.eclipse.core.resources.semantic.ISemanticResourceInfo;
import org.eclipse.core.resources.semantic.SemanticResourceException;
import org.eclipse.core.resources.semantic.SemanticResourceStatusCode;
import org.eclipse.core.resources.semantic.SyncDirection;
import org.eclipse.core.resources.semantic.spi.FileCacheServiceFactory;
import org.eclipse.core.resources.semantic.spi.ISemanticContentProvider;
import org.eclipse.core.resources.semantic.spi.ISemanticContentProviderFederation;
import org.eclipse.core.resources.semantic.spi.ISemanticContentProviderFederation2;
import org.eclipse.core.resources.semantic.spi.ISemanticContentProviderLocal;
import org.eclipse.core.resources.semantic.spi.ISemanticContentProviderLocking;
import org.eclipse.core.resources.semantic.spi.ISemanticContentProviderREST;
import org.eclipse.core.resources.semantic.spi.ISemanticContentProviderRemote;
import org.eclipse.core.resources.semantic.spi.ISemanticFileStore;
import org.eclipse.core.resources.semantic.spi.ISemanticSpiResourceInfo;
import org.eclipse.core.resources.semantic.spi.MemoryCacheServiceFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SemanticFileStore
extends SemanticProperties
implements ISemanticFileStore,
ISemanticFileStoreInternal {
    private static final String DEFAULT_CONTENT_PROVIDER_ID = "org.eclipse.core.resources.semantic.provider.DefaultContentProvider";
    private final ISemanticFileSystemLog log;
    private ISemanticContentProvider provider;

    SemanticFileStore(SemanticFileSystem fs, ResourceTreeNode node) {
        super(fs, node);
        this.log = fs.getLog();
    }

    public String[] childNames(int options, IProgressMonitor monitor) throws CoreException {
        try {
            this.fs.lockForRead();
            this.checkAndJoinTreeIfAnotherEntryExists();
            EList<ResourceTreeNode> children = this.node.getChildren();
            int counter = children.size();
            String[] names = new String[counter];
            int i = 0;
            for (ResourceTreeNode resourceTreeNode : children) {
                if (!resourceTreeNode.isExists()) continue;
                names[i] = resourceTreeNode.getName();
                ++i;
            }
            String[] stringArray = names;
            return stringArray;
        }
        finally {
            this.fs.unlockForRead();
        }
    }

    public IFileInfo fetchInfo(int options, IProgressMonitor monitor) throws CoreException {
        SemanticFileInfo info;
        block15: {
            this.checkAndJoinTreeIfAnotherEntryExists();
            ISemanticContentProvider effectiveProvider = this.getEffectiveContentProvider();
            boolean askContentProviderForReadonly = false;
            boolean askContentProviderForTimestamp = false;
            try {
                this.fs.lockForRead();
                info = new SemanticFileInfo();
                info.setName(this.node.getName());
                info.setExists(this.node.isExists());
                TreeNodeType actType = this.node.getType();
                info.setDirectory(actType.equals((Object)TreeNodeType.FOLDER) || actType.equals((Object)TreeNodeType.PROJECT));
                if (info.isDirectory() || !this.node.isExists() || actType.equals((Object)TreeNodeType.UNKNOWN)) {
                    info.setLastModified(0L);
                    info.setAttribute(2, false);
                } else {
                    askContentProviderForTimestamp = true;
                    if (!this.node.isLocalOnly()) {
                        askContentProviderForReadonly = true;
                    } else {
                        info.setAttribute(2, false);
                    }
                }
            }
            finally {
                this.fs.unlockForRead();
            }
            if (askContentProviderForReadonly) {
                boolean readOnly;
                block14: {
                    readOnly = true;
                    try {
                        readOnly = effectiveProvider.fetchResourceInfo(this, 16, monitor).isReadOnly();
                    }
                    catch (CoreException e) {
                        if (!SfsTraceLocation.CONTENTPROVIDER.isActive()) break block14;
                        SfsTraceLocation.getTrace().trace(SfsTraceLocation.CONTENTPROVIDER.getLocation(), e.getMessage(), (Throwable)e);
                    }
                }
                info.setAttribute(2, readOnly);
            }
            if (askContentProviderForTimestamp) {
                try {
                    info.setLastModified(effectiveProvider.getResourceTimestamp(this, monitor));
                }
                catch (CoreException e) {
                    info.setLastModified(0L);
                    if (!SfsTraceLocation.CONTENTPROVIDER.isActive()) break block15;
                    SfsTraceLocation.getTrace().trace(SfsTraceLocation.CONTENTPROVIDER.getLocation(), e.getMessage(), (Throwable)e);
                }
            }
        }
        return info;
    }

    public void putInfo(IFileInfo info, int options, IProgressMonitor monitor) throws CoreException {
        if (SfsTraceLocation.CORE_VERBOSE.isActive()) {
            SfsTraceLocation.getTrace().traceDumpStack(SfsTraceLocation.CORE_VERBOSE.getLocation());
        }
        if (SfsTraceLocation.CORE.isActive()) {
            SfsTraceLocation.getTrace().trace(SfsTraceLocation.CORE.getLocation(), NLS.bind((String)Messages.SemanticFileStore_UpdateFileInfo_XMSG, (Object)this.getPath().toString()));
        }
        this.checkAccessible();
        if ((options & 0x400) != 0) {
            this.getEffectiveContentProvider().setReadOnly(this, info.getAttribute(2), monitor);
        }
        if ((options & 0x800) != 0) {
            long timestamp = info.getLastModified();
            this.getEffectiveContentProvider().setResourceTimestamp(this, timestamp, monitor);
        }
    }

    private static ISemanticContentProvider initProvider(String contentProviderID, ISemanticFileStore store) throws CoreException {
        ISemanticContentProvider actProvider = SemanticFileSystemCore.getInstance().getContentProviderFactory(contentProviderID).createContentProvider();
        actProvider.setRootStore(store);
        ((SemanticFileStore)store).setProvider(actProvider);
        return actProvider;
    }

    @Override
    public String getEffectiveContentProviderID() throws CoreException {
        try {
            this.fs.lockForWrite();
            if (this.getContentProviderID() != null) {
                String string = this.getContentProviderID();
                return string;
            }
            ContentProviderData effectiveProviderData = this.getEffectiveContentProviderInternal();
            if (effectiveProviderData.provider instanceof ISemanticContentProviderFederation2) {
                IPath thisPath = this.getPath();
                String string = SemanticFileStore.findFederatedContentProvider((IPath)thisPath, (SemanticFileSystem)this.fs, (ResourceTreeNode)this.node, (ContentProviderData)effectiveProviderData).providerID;
                return string;
            }
            String string = effectiveProviderData.providerID;
            return string;
        }
        finally {
            this.fs.unlockForWrite();
        }
    }

    @Override
    public ISemanticContentProvider getEffectiveContentProvider() throws CoreException {
        try {
            this.fs.lockForWrite();
            if (this.provider != null) {
                ISemanticContentProvider iSemanticContentProvider = this.provider;
                return iSemanticContentProvider;
            }
            ContentProviderData effectiveProviderData = this.getEffectiveContentProviderInternal();
            if (effectiveProviderData.provider instanceof ISemanticContentProviderFederation2) {
                IPath thisPath = this.getPath();
                ISemanticContentProvider iSemanticContentProvider = SemanticFileStore.findFederatedContentProvider((IPath)thisPath, (SemanticFileSystem)this.fs, (ResourceTreeNode)this.node, (ContentProviderData)effectiveProviderData).provider;
                return iSemanticContentProvider;
            }
            ISemanticContentProvider iSemanticContentProvider = effectiveProviderData.provider;
            return iSemanticContentProvider;
        }
        finally {
            this.fs.unlockForWrite();
        }
    }

    private static ContentProviderData findFederatedContentProvider(IPath path, SemanticFileSystem fs, ResourceTreeNode node, ContentProviderData parentProviderData) throws CoreException {
        ISemanticContentProviderFederation2 federatingProvider;
        ISemanticContentProviderFederation2.FederatedProviderInfo info;
        int relativePathLength = path.segmentCount() - parentProviderData.provider.getRootStore().getPath().segmentCount();
        if (relativePathLength > 0 && (info = (federatingProvider = (ISemanticContentProviderFederation2)((Object)parentProviderData.provider)).getFederatedProviderInfoForPath(path)) != null) {
            if (info.contentProviderID == null) {
                throw new SemanticResourceException(SemanticResourceStatusCode.FEDERATION_EMPTY_FEDERATED_PROVIDER_ID, path, NLS.bind((String)Messages.SemanticFileStore_FederatingContentProviderReturnedNull_XMSG, (Object)federatingProvider.getClass().getName(), (Object)path.toString()));
            }
            if (info.rootNodePosition <= 0 || info.rootNodePosition > relativePathLength) {
                throw new SemanticResourceException(SemanticResourceStatusCode.FEDERATION_INVALID_ROOT_NODE_POSITION, path, NLS.bind((String)Messages.SemanticFileStore_FederatingContentProviderReturnedInvalidRootNodePosition_XMSG, (Object)federatingProvider.getClass().getName(), (Object)path.toString()));
            }
            ResourceTreeNode parent = node;
            int i = 0;
            while (i < relativePathLength - info.rootNodePosition) {
                if (parent != null) {
                    parent = parent.getParent();
                }
                ++i;
            }
            if (parent != null) {
                parent.setDynamicContentProviderID(info.contentProviderID);
            } else {
                String pathString = path.removeLastSegments(relativePathLength - info.rootNodePosition).toString();
                parent = fs.getNodeByPath(pathString);
            }
            ISemanticContentProvider nestedProvider = SemanticFileStore.initProvider(info.contentProviderID, fs.getStore(parent));
            ContentProviderData nestedProviderData = new ContentProviderData(nestedProvider, info.contentProviderID);
            if (nestedProvider instanceof ISemanticContentProviderFederation2) {
                return SemanticFileStore.findFederatedContentProvider(path, fs, node, nestedProviderData);
            }
            return nestedProviderData;
        }
        return parentProviderData;
    }

    private ContentProviderData getEffectiveContentProviderInternal() throws CoreException {
        String parentContentProviderId = DEFAULT_CONTENT_PROVIDER_ID;
        ResourceTreeNode parent = null;
        this.checkAndJoinTreeIfAnotherEntryExists();
        if (this.node.getTemplateID() != null) {
            String contentProviderID = this.node.getTemplateID();
            SemanticFileStore.initProvider(contentProviderID, this);
            if (SfsTraceLocation.CORE_VERBOSE.isActive()) {
                SfsTraceLocation.getTrace().traceExit(SfsTraceLocation.CORE_VERBOSE.getLocation(), (Object)contentProviderID);
            }
            return new ContentProviderData(this.provider, contentProviderID);
        }
        if (this.node.getDynamicContentProviderID() != null) {
            String contentProviderID = this.node.getDynamicContentProviderID();
            SemanticFileStore.initProvider(contentProviderID, this);
            if (SfsTraceLocation.CORE_VERBOSE.isActive()) {
                SfsTraceLocation.getTrace().traceExit(SfsTraceLocation.CORE_VERBOSE.getLocation(), (Object)contentProviderID);
            }
            return new ContentProviderData(this.provider, contentProviderID);
        }
        if (!this.node.isExists()) {
            List<ResourceTreeNode> nodes = this.fs.getNodesByPath(this.node.getPath());
            ResourceTreeNode cpRootParent = nodes.get(0);
            int counter = 0;
            for (ResourceTreeNode resourceTreeNode : nodes) {
                if (!resourceTreeNode.isExists()) break;
                if (resourceTreeNode.getTemplateID() != null) {
                    parentContentProviderId = resourceTreeNode.getTemplateID();
                    cpRootParent = resourceTreeNode;
                }
                ++counter;
            }
            ISemanticFileStore parentStore = this.fs.getStore(cpRootParent);
            ISemanticContentProvider parentProvider = SemanticFileStore.initProvider(parentContentProviderId, parentStore);
            int i = counter;
            while (i < nodes.size()) {
                String federatedContentProviderId;
                ResourceTreeNode resourceTreeNode = nodes.get(i);
                if (parentProvider instanceof ISemanticContentProviderFederation && (federatedContentProviderId = ((ISemanticContentProviderFederation)((Object)parentProvider)).getFederatedProviderIDForPath((IPath)new Path(resourceTreeNode.getPath()))) != null) {
                    parentContentProviderId = federatedContentProviderId;
                    cpRootParent = resourceTreeNode;
                    parentStore = this.fs.getStore(cpRootParent);
                    parentProvider = SemanticFileStore.initProvider(parentContentProviderId, parentStore);
                }
                ++i;
            }
            if (SfsTraceLocation.CORE_VERBOSE.isActive()) {
                SfsTraceLocation.getTrace().traceExit(SfsTraceLocation.CORE_VERBOSE.getLocation(), (Object)parentContentProviderId);
            }
            return new ContentProviderData(parentProvider, parentContentProviderId);
        }
        parent = this.node.getParent();
        if (parent == null) {
            ISemanticContentProvider parentProvider = SemanticFileStore.initProvider(parentContentProviderId, this);
            return new ContentProviderData(parentProvider, parentContentProviderId);
        }
        ResourceTreeNode oldParent = this.node;
        while (parent != null) {
            parentContentProviderId = parent.getTemplateID();
            if (parentContentProviderId != null) break;
            oldParent = parent;
            parent = parent.getParent();
        }
        if (parentContentProviderId == null) {
            parentContentProviderId = DEFAULT_CONTENT_PROVIDER_ID;
            parent = oldParent;
        }
        ISemanticFileStore parentStore = this.fs.getStore(parent);
        ISemanticContentProvider parentProvider = SemanticFileStore.initProvider(parentContentProviderId, parentStore);
        if (SfsTraceLocation.CORE_VERBOSE.isActive()) {
            SfsTraceLocation.getTrace().traceExit(SfsTraceLocation.CORE_VERBOSE.getLocation(), (Object)parentContentProviderId);
        }
        return new ContentProviderData(parentProvider, parentContentProviderId);
    }

    public File toLocalFile(int options, IProgressMonitor monitor) throws CoreException {
        this.checkAndJoinTreeIfAnotherEntryExists();
        if (options != 4096 && this.node.isExists()) {
            ISemanticContentProvider effectiveProvider = this.getEffectiveContentProvider();
            if (effectiveProvider instanceof ISemanticContentProviderLocal) {
                return ((ISemanticContentProviderLocal)((Object)effectiveProvider)).toLocalFile(this);
            }
            return null;
        }
        FileStore store = new FileStore(){

            public URI toURI() {
                return SemanticFileStore.this.toURI();
            }

            public InputStream openInputStream(int options1, IProgressMonitor monitor1) throws CoreException {
                return SemanticFileStore.this.openInputStream(options1, monitor1);
            }

            public IFileStore getParent() {
                return SemanticFileStore.this.getParent();
            }

            public String getName() {
                return SemanticFileStore.this.getName();
            }

            public IFileStore getChild(String name) {
                return SemanticFileStore.this.getChild(name);
            }

            public IFileInfo fetchInfo(int options1, IProgressMonitor monitor1) throws CoreException {
                IFileInfo info = SemanticFileStore.this.fetchInfo(options1, monitor1);
                if (info != null && info.exists() && info.getAttribute(2)) {
                    info.setAttribute(2, false);
                }
                return info;
            }

            public String[] childNames(int options1, IProgressMonitor monitor1) throws CoreException {
                return SemanticFileStore.this.childNames(options1, monitor1);
            }
        };
        return store.toLocalFile(options, monitor);
    }

    public IFileStore getChild(String name) {
        ISemanticFileStore result;
        block14: {
            ISemanticContentProvider effectiveProvider;
            SemanticFileStore store = this.findChild(name);
            if (store != null) {
                return store;
            }
            try {
                effectiveProvider = this.getEffectiveContentProvider();
            }
            catch (CoreException ce) {
                this.log.log(ce);
                return EFS.getNullFileSystem().getStore(this.getPath().append(name));
            }
            String federatedContentProviderId = null;
            if (effectiveProvider instanceof ISemanticContentProviderFederation) {
                federatedContentProviderId = ((ISemanticContentProviderFederation)((Object)effectiveProvider)).getFederatedProviderIDForPath(this.getPath().append(name));
            }
            try {
                this.fs.lockForWrite();
                this.checkAndJoinTreeIfAnotherEntryExists();
                store = this.findChild(name);
                if (store != null) {
                    SemanticFileStore semanticFileStore = store;
                    return semanticFileStore;
                }
                IPath childPath = this.getPath().append(name);
                ResourceTreeNode newnode = this.createLocalChildNode(name, childPath, federatedContentProviderId);
                result = this.fs.getStore(newnode);
            }
            finally {
                this.fs.unlockForWrite();
            }
            if (result != null) {
                effectiveProvider.onImplicitStoreCreate(result);
                if (federatedContentProviderId != null) {
                    try {
                        result.getEffectiveContentProvider().onImplicitStoreCreate(result);
                    }
                    catch (CoreException e) {
                        if (!SfsTraceLocation.CONTENTPROVIDER.isActive()) break block14;
                        SfsTraceLocation.getTrace().trace(SfsTraceLocation.CONTENTPROVIDER.getLocation(), e.getMessage(), (Throwable)e);
                    }
                }
            }
        }
        return result;
    }

    public String getName() {
        try {
            this.fs.lockForRead();
            this.checkAndJoinTreeIfAnotherEntryExists();
            String string = this.node.getName();
            return string;
        }
        finally {
            this.fs.unlockForRead();
        }
    }

    public IFileStore getParent() {
        try {
            this.fs.lockForRead();
            this.checkAndJoinTreeIfAnotherEntryExists();
            ResourceTreeNode parentNode = this.fs.getParentNode(this.node);
            if (parentNode != null) {
                ISemanticFileStore iSemanticFileStore = this.fs.getStore(parentNode);
                return iSemanticFileStore;
            }
            return null;
        }
        finally {
            this.fs.unlockForRead();
        }
    }

    public InputStream openInputStream(int options, IProgressMonitor monitor) throws CoreException {
        if (SfsTraceLocation.CORE_VERBOSE.isActive()) {
            SfsTraceLocation.getTrace().traceDumpStack(SfsTraceLocation.CORE_VERBOSE.getLocation());
        }
        this.checkAccessible();
        try {
            this.fs.lockForRead();
            TreeNodeType type = this.node.getType();
            if (type != TreeNodeType.FILE) {
                throw new SemanticResourceException(SemanticResourceStatusCode.INVALID_RESOURCE_TYPE, this.getPath(), Messages.SemanticFileStore_OpenInputOnlyOnFiles_XMSG);
            }
        }
        finally {
            this.fs.unlockForRead();
        }
        ISemanticContentProvider effectiveProvider = this.getEffectiveContentProvider();
        if (SfsTraceLocation.CONTENTPROVIDER.isActive()) {
            SfsTraceLocation.getTrace().trace(SfsTraceLocation.CONTENTPROVIDER.getLocation(), NLS.bind((String)Messages.SemanticFileStore_OpeningInputInfo_XMSG, (Object)effectiveProvider.getClass().getName(), (Object)this.getPath().toString()));
        }
        return effectiveProvider.openInputStream(this, monitor);
    }

    public OutputStream openOutputStream(int options, IProgressMonitor monitor) throws CoreException {
        OutputStream os;
        block14: {
            IStatus status;
            ISemanticSpiResourceInfo info;
            boolean append;
            if (SfsTraceLocation.CORE_VERBOSE.isActive()) {
                SfsTraceLocation.getTrace().traceDumpStack(SfsTraceLocation.CORE_VERBOSE.getLocation());
            }
            this.checkAndJoinTreeIfAnotherEntryExists();
            try {
                this.fs.lockForRead();
                TreeNodeType type = this.node.getType();
                if (type != TreeNodeType.FILE && type != TreeNodeType.UNKNOWN) {
                    throw new SemanticResourceException(SemanticResourceStatusCode.INVALID_RESOURCE_TYPE, this.getPath(), Messages.SemanticFileStore_OpenOutputNotOnFolders_XMSG);
                }
            }
            finally {
                this.fs.unlockForRead();
            }
            ISemanticContentProvider effectiveProvider = this.getEffectiveContentProvider();
            boolean bl = append = (options & 1) != 0;
            if (SfsTraceLocation.CONTENTPROVIDER.isActive()) {
                String message = append ? NLS.bind((String)Messages.SemanticFileStore_AppendingInfo_XMSG, (Object)effectiveProvider.getClass().getName(), (Object)this.getPath().toString()) : NLS.bind((String)Messages.SemanticFileStore_OpeningInfo_XMSG, (Object)effectiveProvider.getClass().getName(), (Object)this.getPath().toString());
                SfsTraceLocation.getTrace().trace(SfsTraceLocation.CONTENTPROVIDER.getLocation(), message);
            }
            if ((info = effectiveProvider.fetchResourceInfo(this, 16, monitor)).isReadOnly() && !(status = effectiveProvider.validateSave(this)).isOK()) {
                throw new CoreException(status);
            }
            int actOptions = 0;
            if (append) {
                actOptions = 1;
            }
            os = effectiveProvider.openOutputStream(this, actOptions, monitor);
            try {
                boolean changeRequired;
                this.fs.lockForWrite();
                boolean bl2 = changeRequired = !this.node.isExists() || this.node.getType() != TreeNodeType.FILE;
                if (!changeRequired) break block14;
                this.fs.switchToExists(this.node, this.fs.getParentNode(this.node));
                this.node.setType(TreeNodeType.FILE);
                try {
                    this.fs.requestFlush(false);
                }
                catch (CoreException e) {
                    Util.safeClose(os);
                    throw e;
                }
            }
            finally {
                this.fs.unlockForWrite();
            }
        }
        return os;
    }

    public URI toURI() {
        try {
            this.fs.lockForRead();
            try {
                URI uRI = new URI("semanticfs", null, null, -1, this.getPath().toString(), this.node.getQueryPart(), null);
                return uRI;
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            this.fs.unlockForRead();
        }
    }

    public SemanticFileSystem getFileSystem() {
        return this.fs;
    }

    public IFileStore mkdir(int options, IProgressMonitor monitor) throws CoreException {
        if (SfsTraceLocation.CORE_VERBOSE.isActive()) {
            SfsTraceLocation.getTrace().trace(SfsTraceLocation.CORE_VERBOSE.getLocation(), NLS.bind((String)Messages.SemanticFileStore_MkDir_XMSG, (Object)this.getPath().toString()));
        }
        try {
            this.fs.lockForWrite();
            this.checkAndJoinTreeIfAnotherEntryExists();
            ResourceTreeNode parent = this.fs.getParentNode(this.node);
            ISemanticContentProvider parentProvider = null;
            if ((options & 4) != 0) {
                if (parent != null && !parent.isExists()) {
                    throw new SemanticResourceException(SemanticResourceStatusCode.RESOURCE_PARENT_DOESNT_EXIST, this.getPath(), Messages.SemanticFileStore_ShallowMkDirFailed_XMSG);
                }
                parentProvider = parent != null ? this.fs.getStore(parent).getEffectiveContentProvider() : this.getEffectiveContentProvider();
            } else {
                parentProvider = parent != null && !parent.isExists() ? this.fs.mkdir(parent, this.fs.getParentNode(parent)) : (parent != null ? this.fs.getStore(parent).getEffectiveContentProvider() : this.getEffectiveContentProvider());
            }
            this.fs.makeFolder(this.node, parent, parentProvider);
        }
        finally {
            this.fs.unlockForWrite();
        }
        return this;
    }

    @Override
    public void createFileRemotely(String name, InputStream source, Object context, IProgressMonitor monitor) throws CoreException {
        if (SfsTraceLocation.CORE_VERBOSE.isActive()) {
            SfsTraceLocation.getTrace().traceDumpStack(SfsTraceLocation.CORE_VERBOSE.getLocation());
        }
        this.mkdir(0, monitor);
        ISemanticContentProvider effectiveProvider = this.getEffectiveContentProvider();
        if (SfsTraceLocation.CONTENTPROVIDER.isActive()) {
            SfsTraceLocation.getTrace().trace(SfsTraceLocation.CONTENTPROVIDER.getLocation(), MessageFormat.format(Messages.SemanticFileStore_CreateFileRemote_XMSG, name, effectiveProvider.getClass().getName(), this.getPath().toString()));
        }
        if (!(effectiveProvider instanceof ISemanticContentProviderRemote)) {
            throw new SemanticResourceException(SemanticResourceStatusCode.METHOD_NOT_SUPPORTED, this.getPath(), NLS.bind((String)Messages.SemanticFileStore_IntefaceNotImplemented_XMSG, (Object)effectiveProvider.getClass().getName(), (Object)ISemanticContentProviderRemote.class.getName()));
        }
        ((ISemanticContentProviderRemote)((Object)effectiveProvider)).createFileRemotely(this, name, source, context, monitor);
    }

    @Override
    public ISemanticFileStoreInternal createResourceRemotely(String name, Object context, IProgressMonitor monitor) throws CoreException {
        if (SfsTraceLocation.CORE_VERBOSE.isActive()) {
            SfsTraceLocation.getTrace().traceDumpStack(SfsTraceLocation.CORE_VERBOSE.getLocation());
        }
        this.mkdir(0, monitor);
        ISemanticContentProvider effectiveProvider = this.getEffectiveContentProvider();
        if (SfsTraceLocation.CONTENTPROVIDER.isActive()) {
            SfsTraceLocation.getTrace().trace(SfsTraceLocation.CONTENTPROVIDER.getLocation(), MessageFormat.format(Messages.SemanticFileStore_CreateResourceRemtoe_XMSG, name, effectiveProvider.getClass().getName(), this.getPath().toString()));
        }
        if (!(effectiveProvider instanceof ISemanticContentProviderRemote)) {
            throw new SemanticResourceException(SemanticResourceStatusCode.METHOD_NOT_SUPPORTED, this.getPath(), NLS.bind((String)Messages.SemanticFileStore_IntefaceNotImplemented_XMSG, (Object)effectiveProvider.getClass().getName(), (Object)ISemanticContentProviderRemote.class.getName()));
        }
        ((ISemanticContentProviderRemote)((Object)effectiveProvider)).createResourceRemotely(this, name, context, monitor);
        return this.findChild(name);
    }

    @Override
    public void addFileFromRemote(String name, IProgressMonitor monitor) throws CoreException {
        if (SfsTraceLocation.CORE_VERBOSE.isActive()) {
            SfsTraceLocation.getTrace().traceDumpStack(SfsTraceLocation.CORE_VERBOSE.getLocation());
        }
        this.mkdir(0, monitor);
        ISemanticContentProvider effectiveProvider = this.getEffectiveContentProvider();
        if (SfsTraceLocation.CONTENTPROVIDER.isActive()) {
            SfsTraceLocation.getTrace().trace(SfsTraceLocation.CONTENTPROVIDER.getLocation(), MessageFormat.format(Messages.SemanticFileStore_AddFileRemote_XMSG, name, effectiveProvider.getClass().getName(), this.getPath().toString()));
        }
        effectiveProvider.addResource(this, name, ISemanticFileStore.ResourceType.FILE_TYPE, monitor);
    }

    @Override
    public void addFileFromRemoteByURI(String name, URI uri, IProgressMonitor monitor) throws CoreException {
        if (SfsTraceLocation.CORE_VERBOSE.isActive()) {
            SfsTraceLocation.getTrace().traceDumpStack(SfsTraceLocation.CORE_VERBOSE.getLocation());
        }
        this.mkdir(0, monitor);
        ISemanticContentProvider effectiveProvider = this.getEffectiveContentProvider();
        if (effectiveProvider instanceof ISemanticContentProviderREST) {
            if (SfsTraceLocation.CONTENTPROVIDER.isActive()) {
                SfsTraceLocation.getTrace().trace(SfsTraceLocation.CONTENTPROVIDER.getLocation(), MessageFormat.format(Messages.SemanticFileStore_AddFileRemoteURI_XMSG, name, uri.toString(), effectiveProvider.getClass().getName(), this.getPath().toString()));
            }
        } else {
            throw new SemanticResourceException(SemanticResourceStatusCode.METHOD_NOT_SUPPORTED, this.getPath(), NLS.bind((String)Messages.SemanticFileStore_IntefaceNotImplemented_XMSG, (Object)effectiveProvider.getClass().getName(), (Object)ISemanticContentProviderREST.class.getName()));
        }
        ((ISemanticContentProviderREST)((Object)effectiveProvider)).addFileFromRemoteByURI(this, name, uri, monitor);
    }

    @Override
    public void addFolderFromRemoteByURI(String name, URI uri, IProgressMonitor monitor) throws CoreException {
        if (SfsTraceLocation.CORE_VERBOSE.isActive()) {
            SfsTraceLocation.getTrace().traceDumpStack(SfsTraceLocation.CORE_VERBOSE.getLocation());
        }
        this.mkdir(0, monitor);
        ISemanticContentProvider effectiveProvider = this.getEffectiveContentProvider();
        if (effectiveProvider instanceof ISemanticContentProviderREST) {
            if (SfsTraceLocation.CONTENTPROVIDER.isActive()) {
                SfsTraceLocation.getTrace().trace(SfsTraceLocation.CONTENTPROVIDER.getLocation(), MessageFormat.format(Messages.SemanticFileStore_AddFileRemoteURI_XMSG, name, uri.toString(), effectiveProvider.getClass().getName(), this.getPath().toString()));
            }
        } else {
            throw new SemanticResourceException(SemanticResourceStatusCode.METHOD_NOT_SUPPORTED, this.getPath(), NLS.bind((String)Messages.SemanticFileStore_IntefaceNotImplemented_XMSG, (Object)effectiveProvider.getClass().getName(), (Object)ISemanticContentProviderREST.class.getName()));
        }
        ((ISemanticContentProviderREST)((Object)effectiveProvider)).addFolderFromRemoteByURI(this, name, uri, monitor);
    }

    @Override
    public void addFolderFromRemote(String name, IProgressMonitor monitor) throws CoreException {
        if (SfsTraceLocation.CORE_VERBOSE.isActive()) {
            SfsTraceLocation.getTrace().traceDumpStack(SfsTraceLocation.CORE_VERBOSE.getLocation());
        }
        this.mkdir(0, monitor);
        ISemanticContentProvider effectiveProvider = this.getEffectiveContentProvider();
        if (SfsTraceLocation.CONTENTPROVIDER.isActive()) {
            SfsTraceLocation.getTrace().trace(SfsTraceLocation.CONTENTPROVIDER.getLocation(), MessageFormat.format(Messages.SemanticFileStore_AddFolderRemote_XMSG, name, effectiveProvider.getClass().getName(), this.getPath().toString()));
        }
        effectiveProvider.addResource(this, name, ISemanticFileStore.ResourceType.FOLDER_TYPE, monitor);
    }

    @Override
    public ISemanticFileStoreInternal addResourceFromRemote(String name, IProgressMonitor monitor) throws CoreException {
        if (SfsTraceLocation.CORE_VERBOSE.isActive()) {
            SfsTraceLocation.getTrace().traceDumpStack(SfsTraceLocation.CORE_VERBOSE.getLocation());
        }
        this.mkdir(0, monitor);
        ISemanticContentProvider effectiveProvider = this.getEffectiveContentProvider();
        if (SfsTraceLocation.CONTENTPROVIDER.isActive()) {
            SfsTraceLocation.getTrace().trace(SfsTraceLocation.CONTENTPROVIDER.getLocation(), MessageFormat.format(Messages.SemanticFileStore_AddResourceRemote_XMSG, name, effectiveProvider.getClass().getName(), this.getPath().toString()));
        }
        effectiveProvider.addResource(this, name, ISemanticFileStore.ResourceType.UNKNOWN_TYPE, monitor);
        return this.findChild(name);
    }

    @Override
    public void addResource(String name, boolean asFolder, String contentProviderID, Map<QualifiedName, String> properties, IProgressMonitor monitor) throws CoreException {
        if (SfsTraceLocation.CORE_VERBOSE.isActive()) {
            SfsTraceLocation.getTrace().traceDumpStack(SfsTraceLocation.CORE_VERBOSE.getLocation());
        }
        this.mkdir(0, monitor);
        ISemanticContentProvider effectiveProvider = this.getEffectiveContentProvider();
        if (!(effectiveProvider instanceof ISemanticContentProviderFederation)) {
            throw new SemanticResourceException(SemanticResourceStatusCode.METHOD_NOT_SUPPORTED, this.getPath(), NLS.bind((String)Messages.SemanticFileStore_IntefaceNotImplemented_XMSG, (Object)effectiveProvider.getClass().getName(), (Object)ISemanticContentProviderFederation.class.getName()));
        }
        ((ISemanticContentProviderFederation)((Object)effectiveProvider)).addResource(this, name, asFolder ? ISemanticFileStore.ResourceType.FOLDER_TYPE : ISemanticFileStore.ResourceType.FILE_TYPE, contentProviderID, properties);
    }

    public void delete(int options, IProgressMonitor monitor) throws CoreException {
        if (SfsTraceLocation.CORE_VERBOSE.isActive()) {
            SfsTraceLocation.getTrace().traceDumpStack(SfsTraceLocation.CORE_VERBOSE.getLocation());
        }
        this.removeFromWorkspace(monitor);
    }

    @Override
    public void deleteRemotely(IProgressMonitor monitor) throws CoreException {
        if (SfsTraceLocation.CORE_VERBOSE.isActive()) {
            SfsTraceLocation.getTrace().traceDumpStack(SfsTraceLocation.CORE_VERBOSE.getLocation());
        }
        this.checkAndJoinTreeIfAnotherEntryExists();
        ISemanticContentProvider effectiveProvider = this.getEffectiveContentProvider();
        if (SfsTraceLocation.CONTENTPROVIDER.isActive()) {
            SfsTraceLocation.getTrace().trace(SfsTraceLocation.CONTENTPROVIDER.getLocation(), NLS.bind((String)Messages.SemanticFileStore_DeleteResourceRemote_XMSG, (Object)this.getPath().toString(), (Object)effectiveProvider.getClass().getName()));
        }
        if (!(effectiveProvider instanceof ISemanticContentProviderRemote)) {
            throw new SemanticResourceException(SemanticResourceStatusCode.METHOD_NOT_SUPPORTED, this.getPath(), NLS.bind((String)Messages.SemanticFileStore_IntefaceNotImplemented_XMSG, (Object)effectiveProvider.getClass().getName(), (Object)ISemanticContentProviderRemote.class.getName()));
        }
        ((ISemanticContentProviderRemote)((Object)effectiveProvider)).deleteRemotely(this, monitor);
    }

    @Override
    public void removeFromWorkspace(IProgressMonitor monitor) throws CoreException {
        if (SfsTraceLocation.CORE_VERBOSE.isActive()) {
            SfsTraceLocation.getTrace().traceDumpStack(SfsTraceLocation.CORE_VERBOSE.getLocation());
        }
        ISemanticContentProvider effectiveProvider = this.getEffectiveContentProvider();
        if (SfsTraceLocation.CONTENTPROVIDER.isActive()) {
            SfsTraceLocation.getTrace().trace(SfsTraceLocation.CONTENTPROVIDER.getLocation(), NLS.bind((String)Messages.SemanticFileStore_RemoveResourceRemote_XMSG, (Object)this.getPath().toString(), (Object)effectiveProvider.getClass().getName()));
        }
        this.checkAccessible();
        effectiveProvider.removeResource(this, monitor);
    }

    @Override
    public void forceRemoveFromWorkspace(int options, IProgressMonitor monitor) throws CoreException {
        if (SfsTraceLocation.CORE_VERBOSE.isActive()) {
            SfsTraceLocation.getTrace().traceDumpStack(SfsTraceLocation.CORE_VERBOSE.getLocation());
        }
        this.checkAccessible();
        new FileCacheServiceFactory().getCacheService().removeContentRecursive(this.getPath(), monitor);
        new MemoryCacheServiceFactory().getCacheService().removeContentRecursive(this.getPath(), monitor);
        this.remove(monitor);
    }

    @Override
    public void forceRemove(int options, IProgressMonitor monitor) throws CoreException {
        this.forceRemoveFromWorkspace(options, monitor);
    }

    @Override
    public void synchronizeContentWithRemote(SyncDirection direction, IProgressMonitor monitor) throws CoreException {
        if (SfsTraceLocation.CORE_VERBOSE.isActive()) {
            SfsTraceLocation.getTrace().traceDumpStack(SfsTraceLocation.CORE_VERBOSE.getLocation());
        }
        ISemanticContentProvider effectiveProvider = this.getEffectiveContentProvider();
        if (SfsTraceLocation.CONTENTPROVIDER.isActive()) {
            SfsTraceLocation.getTrace().trace(SfsTraceLocation.CONTENTPROVIDER.getLocation(), NLS.bind((String)Messages.SemanticFileStore_SynchContent_XMSG, (Object)effectiveProvider.getClass().getName(), (Object)this.getPath().toString()));
        }
        this.checkAccessible();
        MultiStatus status = new MultiStatus("org.eclipse.core.resources.semantic", 0, NLS.bind((String)Messages.SemanticFileStore_SyncContent_XGRP, (Object)this.getPath().toString()), null);
        effectiveProvider.synchronizeContentWithRemote(this, direction, monitor, status);
        if (!status.isOK()) {
            throw new CoreException((IStatus)status);
        }
    }

    @Override
    public void setRemoteURI(URI uri, IProgressMonitor monitor) throws CoreException {
        ISemanticContentProvider effectiveProvider = this.getEffectiveContentProvider();
        if (SfsTraceLocation.CORE_VERBOSE.isActive()) {
            SfsTraceLocation.getTrace().traceDumpStack(SfsTraceLocation.CORE_VERBOSE.getLocation());
        }
        this.checkAccessible();
        if (effectiveProvider instanceof ISemanticContentProviderREST) {
            if (SfsTraceLocation.CONTENTPROVIDER.isActive()) {
                SfsTraceLocation.getTrace().trace(SfsTraceLocation.CONTENTPROVIDER.getLocation(), MessageFormat.format(Messages.SemanticFileStore_SettingURI_XMSG, uri.toString(), effectiveProvider.getClass().getName(), this.getPath().toString()));
            }
        } else {
            throw new SemanticResourceException(SemanticResourceStatusCode.METHOD_NOT_SUPPORTED, this.getPath(), NLS.bind((String)Messages.SemanticFileStore_IntefaceNotImplemented_XMSG, (Object)effectiveProvider.getClass().getName(), (Object)ISemanticContentProviderREST.class.getName()));
        }
        ((ISemanticContentProviderREST)((Object)effectiveProvider)).setURIString(this, uri, monitor);
    }

    @Override
    public void revertChanges(IProgressMonitor monitor) throws CoreException {
        ISemanticContentProvider effectiveProvider = this.getEffectiveContentProvider();
        if (SfsTraceLocation.CORE_VERBOSE.isActive()) {
            SfsTraceLocation.getTrace().traceDumpStack(SfsTraceLocation.CORE_VERBOSE.getLocation());
        }
        if (SfsTraceLocation.CONTENTPROVIDER.isActive()) {
            SfsTraceLocation.getTrace().trace(SfsTraceLocation.CONTENTPROVIDER.getLocation(), NLS.bind((String)Messages.SemanticFileStore_Revert_XMSG, (Object)this.getPath().toString(), (Object)effectiveProvider.getClass().getName()));
        }
        this.checkAccessible();
        effectiveProvider.revertChanges(this, monitor);
    }

    @Override
    public IStatus lockResource(IProgressMonitor monitor) throws CoreException {
        if (SfsTraceLocation.CORE_VERBOSE.isActive()) {
            SfsTraceLocation.getTrace().traceDumpStack(SfsTraceLocation.CORE_VERBOSE.getLocation());
        }
        ISemanticContentProvider effectiveProvider = this.getEffectiveContentProvider();
        if (SfsTraceLocation.CONTENTPROVIDER.isActive()) {
            SfsTraceLocation.getTrace().trace(SfsTraceLocation.CONTENTPROVIDER.getLocation(), NLS.bind((String)Messages.SemanticFileStore_Locking_XMSG, (Object)this.getPath().toString(), (Object)effectiveProvider.getClass().getName()));
        }
        this.checkAccessible();
        if (effectiveProvider instanceof ISemanticContentProviderLocking) {
            return ((ISemanticContentProviderLocking)((Object)effectiveProvider)).lockResource(this, monitor);
        }
        return new Status(4, "org.eclipse.core.resources.semantic", NLS.bind((String)Messages.SemanticFileStore_IntefaceNotImplemented_XMSG, (Object)effectiveProvider.getClass().getName(), (Object)ISemanticContentProviderLocking.class.getName()));
    }

    @Override
    public IStatus unlockResource(IProgressMonitor monitor) throws CoreException {
        if (SfsTraceLocation.CORE_VERBOSE.isActive()) {
            SfsTraceLocation.getTrace().traceDumpStack(SfsTraceLocation.CORE_VERBOSE.getLocation());
        }
        ISemanticContentProvider effectiveProvider = this.getEffectiveContentProvider();
        if (SfsTraceLocation.CONTENTPROVIDER.isActive()) {
            SfsTraceLocation.getTrace().trace(SfsTraceLocation.CONTENTPROVIDER.getLocation(), NLS.bind((String)Messages.SemanticFileStore_Unlocking_XMSG, (Object)this.getPath().toString(), (Object)effectiveProvider.getClass().getName()));
        }
        this.checkAccessible();
        if (effectiveProvider instanceof ISemanticContentProviderLocking) {
            return ((ISemanticContentProviderLocking)((Object)effectiveProvider)).unlockResource(this, monitor);
        }
        return new Status(4, "org.eclipse.core.resources.semantic", NLS.bind((String)Messages.SemanticFileStore_IntefaceNotImplemented_XMSG, (Object)effectiveProvider.getClass().getName(), (Object)ISemanticContentProviderLocking.class.getName()));
    }

    @Override
    public IStatus validateRemoteCreate(String name, Object shell) {
        ISemanticContentProvider effectiveProvider;
        if (SfsTraceLocation.CORE_VERBOSE.isActive()) {
            SfsTraceLocation.getTrace().traceDumpStack(SfsTraceLocation.CORE_VERBOSE.getLocation());
        }
        try {
            this.checkAccessible();
            effectiveProvider = this.getEffectiveContentProvider();
        }
        catch (CoreException ce) {
            this.log.log(ce);
            return ce.getStatus();
        }
        if (SfsTraceLocation.CONTENTPROVIDER.isActive()) {
            SfsTraceLocation.getTrace().trace(SfsTraceLocation.CONTENTPROVIDER.getLocation(), MessageFormat.format(Messages.SemanticFileStore_ValidateRemoteCreate_XMSG, name, effectiveProvider.getClass().getName(), this.getPath().toString()));
        }
        if (effectiveProvider instanceof ISemanticContentProviderRemote) {
            return ((ISemanticContentProviderRemote)((Object)effectiveProvider)).validateRemoteCreate(this, name, shell);
        }
        return new Status(4, "org.eclipse.core.resources.semantic", NLS.bind((String)Messages.SemanticFileStore_IntefaceNotImplemented_XMSG, (Object)effectiveProvider.getClass().getName(), (Object)ISemanticContentProviderRemote.class.getName()));
    }

    @Override
    public IStatus validateRemoteDelete(Object shell) {
        boolean canBeDeleted;
        ISemanticContentProvider effectiveProvider;
        if (SfsTraceLocation.CORE_VERBOSE.isActive()) {
            SfsTraceLocation.getTrace().traceDumpStack(SfsTraceLocation.CORE_VERBOSE.getLocation());
        }
        try {
            this.checkAccessible();
        }
        catch (CoreException e) {
            return e.getStatus();
        }
        try {
            effectiveProvider = this.getEffectiveContentProvider();
        }
        catch (CoreException e) {
            this.log.log(e);
            return e.getStatus();
        }
        try {
            this.fs.lockForRead();
            canBeDeleted = this.node.isExists();
        }
        finally {
            this.fs.unlockForRead();
        }
        if (canBeDeleted) {
            if (SfsTraceLocation.CONTENTPROVIDER.isActive()) {
                SfsTraceLocation.getTrace().trace(SfsTraceLocation.CONTENTPROVIDER.getLocation(), MessageFormat.format(Messages.SemanticFileStore_ValidateRemoteDelete_XMSG, this.getPath().toString(), effectiveProvider.getClass().getName()));
            }
            if (effectiveProvider instanceof ISemanticContentProviderRemote) {
                return ((ISemanticContentProviderRemote)((Object)effectiveProvider)).validateRemoteDelete(this, shell);
            }
            return new Status(4, "org.eclipse.core.resources.semantic", NLS.bind((String)Messages.SemanticFileStore_IntefaceNotImplemented_XMSG, (Object)effectiveProvider.getClass().getName(), (Object)ISemanticContentProviderRemote.class.getName()));
        }
        return new Status(8, "org.eclipse.core.resources.semantic", null);
    }

    @Override
    public IStatus validateRemove(int options, IProgressMonitor monitor) {
        boolean canBeDeleted;
        ISemanticContentProvider effectiveProvider;
        if (SfsTraceLocation.CORE_VERBOSE.isActive()) {
            SfsTraceLocation.getTrace().traceDumpStack(SfsTraceLocation.CORE_VERBOSE.getLocation());
        }
        try {
            this.checkAccessible();
        }
        catch (CoreException e) {
            return e.getStatus();
        }
        try {
            effectiveProvider = this.getEffectiveContentProvider();
        }
        catch (CoreException e) {
            this.log.log(e);
            return e.getStatus();
        }
        try {
            this.fs.lockForRead();
            canBeDeleted = this.node.isExists();
        }
        finally {
            this.fs.unlockForRead();
        }
        if (canBeDeleted) {
            if (SfsTraceLocation.CONTENTPROVIDER.isActive()) {
                SfsTraceLocation.getTrace().trace(SfsTraceLocation.CONTENTPROVIDER.getLocation(), NLS.bind((String)Messages.SemanticFileStore_ValidateRemove_XMSG, (Object)this.getPath().toString(), (Object)effectiveProvider.getClass().getName()));
            }
            try {
                return effectiveProvider.validateRemove(this, options, monitor);
            }
            catch (CoreException e) {
                this.log.log(e);
                return e.getStatus();
            }
        }
        return new Status(8, "org.eclipse.core.resources.semantic", null);
    }

    @Override
    public void addChildFolder(String name) throws CoreException {
        if (SfsTraceLocation.CORE_VERBOSE.isActive()) {
            SfsTraceLocation.getTrace().traceDumpStack(SfsTraceLocation.CORE_VERBOSE.getLocation());
        }
        if (SfsTraceLocation.CORE.isActive()) {
            SfsTraceLocation.getTrace().trace(SfsTraceLocation.CORE.getLocation(), NLS.bind((String)Messages.SemanticFileStore_AddChildFolder_XMSG, (Object)name, (Object)this.getPath().toString()));
        }
        try {
            this.fs.lockForWrite();
            this.checkAccessible();
            this.checkChildExists(name);
            this.createChildNode(name, true, null);
            this.fs.requestFlush(false);
        }
        finally {
            this.fs.unlockForWrite();
        }
    }

    @Override
    public void addChildResource(String name, boolean asFolder, String contentProviderID, Map<QualifiedName, String> properties) throws CoreException {
        ResourceTreeNode child;
        if (SfsTraceLocation.CORE_VERBOSE.isActive()) {
            SfsTraceLocation.getTrace().traceDumpStack(SfsTraceLocation.CORE_VERBOSE.getLocation());
        }
        if (SfsTraceLocation.CORE.isActive()) {
            String message = asFolder ? NLS.bind((String)Messages.SemanticFileStore_AddContentProviderRootFolder_XMSG, (Object)name, (Object)this.getPath().toString()) : NLS.bind((String)Messages.SemanticFileStore_AddContentProviderRootFile_XMSG, (Object)name, (Object)this.getPath().toString());
            SfsTraceLocation.getTrace().trace(SfsTraceLocation.CORE.getLocation(), message);
        }
        try {
            this.fs.lockForWrite();
            this.checkAccessible();
            this.checkChildExists(name);
            child = this.createChildNode(name, asFolder, contentProviderID);
            HashMap<String, String> propsMap = new HashMap<String, String>();
            if (properties != null && !properties.isEmpty()) {
                for (Map.Entry<QualifiedName, String> entry : properties.entrySet()) {
                    propsMap.put(Util.qualifiedNameToString(entry.getKey()), entry.getValue());
                }
                child.setPersistentProperties(propsMap);
            } else {
                child.setPersistentProperties(null);
            }
            this.fs.requestFlush(false);
        }
        finally {
            this.fs.unlockForWrite();
        }
        if (contentProviderID != null) {
            ISemanticFileStore store = this.fs.getStore(child);
            store.getEffectiveContentProvider().onRootStoreCreate(store);
        }
    }

    @Override
    public void addChildFile(String name) throws CoreException {
        if (SfsTraceLocation.CORE_VERBOSE.isActive()) {
            SfsTraceLocation.getTrace().traceDumpStack(SfsTraceLocation.CORE_VERBOSE.getLocation());
        }
        if (SfsTraceLocation.CORE.isActive()) {
            SfsTraceLocation.getTrace().trace(SfsTraceLocation.CORE.getLocation(), NLS.bind((String)Messages.SemanticFileStore_AddChildFile_XMSG, (Object)name, (Object)this.getPath().toString()));
        }
        try {
            this.fs.lockForWrite();
            this.checkAccessible();
            this.checkChildExists(name);
            this.createChildNode(name, false, null);
            this.fs.requestFlush(false);
        }
        finally {
            this.fs.unlockForWrite();
        }
    }

    @Override
    public void addLocalChildResource(String name, String contentProviderID) throws CoreException {
        if (SfsTraceLocation.CORE_VERBOSE.isActive()) {
            SfsTraceLocation.getTrace().traceDumpStack(SfsTraceLocation.CORE_VERBOSE.getLocation());
        }
        if (SfsTraceLocation.CORE.isActive()) {
            SfsTraceLocation.getTrace().trace(SfsTraceLocation.CORE.getLocation(), NLS.bind((String)Messages.SemanticFileStore_AddLocalChild_XMSG, (Object)name, (Object)this.getPath().toString()));
        }
        try {
            this.fs.lockForWrite();
            this.checkAccessible();
            this.checkChildExists(name);
            this.createLocalChildNode(name, this.getPath().append(name), contentProviderID);
            this.fs.requestFlush(false);
        }
        finally {
            this.fs.unlockForWrite();
        }
    }

    @Override
    public boolean hasResource(String name) {
        try {
            this.fs.lockForRead();
            this.checkAndJoinTreeIfAnotherEntryExists();
            EList<ResourceTreeNode> children = this.node.getChildren();
            for (ResourceTreeNode resourceTreeNode : children) {
                if (!resourceTreeNode.getName().equals(name)) continue;
                boolean bl = resourceTreeNode.isExists();
                return bl;
            }
            return false;
        }
        finally {
            this.fs.unlockForRead();
        }
    }

    @Override
    public boolean hasChild(String name) {
        return this.hasResource(name);
    }

    @Override
    public String getContentProviderID() {
        try {
            this.fs.lockForRead();
            this.checkAndJoinTreeIfAnotherEntryExists();
            String string = this.node.getTemplateID();
            return string;
        }
        finally {
            this.fs.unlockForRead();
        }
    }

    @Override
    public URI getRemoteURI() throws CoreException {
        this.checkAccessible();
        ISemanticContentProvider effectiveProvider = this.getEffectiveContentProvider();
        if (effectiveProvider instanceof ISemanticContentProviderREST) {
            try {
                String uriString = ((ISemanticContentProviderREST)((Object)effectiveProvider)).getURIString(this);
                return new URI(uriString);
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new SemanticResourceException(SemanticResourceStatusCode.INVALID_URI_SYNTAX, this.getPath(), NLS.bind((String)Messages.SemanticFileStore_InvalidURISyntax_XMSG, (Object)effectiveProvider.getClass().getName(), (Object)ISemanticContentProviderREST.class.getName()));
            }
        }
        throw new SemanticResourceException(SemanticResourceStatusCode.METHOD_NOT_SUPPORTED, this.getPath(), NLS.bind((String)Messages.SemanticFileStore_IntefaceNotImplemented_XMSG, (Object)effectiveProvider.getClass().getName(), (Object)ISemanticContentProviderREST.class.getName()));
    }

    @Override
    public boolean isExists() {
        try {
            this.fs.lockForRead();
            this.checkAndJoinTreeIfAnotherEntryExists();
            boolean bl = this.node.isExists();
            return bl;
        }
        finally {
            this.fs.unlockForRead();
        }
    }

    @Override
    public boolean isLocalOnly() {
        try {
            this.fs.lockForRead();
            this.checkAndJoinTreeIfAnotherEntryExists();
            boolean bl = this.node.isLocalOnly();
            return bl;
        }
        finally {
            this.fs.unlockForRead();
        }
    }

    @Override
    public void setLocalOnly(boolean isLocalOnly) {
        try {
            this.fs.lockForWrite();
            this.checkAndJoinTreeIfAnotherEntryExists();
            this.node.setLocalOnly(isLocalOnly);
        }
        finally {
            this.fs.unlockForWrite();
        }
    }

    private SemanticFileStore findChild(String name) {
        try {
            this.fs.lockForRead();
            this.checkAndJoinTreeIfAnotherEntryExists();
            EList<ResourceTreeNode> children = this.node.getChildren();
            for (ResourceTreeNode resourceTreeNode : children) {
                if (!resourceTreeNode.getName().equals(name)) continue;
                SemanticFileStore semanticFileStore = (SemanticFileStore)this.fs.getStore(resourceTreeNode);
                return semanticFileStore;
            }
        }
        finally {
            this.fs.unlockForRead();
        }
        return null;
    }

    private ResourceTreeNode createChildNode(String name, boolean isFolder, String contentProviderID) {
        ResourceTreeNode child = SemanticResourceDBFactory.eINSTANCE.createResourceTreeNode();
        child.setName(name);
        child.setTemplateID(contentProviderID);
        if (isFolder) {
            child.setType(TreeNodeType.FOLDER);
            child.setLocalOnly(true);
        } else {
            child.setType(TreeNodeType.FILE);
            child.setLocalOnly(false);
        }
        child.setExists(true);
        child.setParent(this.node);
        return child;
    }

    private ResourceTreeNode createLocalChildNode(String name, IPath childPath, String contentProviderID) {
        ResourceTreeNode child = SemanticResourceDBFactory.eINSTANCE.createResourceTreeNode();
        child.setName(name);
        child.setTemplateID(contentProviderID);
        child.setType(TreeNodeType.UNKNOWN);
        child.setExists(false);
        child.setPath(childPath.toString());
        child.setLocalOnly(true);
        return child;
    }

    private void checkChildExists(String name) throws CoreException {
        EList<ResourceTreeNode> children = this.node.getChildren();
        for (ResourceTreeNode resourceTreeNode : children) {
            if (!resourceTreeNode.getName().equals(name) || !resourceTreeNode.isExists()) continue;
            IPath newPath = this.getPath().append(name);
            throw new SemanticResourceException(SemanticResourceStatusCode.RESOURCE_ALREADY_EXISTS, newPath, NLS.bind((String)Messages.SemanticFileStore_ResourceWithPathExists_XMSG, (Object)newPath.toString()));
        }
    }

    private static void cleanupNodeAndChildren(ResourceTreeNode node, IPath path) {
        EList<ResourceTreeNode> children = node.getChildren();
        for (ResourceTreeNode resourceTreeNode : children) {
            SemanticFileStore.cleanupNodeAndChildren(resourceTreeNode, path.append(resourceTreeNode.getName()));
        }
        node.setPath(path.toString());
        node.setExists(false);
        node.setPersistentProperties(null);
        node.setSessionProperties(null);
        children.clear();
    }

    @Override
    public IStatus validateEdit(Object shell) {
        boolean canBeEdited;
        ISemanticContentProvider effectiveProvider;
        if (SfsTraceLocation.CORE_VERBOSE.isActive()) {
            SfsTraceLocation.getTrace().traceDumpStack(SfsTraceLocation.CORE_VERBOSE.getLocation());
        }
        try {
            this.checkAccessible();
        }
        catch (CoreException e) {
            return e.getStatus();
        }
        try {
            effectiveProvider = this.getEffectiveContentProvider();
        }
        catch (CoreException e) {
            this.log.log(e);
            return e.getStatus();
        }
        try {
            this.fs.lockForRead();
            canBeEdited = this.node.isExists() && this.node.getType().equals((Object)TreeNodeType.FILE);
        }
        finally {
            this.fs.unlockForRead();
        }
        if (canBeEdited) {
            boolean readOnly;
            try {
                readOnly = effectiveProvider.fetchResourceInfo(this, 16, null).isReadOnly();
            }
            catch (CoreException e) {
                this.log.log(e);
                return e.getStatus();
            }
            if (readOnly) {
                if (SfsTraceLocation.CONTENTPROVIDER.isActive()) {
                    SfsTraceLocation.getTrace().trace(SfsTraceLocation.CONTENTPROVIDER.getLocation(), NLS.bind((String)Messages.SemanticFileStore_ValidateEdit_XMSG, (Object)effectiveProvider.getClass().getName(), (Object)this.getPath().toString()));
                }
                return effectiveProvider.validateEdit(new ISemanticFileStore[]{this}, shell);
            }
            return new Status(0, "org.eclipse.core.resources.semantic", null);
        }
        return new Status(8, "org.eclipse.core.resources.semantic", null);
    }

    @Override
    public IStatus validateSave() {
        boolean canBeSaved;
        ISemanticContentProvider effectiveProvider;
        if (SfsTraceLocation.CORE_VERBOSE.isActive()) {
            SfsTraceLocation.getTrace().traceDumpStack(SfsTraceLocation.CORE_VERBOSE.getLocation());
        }
        try {
            this.checkAccessible();
        }
        catch (CoreException e) {
            return e.getStatus();
        }
        try {
            effectiveProvider = this.getEffectiveContentProvider();
        }
        catch (CoreException e) {
            this.log.log(e);
            return e.getStatus();
        }
        try {
            this.fs.lockForRead();
            canBeSaved = this.node.isExists() && this.node.getType().equals((Object)TreeNodeType.FILE);
        }
        finally {
            this.fs.unlockForRead();
        }
        if (canBeSaved) {
            boolean readOnly;
            try {
                readOnly = effectiveProvider.fetchResourceInfo(this, 16, null).isReadOnly();
            }
            catch (CoreException e) {
                this.log.log(e);
                return e.getStatus();
            }
            if (!readOnly) {
                if (SfsTraceLocation.CONTENTPROVIDER.isActive()) {
                    SfsTraceLocation.getTrace().trace(SfsTraceLocation.CONTENTPROVIDER.getLocation(), NLS.bind((String)Messages.SemanticFileStore_ValidateSave_XMSG, (Object)effectiveProvider.getClass().getName(), (Object)this.getPath().toString()));
                }
                return effectiveProvider.validateSave(this);
            }
            return new Status(8, "org.eclipse.core.resources.semantic", NLS.bind((String)Messages.SemanticFileStore_NotWritable_XMSG, (Object)this.getPath().toString()));
        }
        return new Status(8, "org.eclipse.core.resources.semantic", null);
    }

    @Override
    public IPath getPath() {
        try {
            this.fs.lockForRead();
            this.checkAndJoinTreeIfAnotherEntryExists();
            IPath iPath = this.fs.getPathForNode(this.node);
            return iPath;
        }
        finally {
            this.fs.unlockForRead();
        }
    }

    @Override
    public void remove(IProgressMonitor monitor) throws CoreException {
        if (SfsTraceLocation.CORE_VERBOSE.isActive()) {
            SfsTraceLocation.getTrace().traceDumpStack(SfsTraceLocation.CORE_VERBOSE.getLocation());
        }
        if (SfsTraceLocation.CORE.isActive()) {
            SfsTraceLocation.getTrace().trace(SfsTraceLocation.CORE.getLocation(), NLS.bind((String)Messages.SemanticFileStore_RemovingResource_XMSG, (Object)this.getPath().toString()));
        }
        try {
            this.fs.lockForWrite();
            this.checkAccessible();
            SemanticFileStore.cleanupNodeAndChildren(this.node, this.getPath());
            if (this.node instanceof TreeRoot) {
                ((TreeRoot)this.node).setParentDB(null);
            } else {
                this.node.setParent(null);
            }
            this.fs.requestFlush(false);
            this.fs.requestURILocatorRebuild();
        }
        finally {
            this.fs.unlockForWrite();
        }
    }

    @Override
    public ISemanticResourceInfo fetchResourceInfo(int options, IProgressMonitor monitor) throws CoreException {
        ISemanticSpiResourceInfo providerInfo = this.getEffectiveContentProvider().fetchResourceInfo(this, options, this.getNotNullMonitor(monitor));
        return new SemanticResourceInfo(options, providerInfo, this.isLocalOnly());
    }

    @Override
    public int getType() {
        try {
            this.fs.lockForRead();
            this.checkAndJoinTreeIfAnotherEntryExists();
            int n = this.node.getType().getValue();
            return n;
        }
        finally {
            this.fs.unlockForRead();
        }
    }

    @Override
    public ISemanticFileStoreInternal getChildResource(String name) {
        return this.findChild(name);
    }

    public void setProvider(ISemanticContentProvider contentProvider) {
        this.provider = contentProvider;
    }

    @Override
    protected void notifyPersistentPropertySet(String keyString, String oldValue, String newValue) throws CoreException {
    }

    @Override
    public IPath[] findURI(URI uri, IProgressMonitor monitor) throws CoreException {
        return this.fs.getURILocatorService(monitor).locateURI(uri, this.getPath());
    }

    @Override
    public String getRemoteURIString() {
        return this.node.getRemoteURI();
    }

    @Override
    public void setRemoteURIString(String uriString) {
        String oldValue = this.node.getRemoteURI();
        this.node.setRemoteURI(uriString);
        if (this.fs.getURILocator() != null && (oldValue == null && uriString != null || oldValue != null && !oldValue.equals(uriString))) {
            IPath path = this.getPath();
            if (oldValue != null) {
                this.fs.getURILocator().removeURI(path, oldValue);
            }
            if (uriString != null) {
                this.fs.getURILocator().addURI(path, uriString);
            }
        }
    }

    private IProgressMonitor getNotNullMonitor(IProgressMonitor monitor) {
        if (monitor == null) {
            return new NullProgressMonitor();
        }
        return monitor;
    }

    private static class ContentProviderData {
        ISemanticContentProvider provider;
        String providerID;

        ContentProviderData(ISemanticContentProvider provider, String providerID) {
            this.provider = provider;
            this.providerID = providerID;
        }
    }
}

