/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.repository.rcp;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.List;
import org.eclipse.dirigible.repository.api.IResource;
import org.eclipse.dirigible.repository.api.IResourceVersion;
import org.eclipse.dirigible.repository.api.RepositoryPath;
import org.eclipse.dirigible.repository.rcp.Messages;
import org.eclipse.dirigible.repository.rcp.RCPBaseException;
import org.eclipse.dirigible.repository.rcp.RCPEntity;
import org.eclipse.dirigible.repository.rcp.RCPFile;
import org.eclipse.dirigible.repository.rcp.RCPObject;
import org.eclipse.dirigible.repository.rcp.RCPRepository;

public class RCPResource
extends RCPEntity
implements IResource {
    private static final String THERE_IS_NO_RESOURCE_AT_PATH_0 = Messages.getString("DBResource.THERE_IS_NO_RESOURCE_AT_PATH_0");
    private static final String COULD_NOT_UPDATE_DOCUMENT = Messages.getString("DBResource.COULD_NOT_UPDATE_DOCUMENT");
    private static final String COULD_NOT_READ_RESOURCE_CONTENT = Messages.getString("DBResource.COULD_NOT_READ_RESOURCE_CONTENT");
    private static final String NOT_IMPLEMENTED = Messages.getString("DBResource.NOT_IMPLEMENTED");
    private static final String COULD_NOT_DELETE_RESOURCE = Messages.getString("DBResource.COULD_NOT_DELETE_RESOURCE");
    private static final String COULD_NOT_RENAME_RESOURCE = Messages.getString("DBResource.COULD_NOT_RENAME_RESOURCE");
    private boolean binary = false;
    private String contentType;

    public RCPResource(RCPRepository repository, RepositoryPath path) {
        super(repository, path);
        RCPFile rcpFile = this.getDocument();
        if (rcpFile != null) {
            this.binary = rcpFile.isBinary();
            this.contentType = rcpFile.getContentType();
        }
    }

    public void create() throws IOException {
        this.getParent().createResource(this.getName(), null, false, "text/plain");
    }

    public void delete() throws IOException {
        RCPFile document = this.getDocumentSafe();
        try {
            document.delete();
        }
        catch (RCPBaseException ex) {
            throw new IOException(String.valueOf(COULD_NOT_DELETE_RESOURCE) + this.getName(), (Throwable)((Object)ex));
        }
    }

    public void renameTo(String name) throws IOException {
        RCPFile document = this.getDocumentSafe();
        try {
            document.rename(RepositoryPath.normalizePath((String)this.getParent().getPath(), (String)name));
        }
        catch (RCPBaseException ex) {
            throw new IOException(String.valueOf(COULD_NOT_RENAME_RESOURCE) + this.getName(), (Throwable)((Object)ex));
        }
    }

    public void moveTo(String path) throws IOException {
        RCPFile document = this.getDocumentSafe();
        try {
            document.rename(path);
        }
        catch (RCPBaseException ex) {
            throw new IOException(String.valueOf(COULD_NOT_RENAME_RESOURCE) + this.getName(), (Throwable)((Object)ex));
        }
    }

    public void copyTo(String path) throws IOException {
        throw new IOException(NOT_IMPLEMENTED);
    }

    public boolean exists() throws IOException {
        return this.getDocument() != null;
    }

    public boolean isEmpty() throws IOException {
        return this.getContent().length == 0;
    }

    public byte[] getContent() throws IOException {
        RCPFile document = this.getDocumentSafe();
        try {
            byte[] bytes = document.getData();
            return bytes;
        }
        catch (RCPBaseException ex) {
            throw new IOException(COULD_NOT_READ_RESOURCE_CONTENT, (Throwable)((Object)ex));
        }
    }

    public void setContent(byte[] content) throws IOException {
        if (this.contentType == null || "".equals(this.contentType)) {
            this.contentType = "text/plain";
        }
        if (this.exists()) {
            RCPFile document = this.getDocumentSafe();
            try {
                document.setData(content);
            }
            catch (RCPBaseException ex) {
                throw new IOException(COULD_NOT_UPDATE_DOCUMENT, (Throwable)((Object)ex));
            }
        } else {
            this.getParent().createResource(this.getName(), content, this.binary, this.contentType);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof RCPResource)) {
            return false;
        }
        RCPResource other = (RCPResource)obj;
        return this.getPath().equals(other.getPath());
    }

    @Override
    public int hashCode() {
        return this.getPath().hashCode();
    }

    protected RCPFile getDocument() {
        RCPObject object = this.getRCPObject();
        if (object == null) {
            return null;
        }
        if (!(object instanceof RCPFile)) {
            return null;
        }
        return (RCPFile)object;
    }

    protected RCPFile getDocumentSafe() throws IOException {
        RCPFile document = this.getDocument();
        if (document == null) {
            throw new IOException(MessageFormat.format(THERE_IS_NO_RESOURCE_AT_PATH_0, this.getPath()));
        }
        return document;
    }

    public boolean isBinary() {
        return this.binary;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContent(byte[] content, boolean isBinary, String contentType) throws IOException {
        this.binary = isBinary;
        this.contentType = contentType;
        if (!isBinary) {
            this.setContent(content);
        }
        if (this.exists()) {
            RCPFile document = this.getDocumentSafe();
            try {
                document.setData(content);
            }
            catch (RCPBaseException ex) {
                throw new IOException(COULD_NOT_UPDATE_DOCUMENT, (Throwable)((Object)ex));
            }
        } else {
            this.getParent().createResource(this.getName(), content, this.binary, contentType);
        }
    }

    public List<IResourceVersion> getResourceVersions() throws IOException {
        return null;
    }

    public IResourceVersion getResourceVersion(int version) throws IOException {
        return null;
    }
}

