/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.bridge;

import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailSenderProvided {
    private static final String MAIL_SERVICE_IS_NOT_AVAILABLE = "Mail Service is not available";
    private Session session;
    private static final Logger logger = LoggerFactory.getLogger((String)MailSenderProvided.class.getCanonicalName());

    public MailSenderProvided(Session session) {
        this.session = session;
    }

    public String sendMail(String from, String to, String subject, String content, String subType) {
        try {
            Transport transport = this.session.getTransport();
            transport.connect();
            MimeMessage mimeMessage = MailSenderProvided.createMimeMessage(this.session, from, to, subject, content, subType);
            transport.sendMessage((Message)mimeMessage, mimeMessage.getAllRecipients());
            transport.close();
        }
        catch (Exception e) {
            logger.error(String.format("Exception occurred in class %s in method %s with message %s", this.getClass().getCanonicalName(), "#sendMail()", e.getMessage()));
            e.printStackTrace();
            return e.getMessage();
        }
        return "";
    }

    private static MimeMessage createMimeMessage(Session smtpSession, String from, String to, String subjectText, String mailText, String subType) throws MessagingException {
        MimeMessage mimeMessage = new MimeMessage(smtpSession);
        InternetAddress[] fromAddress = InternetAddress.parse((String)from);
        InternetAddress[] toAddresses = InternetAddress.parse((String)to);
        mimeMessage.setFrom((Address)fromAddress[0]);
        mimeMessage.setRecipients(MimeMessage.RecipientType.TO, (Address[])toAddresses);
        mimeMessage.setSubject(subjectText, "UTF-8");
        MimeMultipart multiPart = new MimeMultipart("alternative");
        MimeBodyPart part = new MimeBodyPart();
        part.setText(mailText, "utf-8", MailSenderProvided.getSubType(subType));
        multiPart.addBodyPart((BodyPart)part);
        mimeMessage.setContent((Multipart)multiPart);
        return mimeMessage;
    }

    private static String getSubType(String subType) {
        return subType != null ? subType : "plain";
    }
}

