/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.template.ui.common;

import com.google.gson.Gson;
import java.io.IOException;
import org.eclipse.dirigible.ide.repository.RepositoryFacade;
import org.eclipse.dirigible.ide.template.ui.common.TemplateMetadata;
import org.eclipse.dirigible.ide.template.ui.common.TemplateSourceMetadata;
import org.eclipse.dirigible.repository.api.ICollection;
import org.eclipse.dirigible.repository.api.IRepository;
import org.eclipse.dirigible.repository.api.IResource;

public class TemplateType {
    private static final String DOT = ".";
    private TemplateMetadata templateMetadata;
    private static Gson gson = new Gson();

    public static TemplateType createTemplateType(String category, String location, String type) throws IOException {
        return TemplateType.createTemplateType(category, location, type, null);
    }

    public static TemplateType createTemplateType(String category, String location, String type, IRepository repository) throws IOException {
        TemplateSourceMetadata[] sources;
        ICollection templateRoot;
        if (repository == null) {
            repository = RepositoryFacade.getInstance().getRepository();
        }
        if (!(templateRoot = repository.getCollection(location)).exists()) {
            throw new IOException(String.format("Template location: %s is not valid", location));
        }
        IResource templateMetadataResource = templateRoot.getResource("template.json");
        if (!templateMetadataResource.exists()) {
            throw new IOException(String.format("Template metadata does not exist at: %s", location));
        }
        TemplateMetadata templateMetadata = (TemplateMetadata)gson.fromJson(new String(templateMetadataResource.getContent()), TemplateMetadata.class);
        templateMetadata.setCategory(category);
        templateMetadata.setType(type);
        String image = templateRoot.getResource(templateMetadata.getImage()).getPath();
        templateMetadata.setImage(image);
        TemplateSourceMetadata[] templateSourceMetadataArray = sources = templateMetadata.getSources();
        int n = sources.length;
        int n2 = 0;
        while (n2 < n) {
            TemplateSourceMetadata source = templateSourceMetadataArray[n2];
            IResource contentResource = templateRoot.getResource(source.getName());
            if (!contentResource.exists()) {
                throw new IOException(String.format("Template source does not exist at: %s", contentResource.getPath()));
            }
            source.setLocation(contentResource.getPath());
            ++n2;
        }
        TemplateType templateType = new TemplateType(templateMetadata);
        return templateType;
    }

    private TemplateType(TemplateMetadata templateMetadata) {
        this.templateMetadata = templateMetadata;
    }

    public String getExtension() {
        return this.getExtensionFor(0);
    }

    public String getExtensionFor(int i) {
        int dotIndex = this.templateMetadata.getSources()[i].getLocation().lastIndexOf(DOT);
        if (dotIndex != -1) {
            return this.templateMetadata.getSources()[i].getLocation().substring(dotIndex + 1);
        }
        return "";
    }

    public String getLocation() {
        return this.templateMetadata.getSources()[0].getLocation();
    }

    public TemplateMetadata getTemplateMetadata() {
        return this.templateMetadata;
    }
}

