/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dartboard.stagehand;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.Platform;
import org.eclipse.dartboard.stagehand.StagehandTemplate;
import org.eclipse.dartboard.util.PubUtil;
import org.eclipse.dartboard.util.StatusUtil;

public class StagehandService {
    private static final ILog LOG = Platform.getLog(StagehandService.class);
    private static List<StagehandTemplate> stagehandTemplates;
    private static final int STAGEHAND_ACTIVATE_TIMEOUT = 30;

    public static List<StagehandTemplate> getStagehandTemplates() {
        if (stagehandTemplates != null) {
            return stagehandTemplates;
        }
        StagehandService.activateStagehand();
        ProcessBuilder builder = PubUtil.getPubProcessBuilder("global", "run", "stagehand", "--machine");
        try {
            InputStreamReader reader = new InputStreamReader(builder.start().getInputStream(), Charset.defaultCharset());
            Gson gson = new Gson();
            Object[] templates = (StagehandTemplate[])gson.fromJson((Reader)reader, StagehandTemplate[].class);
            stagehandTemplates = Lists.newArrayList((Object[])templates);
            stagehandTemplates.sort((first, second) -> first.getDisplayName().compareToIgnoreCase(second.getDisplayName()));
        }
        catch (IOException e) {
            LOG.log(StatusUtil.createError("Could not fetch stagehand template list", e));
        }
        return stagehandTemplates;
    }

    public static void activateStagehand() {
        ProcessBuilder builder = PubUtil.getPubProcessBuilder("global", "activate", "stagehand");
        try {
            builder.start().waitFor(30L, TimeUnit.SECONDS);
        }
        catch (IOException | InterruptedException e) {
            LOG.log(StatusUtil.createError("Could not activate stagehand globally", e));
        }
    }
}

