/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dartboard.stagehand;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.input.NullInputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.dartboard.Messages;
import org.eclipse.dartboard.stagehand.StagehandTemplate;
import org.eclipse.dartboard.util.PlatformUIUtil;
import org.eclipse.dartboard.util.PubUtil;
import org.eclipse.dartboard.util.StatusUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class StagehandGenerator {
    private static final ILog LOG = Platform.getLog(StagehandGenerator.class);

    public static void generate(StagehandTemplate generator, final IProject project) {
        if (project == null) {
            throw new IllegalArgumentException("The project can't be null");
        }
        if (generator == null) {
            IFile pubspecFile = project.getFile("pubspec.yaml");
            if (!pubspecFile.exists()) {
                try {
                    pubspecFile.create((InputStream)new NullInputStream(0L), true, null);
                }
                catch (CoreException e) {
                    LOG.log(StatusUtil.createError("Could not create pubspec.yaml file", e));
                }
            }
        } else {
            Job stagehandJob = Job.create((String)NLS.bind((String)Messages.Stagehand_GeneratorJob_Name, (Object)generator.getName(), (Object)project.getName()), monitor -> {
                ProcessBuilder builder = PubUtil.getPubProcessBuilder("global", "run", "stagehand", generator.getName()).directory(project.getLocation().toFile());
                try {
                    Process process = builder.start();
                    int exit = process.waitFor();
                    if (exit != 0) {
                        Display.getDefault().asyncExec(() -> MessageDialog.openError((Shell)PlatformUIUtil.getActiveShell(), (String)Messages.Stagehand_GeneratorJobFail_Title, (String)NLS.bind((String)Messages.Stagehand_GeneratorJobFail_Title, (Object)generator.getName(), (Object)project.getLocation())));
                    }
                }
                catch (IOException | InterruptedException e) {
                    LOG.log(StatusUtil.createError("Could not generate stagehand template", e));
                }
            });
            stagehandJob.schedule();
            stagehandJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    try {
                        project.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (CoreException e) {
                        LOG.log(StatusUtil.createError("Could not refresh project", e));
                    }
                }
            });
        }
    }
}

