/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.behavior.validation;

import org.eclipse.comma.actions.actions.ActionList;
import org.eclipse.comma.behavior.behavior.BehaviorPackage;
import org.eclipse.comma.behavior.behavior.Clause;
import org.eclipse.comma.behavior.behavior.State;
import org.eclipse.comma.behavior.behavior.Transition;
import org.eclipse.comma.behavior.behavior.TriggeredTransition;
import org.eclipse.comma.behavior.utilities.TransitionComparator;
import org.eclipse.comma.behavior.validation.AbstractBehaviorValidator;
import org.eclipse.comma.expressions.expression.Expression;
import org.eclipse.comma.expressions.expression.Variable;
import org.eclipse.comma.signature.interfaceSignature.InterfaceEvent;
import org.eclipse.comma.signature.interfaceSignature.Parameter;
import org.eclipse.comma.types.types.Type;
import org.eclipse.comma.types.types.TypeObject;
import org.eclipse.comma.types.utilities.TypeUtilities;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.xbase.lib.ExclusiveRange;

public class TransitionsValidator
extends AbstractBehaviorValidator {
    public static final String CLAUSE_MISSING_NEXT_STATE = "statemachine_missing_next_state";

    public Object register(AbstractBehaviorValidator registrar) {
        return null;
    }

    @Check
    public void checkMissingNextState(Clause c) {
        if (c.getTarget() != null || !(c.eContainer().eContainer() instanceof State)) {
            return;
        }
        String sourceText = NodeModelUtils.getNode((EObject)c).getText();
        boolean _contains = sourceText.contains("next state");
        if (_contains) {
            this.error("Missing next state", (EStructuralFeature)BehaviorPackage.Literals.CLAUSE__TARGET, CLAUSE_MISSING_NEXT_STATE, null);
        } else {
            boolean _tripleNotEquals;
            ActionList _actions = c.getActions();
            boolean bl = _tripleNotEquals = _actions != null;
            if (_tripleNotEquals) {
                EObject _eContainer = c.eContainer();
                this.error("Missing next state", c.eContainer(), (EStructuralFeature)BehaviorPackage.Literals.TRANSITION__CLAUSES, ((Transition)_eContainer).getClauses().indexOf((Object)c), CLAUSE_MISSING_NEXT_STATE, null);
            } else {
                EObject _eContainer_1 = c.eContainer().eContainer();
                State state = (State)_eContainer_1;
                this.error("Transition clause missing next state", (EObject)state, (EStructuralFeature)BehaviorPackage.Literals.STATE__TRANSITIONS, state.getTransitions().indexOf((Object)c.eContainer()), CLAUSE_MISSING_NEXT_STATE, null);
            }
        }
    }

    @Check
    public void checkTriggerSignature(TriggeredTransition t) {
        int _size_1;
        boolean _notEquals;
        boolean _tripleEquals;
        InterfaceEvent _trigger = t.getTrigger();
        boolean bl = _tripleEquals = _trigger == null;
        if (_tripleEquals) {
            return;
        }
        int _size = t.getParameters().size();
        boolean bl2 = _notEquals = _size != (_size_1 = t.getTrigger().getParameters().size());
        if (_notEquals) {
            this.error("Wrong number of parameters in the trigger.", (EStructuralFeature)BehaviorPackage.Literals.TRIGGERED_TRANSITION__TRIGGER);
            return;
        }
        EList<Variable> _parameters = t.getParameters();
        for (Variable p : _parameters) {
            boolean _not;
            boolean _identical = this.identical(TypeUtilities.getTypeObject((Type)p.getType()), TypeUtilities.getTypeObject((Type)((Parameter)t.getTrigger().getParameters().get(t.getParameters().indexOf((Object)p))).getType()));
            boolean bl3 = _not = !_identical;
            if (!_not) continue;
            this.error("The type of parameter does not match the type in the trigger signature.", (EStructuralFeature)BehaviorPackage.Literals.TRIGGERED_TRANSITION__PARAMETERS, t.getParameters().indexOf((Object)p));
        }
    }

    @Check
    public void checkForDuplicatedParameterName(TriggeredTransition t) {
        this.checkForNameDuplications((Iterable)t.getParameters(), "parameter", null, new String[0]);
    }

    @Check
    public void typeCheckTransitionGuard(Transition t) {
        boolean _tripleNotEquals;
        Expression _guard = t.getGuard();
        boolean bl = _tripleNotEquals = _guard != null;
        if (_tripleNotEquals) {
            boolean _not;
            boolean _identical = this.identical(this.typeOf(t.getGuard()), (TypeObject)this.boolType);
            boolean bl2 = _not = !_identical;
            if (_not) {
                this.error("Guard expression has to be of type boolean.", (EStructuralFeature)BehaviorPackage.Literals.TRANSITION__GUARD);
            }
        }
    }

    @Check
    public void checkDuplicateClauses(Transition t) {
        TransitionComparator comparator = new TransitionComparator();
        int _size = t.getClauses().size();
        ExclusiveRange _doubleDotLessThan = new ExclusiveRange(0, _size, true);
        for (Integer i : _doubleDotLessThan) {
            int _size_1 = t.getClauses().size();
            ExclusiveRange _doubleDotLessThan_1 = new ExclusiveRange(i + 1, _size_1, true);
            for (Integer j : _doubleDotLessThan_1) {
                boolean _sameAs = comparator.sameAs((EObject)t.getClauses().get(i.intValue()), (EObject)t.getClauses().get(j.intValue()));
                if (!_sameAs) continue;
                this.warning("Duplicate clause", (EStructuralFeature)BehaviorPackage.Literals.TRANSITION__CLAUSES, j);
            }
        }
    }
}

