/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.m2doc.element.impl;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import org.eclipse.emf.common.util.URI;
import org.obeonetwork.m2doc.element.MImage;
import org.obeonetwork.m2doc.element.PictureType;

public class MImageAWTImpl
implements MImage {
    private final BufferedImage image;
    private final URI uri;
    private int width;
    private int height;
    private boolean conserveRatio;
    private double ratio;

    public MImageAWTImpl(BufferedImage image, URI uri) {
        this.image = image;
        this.uri = uri;
        this.width = image.getWidth();
        this.height = image.getHeight();
        this.conserveRatio = true;
        this.ratio = (double)this.width / (double)this.height;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public void setWidth(int width) {
        this.width = width;
        if (this.conserveRatio) {
            this.height = (int)(1.0 / this.ratio * (double)width);
        }
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public void setHeight(int height) {
        this.height = height;
        if (this.conserveRatio) {
            this.width = (int)(this.ratio * (double)height);
        }
    }

    @Override
    public boolean conserveRatio() {
        return this.conserveRatio;
    }

    @Override
    public void setConserveRatio(boolean conserveRatio) {
        if (conserveRatio && this.ratio < 0.0) {
            throw new IllegalStateException("Can't conserve ratio: unknown ratio");
        }
        this.conserveRatio = conserveRatio;
    }

    protected double getRatio() {
        return this.ratio;
    }

    @Override
    public URI getURI() {
        return this.uri;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (ByteArrayOutputStream output = new ByteArrayOutputStream();){
            ImageIO.write((RenderedImage)this.image, "png", output);
            return new ByteArrayInputStream(output.toByteArray());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public PictureType getType() {
        return PictureType.PNG;
    }

    public String toString() {
        return "Image " + this.uri.toString();
    }

    public static BufferedImage getBufferedImage(MImage image) throws IOException {
        BufferedImage res;
        if (image instanceof MImageAWTImpl) {
            res = ((MImageAWTImpl)image).image;
        } else {
            Throwable throwable = null;
            Object var3_4 = null;
            try (InputStream input = image.getInputStream();){
                res = ImageIO.read(input);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        return res;
    }
}

