/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.monitoring.lib.utils;

import java.io.FileWriter;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.stream.Collectors;
import org.eclipse.comma.monitoring.lib.messages.CObservedMessage;

public class CTraceSerializer {
    private Queue<CObservedMessage> latestTrace = new LinkedList<CObservedMessage>();
    private static final int latestTraceMaxSize = 10;
    private String fileName;

    public CTraceSerializer(String fileName) {
        this.fileName = fileName;
    }

    public void processEvent(CObservedMessage message) throws Exception {
        if (this.latestTrace.size() == 10) {
            this.latestTrace.remove();
        }
        this.latestTrace.add(message);
        try {
            FileWriter writer = new FileWriter(this.fileName, true);
            writer.write(message.toString());
            writer.write("\r\n");
            writer.close();
        }
        catch (IOException e) {
            throw new Exception("Cannot serialize event. Possible cause: event from undeclared connection");
        }
    }

    public List<CObservedMessage> getLatestTrace() {
        return this.latestTrace.stream().collect(Collectors.toList());
    }
}

