/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.runtime;

import java.util.Collection;
import org.eclipse.core.internal.runtime.AdapterManager;
import org.eclipse.core.internal.runtime.IAdapterFactoryExt;
import org.eclipse.core.runtime.IAdapterFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class AdapterFactoryBridge
implements ServiceTrackerCustomizer<IAdapterFactory, LazyAdapterFactory> {
    private BundleContext bundleContext;

    public AdapterFactoryBridge(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public LazyAdapterFactory addingService(ServiceReference<IAdapterFactory> reference) {
        String[] adaptableClasses = AdapterFactoryBridge.getMultiProperty(reference, "adaptableClass");
        String[] adapterNames = AdapterFactoryBridge.getMultiProperty(reference, "adapterNames");
        LazyAdapterFactory proxy = adapterNames.length == 0 && reference.getProperty("adapterNames") == null ? new LazyAdapterFactory(reference, this.bundleContext) : new LazyAdapterFactoryExtServiceProxy(adapterNames, reference, this.bundleContext);
        AdapterManager manager = AdapterManager.getDefault();
        String[] stringArray = adaptableClasses;
        int n = adaptableClasses.length;
        int n2 = 0;
        while (n2 < n) {
            String adaptableClass = stringArray[n2];
            manager.registerFactory(proxy, adaptableClass);
            ++n2;
        }
        manager.flushLookup();
        return proxy;
    }

    private static String[] getMultiProperty(ServiceReference<?> reference, String propertyName) {
        Object property = reference.getProperty(propertyName);
        if (property instanceof String) {
            String string = (String)property;
            if (string.length() > 0) {
                return new String[]{string};
            }
        } else {
            if (property instanceof String[]) {
                return (String[])property;
            }
            if (property instanceof Collection) {
                Collection collection = (Collection)property;
                return (String[])collection.stream().filter(String.class::isInstance).map(String.class::cast).toArray(String[]::new);
            }
        }
        return new String[0];
    }

    public void modifiedService(ServiceReference<IAdapterFactory> reference, LazyAdapterFactory proxy) {
        String[] adaptableClasses = AdapterFactoryBridge.getMultiProperty(reference, "adaptableClass");
        AdapterManager manager = AdapterManager.getDefault();
        manager.unregisterAdapters(proxy);
        if (proxy instanceof LazyAdapterFactoryExtServiceProxy) {
            LazyAdapterFactoryExtServiceProxy lazy = (LazyAdapterFactoryExtServiceProxy)proxy;
            lazy.adapterNames = AdapterFactoryBridge.getMultiProperty(reference, "adapterNames");
        }
        String[] stringArray = adaptableClasses;
        int n = adaptableClasses.length;
        int n2 = 0;
        while (n2 < n) {
            String adaptableClass = stringArray[n2];
            manager.registerFactory(proxy, adaptableClass);
            ++n2;
        }
        manager.flushLookup();
    }

    public void removedService(ServiceReference<IAdapterFactory> reference, LazyAdapterFactory proxy) {
        AdapterManager manager = AdapterManager.getDefault();
        manager.unregisterAdapters(proxy);
        proxy.dispose();
    }

    public static class LazyAdapterFactory
    implements IAdapterFactory {
        IAdapterFactory service;
        volatile boolean disposed;
        private final ServiceReference<IAdapterFactory> reference;
        private final BundleContext bundleContext;

        LazyAdapterFactory(ServiceReference<IAdapterFactory> reference, BundleContext bundleContext) {
            this.reference = reference;
            this.bundleContext = bundleContext;
        }

        @Override
        public <T> T getAdapter(Object adaptableObject, Class<T> adapterType) {
            IAdapterFactory factory;
            if (!this.disposed && (factory = this.getFactoryService()) != null) {
                return factory.getAdapter(adaptableObject, adapterType);
            }
            return null;
        }

        @Override
        public Class<?>[] getAdapterList() {
            IAdapterFactory factory;
            if (!this.disposed && (factory = this.getFactoryService()) != null) {
                return factory.getAdapterList();
            }
            return new Class[0];
        }

        synchronized IAdapterFactory getFactoryService() {
            if (this.service == null && !this.disposed) {
                this.service = (IAdapterFactory)this.bundleContext.getService(this.reference);
            }
            return this.service;
        }

        synchronized void dispose() {
            this.disposed = true;
            if (this.service != null) {
                this.service = null;
                this.bundleContext.ungetService(this.reference);
            }
        }
    }

    private static final class LazyAdapterFactoryExtServiceProxy
    extends LazyAdapterFactory
    implements IAdapterFactoryExt {
        volatile String[] adapterNames;

        LazyAdapterFactoryExtServiceProxy(String[] adapterNames, ServiceReference<IAdapterFactory> reference, BundleContext bundleContext) {
            super(reference, bundleContext);
            this.adapterNames = adapterNames;
        }

        @Override
        public synchronized IAdapterFactory loadFactory(boolean force) {
            if (force) {
                return this.getFactoryService();
            }
            return this.service;
        }

        @Override
        public String[] getAdapterNames() {
            return (String[])this.adapterNames.clone();
        }
    }
}

