/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.problems;

import java.text.ChoiceFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.resources.IMarker;
import org.eclipse.pde.api.tools.internal.builder.BuilderMessages;
import org.eclipse.pde.api.tools.internal.problems.ApiProblem;
import org.eclipse.pde.api.tools.internal.problems.ApiProblemFilter;
import org.eclipse.pde.api.tools.internal.provisional.problems.IApiProblem;
import org.eclipse.pde.api.tools.internal.provisional.problems.IApiProblemFilter;
import org.eclipse.pde.api.tools.internal.util.Util;

public class ApiProblemFactory {
    public static final int TYPE_CONVERSION_ID = 76;
    private static Hashtable<Comparable<? extends Object>, String> fMessages = null;

    public static IApiProblemFilter newProblemFilter(String componentid, IApiProblem problem, String comment) {
        return new ApiProblemFilter(componentid, problem, comment);
    }

    public static int getProblemHashcode(String filterhandle) {
        if (filterhandle != null) {
            String[] args = filterhandle.split("%]");
            int hashcode = 0;
            try {
                hashcode += Integer.parseInt(args[0]);
                hashcode += args[1].hashCode();
                if (args[2] != null && !args[2].equalsIgnoreCase("null")) {
                    hashcode += args[2].hashCode();
                }
                Object[] margs = ApiProblemFactory.splitHandle(args[3], ",");
                hashcode += Arrays.hashCode(margs);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return hashcode;
        }
        return -1;
    }

    private static String[] splitHandle(String messageArguments, String delimiter) {
        ArrayList<String> matches = null;
        char[] argumentsChars = messageArguments.toCharArray();
        char[] delimiterChars = delimiter.toCharArray();
        int delimiterLength = delimiterChars.length;
        int start = 0;
        int argumentsCharsLength = argumentsChars.length;
        int balance = 0;
        int i = 0;
        while (i < argumentsCharsLength) {
            char c = argumentsChars[i];
            switch (c) {
                case '(': {
                    ++balance;
                    break;
                }
                case ')': {
                    --balance;
                    break;
                }
            }
            if (c == delimiterChars[0] && balance == 0) {
                if (i + delimiterLength < argumentsCharsLength) {
                    boolean match = true;
                    int j = 1;
                    while (j < delimiterLength) {
                        if (argumentsChars[i + j] != delimiterChars[j]) {
                            match = false;
                            break;
                        }
                        ++j;
                    }
                    if (match) {
                        if (matches == null) {
                            matches = new ArrayList<String>();
                        }
                        matches.add(messageArguments.substring(start, i));
                        start = i + delimiterLength;
                        i += delimiterLength;
                        continue;
                    }
                    ++i;
                    continue;
                }
                ++i;
                continue;
            }
            ++i;
        }
        if (matches == null) {
            return new String[]{messageArguments};
        }
        matches.add(messageArguments.substring(start, argumentsCharsLength));
        return matches.toArray(new String[matches.size()]);
    }

    public static IApiProblem newApiProblem(String resourcepath, String typeName, String[] messageargs, String[] argumentids, Object[] arguments, int linenumber, int charstart, int charend, int category, int element, int kind, int flags) {
        return ApiProblemFactory.newApiProblem(resourcepath, typeName, messageargs, argumentids, arguments, linenumber, charstart, charend, ApiProblemFactory.createProblemId(category, element, kind, flags));
    }

    public static IApiProblem newApiProblem(String resourcepath, String typeName, String[] messageargs, String[] argumentids, Object[] arguments, int linenumber, int charstart, int charend, int id) {
        return new ApiProblem(resourcepath, typeName, messageargs, argumentids, arguments, linenumber, charstart, charend, id);
    }

    public static IApiProblem newApiUsageProblem(String resourcepath, String typeName, String[] messageargs, String[] argumentids, Object[] arguments, int linenumber, int charstart, int charend, int element, int kind) {
        int id = ApiProblemFactory.createProblemId(0x20000000, element, kind, 0);
        return ApiProblemFactory.newApiProblem(resourcepath, typeName, messageargs, argumentids, arguments, linenumber, charstart, charend, id);
    }

    public static IApiProblem newApiUsageProblem(String resourcepath, String typeName, String[] messageargs, String[] argumentids, Object[] arguments, int linenumber, int charstart, int charend, int element, int kind, int flags) {
        int id = ApiProblemFactory.createProblemId(0x20000000, element, kind, flags);
        return ApiProblemFactory.newApiProblem(resourcepath, typeName, messageargs, argumentids, arguments, linenumber, charstart, charend, id);
    }

    public static IApiProblem newApiBaselineProblem(String resourcepath, String[] argumentids, Object[] arguments, int element, int kind) {
        int id = ApiProblemFactory.createProblemId(0x50000000, element, kind, 0);
        return ApiProblemFactory.newApiProblem(resourcepath, null, null, argumentids, arguments, -1, -1, -1, id);
    }

    public static IApiProblem newApiComponentResolutionProblem(String resourcepath, String[] messageargs, String[] argumentids, Object[] arguments, int element, int kind) {
        int id = ApiProblemFactory.createProblemId(0x60000000, element, kind, 0);
        return ApiProblemFactory.newApiProblem(resourcepath, null, messageargs, argumentids, arguments, -1, -1, -1, id);
    }

    public static IApiProblem newFatalProblem(String resourcepath, String[] messageargs, int kind) {
        int id = ApiProblemFactory.createProblemId(0x70000000, 7, kind, 0);
        return ApiProblemFactory.newApiProblem(resourcepath, null, messageargs, null, null, -1, -1, -1, id);
    }

    public static IApiProblem newApiSinceTagProblem(String resourcepath, String typeName, String[] messageargs, String[] argumentids, Object[] arguments, int linenumber, int charstart, int charend, int element, int kind) {
        int id = ApiProblemFactory.createProblemId(0x40000000, element, kind, 0);
        return ApiProblemFactory.newApiProblem(resourcepath, typeName, messageargs, argumentids, arguments, linenumber, charstart, charend, id);
    }

    public static IApiProblem newApiVersionNumberProblem(String resourcepath, String typeName, String[] messageargs, String[] argumentids, Object[] arguments, int linenumber, int charstart, int charend, int element, int kind) {
        int id = ApiProblemFactory.createProblemId(0x30000000, element, kind, 0);
        return ApiProblemFactory.newApiProblem(resourcepath, typeName, messageargs, argumentids, arguments, linenumber, charstart, charend, id);
    }

    public static IApiProblem newApiUseScanProblem(String resourcePath, String typeName, String[] messageargs, String[] argumentids, Object[] arguments, int linenumber, int charstart, int charend, int element, int kind, int flags) {
        int id = ApiProblemFactory.createProblemId(Integer.MIN_VALUE, element, kind, flags);
        return ApiProblemFactory.newApiProblem(resourcePath, typeName, messageargs, argumentids, arguments, linenumber, charstart, charend, id);
    }

    public static String getLocalizedMessage(IApiProblem problem) {
        return ApiProblemFactory.getLocalizedMessage(problem.getMessageid(), problem.getMessageArguments());
    }

    public static String getLocalizedMessage(int messageid, String[] messageargs) {
        String pattern;
        if (fMessages == null) {
            fMessages = ApiProblemFactory.loadMessageTemplates(Locale.getDefault());
        }
        if ((pattern = fMessages.get(messageid)) == null) {
            return MessageFormat.format(BuilderMessages.ApiProblemFactory_problem_message_not_found, Integer.toString(messageid));
        }
        if (messageid == 76) {
            MessageFormat messageFormat = new MessageFormat(pattern);
            double[] typeElementTypes = new double[]{1.0, 4.0, 6.0, 8.0};
            String[] typeElementTypesStrings = new String[]{fMessages.get(Util.getDeltaElementType(1)), fMessages.get(Util.getDeltaElementType(4)), fMessages.get(Util.getDeltaElementType(6)), fMessages.get(Util.getDeltaElementType(8))};
            ChoiceFormat choiceFormat = new ChoiceFormat(typeElementTypes, typeElementTypesStrings);
            messageFormat.setFormatByArgumentIndex(1, choiceFormat);
            messageFormat.setFormatByArgumentIndex(2, choiceFormat);
            Object[] args = new Object[messageargs.length];
            args[0] = messageargs[0];
            args[1] = Integer.decode(messageargs[1]);
            args[2] = Integer.decode(messageargs[2]);
            return messageFormat.format(args);
        }
        return MessageFormat.format(pattern, messageargs);
    }

    public static Hashtable<Comparable<? extends Object>, String> loadMessageTemplates(Locale loc) {
        ResourceBundle bundle = null;
        String bundleName = "org.eclipse.pde.api.tools.internal.problems.problemmessages";
        try {
            bundle = ResourceBundle.getBundle(bundleName, loc);
        }
        catch (MissingResourceException e) {
            System.out.println("Missing resource : " + bundleName.replace('.', '/') + ".properties for locale " + String.valueOf(loc));
            throw e;
        }
        Hashtable<Comparable<? extends Object>, String> templates = new Hashtable<Comparable<? extends Object>, String>(700);
        Enumeration<String> keys = bundle.getKeys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            try {
                int messageID = Integer.parseInt(key);
                templates.put((Comparable<? extends Object>)messageID, bundle.getString(key));
            }
            catch (NumberFormatException e) {
                templates.put((Comparable<? extends Object>)((Object)key), bundle.getString(key));
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return templates;
    }

    public static int createProblemId(int category, int element, int kind, int flags) {
        return category | element << 24 | kind << 20 | flags << 12 | ApiProblemFactory.getProblemMessageId(category, element, kind, flags);
    }

    public static int getProblemId(IMarker marker) {
        if (marker != null) {
            return marker.getAttribute("problemid", -1);
        }
        return -1;
    }

    public static int getProblemKind(int problemid) {
        return (problemid & 0xF00000) >> 20;
    }

    public static int getProblemElementKind(int problemid) {
        return (problemid & 0xF000000) >> 24;
    }

    public static int getProblemFlags(int problemid) {
        return (problemid & 0xFF000) >> 12;
    }

    public static int getProblemCategory(int problemid) {
        return problemid & 0xF0000000;
    }

    public static int getProblemMessageId(int problemid) {
        return ApiProblemFactory.getProblemMessageId(ApiProblemFactory.getProblemCategory(problemid), ApiProblemFactory.getProblemElementKind(problemid), ApiProblemFactory.getProblemKind(problemid), ApiProblemFactory.getProblemFlags(problemid));
    }

    public static int getProblemMessageId(int category, int element, int kind, int flags) {
        block0 : switch (category) {
            case 0x50000000: {
                switch (kind) {
                    case 1: {
                        return 1;
                    }
                    case 2: {
                        return 57;
                    }
                    case 3: {
                        return 60;
                    }
                }
                break;
            }
            case 0x40000000: {
                switch (kind) {
                    case 1: {
                        return 2;
                    }
                    case 2: {
                        return 3;
                    }
                    case 3: {
                        return 4;
                    }
                }
                break;
            }
            case 0x30000000: {
                switch (kind) {
                    case 1: {
                        return 5;
                    }
                    case 3: {
                        return 6;
                    }
                    case 2: {
                        return 7;
                    }
                    case 4: {
                        return 56;
                    }
                    case 5: {
                        return 19;
                    }
                    case 10: {
                        return 62;
                    }
                    case 6: {
                        return 20;
                    }
                    case 7: {
                        return 43;
                    }
                    case 8: {
                        return 58;
                    }
                    case 9: {
                        return 59;
                    }
                    case 11: {
                        return 65;
                    }
                    case 12: {
                        return 63;
                    }
                }
                break;
            }
            case 0x20000000: {
                switch (kind) {
                    case 4: {
                        switch (flags) {
                            case 0: {
                                return 8;
                            }
                            case 12: {
                                return 24;
                            }
                            case 10: {
                                return 18;
                            }
                            case 13: {
                                return 37;
                            }
                            case 11: {
                                return 27;
                            }
                        }
                        break block0;
                    }
                    case 1: {
                        switch (flags) {
                            case 0: {
                                return 9;
                            }
                            case 10: {
                                return 25;
                            }
                            case 11: {
                                return 28;
                            }
                        }
                        break block0;
                    }
                    case 2: {
                        return 10;
                    }
                    case 5: {
                        return 11;
                    }
                    case 3: {
                        switch (flags) {
                            case 9: {
                                return 12;
                            }
                            case 7: {
                                return 110;
                            }
                            case 8: {
                                return 111;
                            }
                            case 14: {
                                return 42;
                            }
                        }
                        break block0;
                    }
                    case 6: {
                        switch (flags) {
                            case 1: {
                                return 13;
                            }
                            case 15: {
                                return 48;
                            }
                            case 16: {
                                return 50;
                            }
                            case 2: {
                                return 14;
                            }
                            case 3: {
                                return 15;
                            }
                            case 4: {
                                return 16;
                            }
                            case 5: {
                                return 17;
                            }
                            case 6: {
                                return 109;
                            }
                        }
                        break block0;
                    }
                    case 7: {
                        return 112;
                    }
                    case 8: {
                        return 22;
                    }
                    case 12: {
                        return 45;
                    }
                    case 13: {
                        return 46;
                    }
                    case 9: {
                        switch (flags) {
                            case 8: {
                                return 33;
                            }
                            case 7: {
                                return 34;
                            }
                            case 9: {
                                return 35;
                            }
                        }
                        return 36;
                    }
                    case 10: {
                        return 30;
                    }
                }
                break;
            }
            case 0x10000000: {
                switch (kind) {
                    case 1: {
                        switch (element) {
                            case 4: {
                                switch (flags) {
                                    case 16: {
                                        return 49;
                                    }
                                    case 25: {
                                        return 41;
                                    }
                                    case 37: {
                                        return 72;
                                    }
                                }
                                break;
                            }
                            case 1: {
                                switch (flags) {
                                    case 16: {
                                        return 39;
                                    }
                                }
                                break;
                            }
                            case 8: {
                                switch (flags) {
                                    case 16: {
                                        return 40;
                                    }
                                    case 25: {
                                        return 44;
                                    }
                                    case 73: 
                                    case 74: {
                                        return 47;
                                    }
                                    case 37: {
                                        return 72;
                                    }
                                    case 69: {
                                        return 133;
                                    }
                                }
                                break;
                            }
                            case 9: {
                                switch (flags) {
                                    case 37: {
                                        return 132;
                                    }
                                }
                                break;
                            }
                        }
                        switch (flags) {
                            case 6: {
                                return 21;
                            }
                            case 8: {
                                return 23;
                            }
                            case 23: {
                                return 26;
                            }
                            case 28: {
                                return 29;
                            }
                            case 49: {
                                return 32;
                            }
                            case 68: {
                                return 106;
                            }
                            case 42: {
                                return 51;
                            }
                            case 43: {
                                return 53;
                            }
                        }
                        break block0;
                    }
                    case 2: {
                        switch (element) {
                            case 7: {
                                switch (flags) {
                                    case 46: {
                                        return 81;
                                    }
                                    case 54: {
                                        return 84;
                                    }
                                    case 11: {
                                        return 114;
                                    }
                                    case 31: {
                                        return 118;
                                    }
                                    case 38: {
                                        return 121;
                                    }
                                    case 33: {
                                        return 69;
                                    }
                                }
                                break;
                            }
                            case 9: {
                                switch (flags) {
                                    case 11: {
                                        return 115;
                                    }
                                    case 30: {
                                        return 117;
                                    }
                                    case 31: {
                                        return 119;
                                    }
                                    case 33: {
                                        return 120;
                                    }
                                    case 38: {
                                        return 122;
                                    }
                                }
                                break;
                            }
                            case 5: {
                                switch (flags) {
                                    case 11: {
                                        return 116;
                                    }
                                }
                                break;
                            }
                        }
                        switch (flags) {
                            case 6: {
                                return 52;
                            }
                            case 10: {
                                return 54;
                            }
                            case 11: {
                                return 55;
                            }
                            case 20: {
                                return 61;
                            }
                            case 23: {
                                return 64;
                            }
                            case 30: {
                                return 66;
                            }
                            case 31: {
                                return 67;
                            }
                            case 33: {
                                return 123;
                            }
                            case 38: {
                                return 73;
                            }
                            case 41: {
                                return 76;
                            }
                            case 55: {
                                return 85;
                            }
                            case 68: {
                                return 124;
                            }
                            case 42: {
                                return 51;
                            }
                        }
                        break block0;
                    }
                    case 3: {
                        switch (flags) {
                            case 2: {
                                return 86;
                            }
                            case 3: {
                                return 87;
                            }
                            case 6: {
                                return 89;
                            }
                            case 8: {
                                return 91;
                            }
                            case 12: {
                                return 92;
                            }
                            case 16: {
                                return 94;
                            }
                            case 23: {
                                return 96;
                            }
                            case 25: {
                                return 98;
                            }
                            case 27: {
                                return 100;
                            }
                            case 28: {
                                return 101;
                            }
                            case 46: {
                                return 102;
                            }
                            case 47: {
                                return 103;
                            }
                            case 48: {
                                return 104;
                            }
                            case 49: {
                                return 105;
                            }
                            case 54: {
                                return 108;
                            }
                            case 56: {
                                return 113;
                            }
                            case 61: {
                                return 125;
                            }
                            case 62: {
                                return 126;
                            }
                            case 63: {
                                return 127;
                            }
                            case 64: {
                                return 128;
                            }
                            case 65: {
                                return 129;
                            }
                            case 66: {
                                return 130;
                            }
                            case 68: {
                                return 107;
                            }
                            case 39: {
                                return 131;
                            }
                            case 71: {
                                return 134;
                            }
                            case 70: {
                                return 135;
                            }
                        }
                        break block0;
                    }
                }
                break;
            }
            case 0x60000000: {
                switch (kind) {
                    case 1: {
                        return 99;
                    }
                }
                break;
            }
            case 0x70000000: {
                switch (kind) {
                    case 1: {
                        return 31;
                    }
                }
                break;
            }
            case -2147483648: {
                switch (kind) {
                    case 1: {
                        return 136 + flags;
                    }
                    case 2: {
                        return 138 + flags;
                    }
                    case 3: {
                        return 140 + flags;
                    }
                }
                break;
            }
        }
        return 0;
    }

    public static String getProblemSeverityId(IApiProblem problem) {
        block0 : switch (problem.getCategory()) {
            case 0x70000000: {
                switch (problem.getKind()) {
                    case 1: {
                        return "fatal_problems";
                    }
                }
                break;
            }
            case 0x60000000: {
                switch (problem.getKind()) {
                    case 1: {
                        return "report_resolution_errors_api_component";
                    }
                }
                break;
            }
            case 0x50000000: {
                switch (problem.getKind()) {
                    case 1: 
                    case 2: {
                        return "missing_default_api_profile";
                    }
                    case 3: {
                        return "missing_plugin_in_baseline";
                    }
                }
                break;
            }
            case 0x40000000: {
                switch (problem.getKind()) {
                    case 1: {
                        return "invalid_since_tag_version";
                    }
                    case 2: {
                        return "malformed_since_tag";
                    }
                    case 3: {
                        return "missing_since_tag";
                    }
                }
                break;
            }
            case 0x30000000: {
                switch (problem.getKind()) {
                    case 4: 
                    case 8: 
                    case 9: {
                        return "incompatible_api_component_version_report_minor_without_api_change";
                    }
                    case 3: {
                        return "incompatible_api_component_version_report_major_without_breaking_change";
                    }
                    case 7: {
                        return "changed_execution_env";
                    }
                }
                return "incompatible_api_component_version";
            }
            case 0x20000000: {
                switch (problem.getKind()) {
                    case 4: {
                        return "ILLEGAL_IMPLEMENT";
                    }
                    case 1: {
                        return "ILLEGAL_EXTEND";
                    }
                    case 2: {
                        return "ILLEGAL_INSTANTIATE";
                    }
                    case 5: {
                        return "ILLEGAL_OVERRIDE";
                    }
                    case 3: {
                        return "ILLEGAL_REFERENCE";
                    }
                    case 6: {
                        switch (problem.getFlags()) {
                            case 1: 
                            case 15: 
                            case 16: {
                                return "LEAK_EXTEND";
                            }
                            case 3: {
                                return "LEAK_FIELD_DECL";
                            }
                            case 2: {
                                return "LEAK_IMPLEMENT";
                            }
                            case 5: 
                            case 6: {
                                return "LEAK_METHOD_PARAM";
                            }
                            case 4: {
                                return "LEAK_METHOD_RETURN_TYPE";
                            }
                        }
                        break block0;
                    }
                    case 7: {
                        return "INVALID_JAVADOC_TAG";
                    }
                    case 8: {
                        return "INVALID_JAVADOC_TAG";
                    }
                    case 12: {
                        return "INVALID_ANNOTATION";
                    }
                    case 13: {
                        return "INVALID_ANNOTATION";
                    }
                    case 9: {
                        return "INVALID_REFERENCE_IN_SYSTEM_LIBRARIES";
                    }
                    case 10: {
                        return "UNUSED_PROBLEM_FILTERS";
                    }
                }
                break;
            }
            case 0x10000000: {
                return Util.getDeltaPrefererenceKey(problem.getElementKind(), problem.getKind(), problem.getFlags());
            }
            case -2147483648: {
                switch (problem.getKind()) {
                    case 1: {
                        return "API_USE_SCAN_TYPE_SEVERITY";
                    }
                    case 2: {
                        return "API_USE_SCAN_METHOD_SEVERITY";
                    }
                    case 3: {
                        return "API_USE_SCAN_FIELD_SEVERITY";
                    }
                }
                break;
            }
        }
        return null;
    }
}

