/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction.proposals;

import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.LambdaExpression;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.internal.core.manipulation.dom.ASTResolving;
import org.eclipse.jdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.dom.ScopeAnalyzer;
import org.eclipse.jdt.internal.ui.text.correction.proposals.MissingReturnTypeCorrectionProposalCore;

public class MissingReturnTypeInLambdaCorrectionProposalCore
extends MissingReturnTypeCorrectionProposalCore {
    private final LambdaExpression lambdaExpression;

    public MissingReturnTypeInLambdaCorrectionProposalCore(ICompilationUnit cu, LambdaExpression lambda, ReturnStatement existingReturn, int relevance) {
        super(cu, null, existingReturn, relevance);
        this.lambdaExpression = lambda;
        this.fExistingReturn = existingReturn;
    }

    @Override
    protected AST getAST() {
        return this.lambdaExpression.getAST();
    }

    @Override
    public ITypeBinding getReturnTypeBinding() {
        IMethodBinding methodBinding = this.lambdaExpression.resolveMethodBinding();
        if (methodBinding != null && methodBinding.getReturnType() != null) {
            return methodBinding.getReturnType();
        }
        return null;
    }

    @Override
    protected CompilationUnit getCU() {
        return (CompilationUnit)this.lambdaExpression.getRoot();
    }

    @Override
    protected Expression createDefaultExpression(AST ast) {
        return ASTNodeFactory.newDefaultExpression(ast, this.getReturnTypeBinding());
    }

    @Override
    protected ASTNode getBody() {
        return this.lambdaExpression.getBody();
    }

    @Override
    protected int getModifiers() {
        return 0;
    }

    public LambdaExpression getLambdaExpression() {
        return this.lambdaExpression;
    }

    @Override
    protected Expression computeProposals(AST ast, ITypeBinding returnBinding, int returnOffset, CompilationUnit root, Expression result) {
        ScopeAnalyzer analyzer = new ScopeAnalyzer(root);
        NodeFinder finder = new NodeFinder((ASTNode)root, returnOffset, 0);
        ASTNode varDeclFrag = ASTResolving.findAncestor(finder.getCoveringNode(), 59);
        IVariableBinding varDeclFragBinding = null;
        if (varDeclFrag != null) {
            varDeclFragBinding = ((VariableDeclarationFragment)varDeclFrag).resolveBinding();
        }
        IBinding[] iBindingArray = analyzer.getDeclarationsInScope(returnOffset, 18);
        int n = iBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            IBinding binding = iBindingArray[n2];
            IVariableBinding curr = (IVariableBinding)binding;
            ITypeBinding type = curr.getType();
            if (type != null && type.isAssignmentCompatible(returnBinding) && this.testModifier(curr) && !Bindings.equals((IBinding)curr, (IBinding)varDeclFragBinding)) {
                if (result == null) {
                    result = ast.newSimpleName(curr.getName());
                }
                this.addLinkedPositionProposal("value", curr.getName());
            }
            ++n2;
        }
        return result;
    }
}

