/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.codegen.ecore.genmodel;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum GenPropertyKind implements Enumerator
{
    EDITABLE_LITERAL(0, "Editable", "Editable"),
    READONLY_LITERAL(1, "Readonly", "Readonly"),
    NONE_LITERAL(2, "None", "None");

    public static final int EDITABLE = 0;
    public static final int READONLY = 1;
    public static final int NONE = 2;
    private static final GenPropertyKind[] VALUES_ARRAY;
    public static final List<GenPropertyKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new GenPropertyKind[]{EDITABLE_LITERAL, READONLY_LITERAL, NONE_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static GenPropertyKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            GenPropertyKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static GenPropertyKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            GenPropertyKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static GenPropertyKind get(int value) {
        switch (value) {
            case 0: {
                return EDITABLE_LITERAL;
            }
            case 1: {
                return READONLY_LITERAL;
            }
            case 2: {
                return NONE_LITERAL;
            }
        }
        return null;
    }

    private GenPropertyKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

