/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.tests.model.regression;

import com.ibm.icu.util.ULocale;
import java.io.File;
import org.eclipse.birt.report.model.api.DesignConfig;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DesignEngine;
import org.eclipse.birt.report.model.api.ElementFactory;
import org.eclipse.birt.report.model.api.LabelHandle;
import org.eclipse.birt.report.model.api.LibraryHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.SessionHandle;
import org.eclipse.birt.report.tests.model.BaseTestCase;

public class Regression_145465
extends BaseTestCase {
    private static final String REPORT = "regression_145465.xml";
    private static final String LIB = "regression_145465_lib.xml";

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.removeResource();
        this.copyInputToFile("input/regression_145465.xml");
        this.copyInputToFile("input/regression_145465_lib.xml");
    }

    @Override
    public void tearDown() {
        this.removeResource();
    }

    public void test_regression_145465() throws Exception {
        this.openDesign(REPORT);
        String outputLib = this.getTempFolder() + File.separator + "input" + File.separator + LIB;
        DesignEngine engine = new DesignEngine(new DesignConfig());
        SessionHandle session = engine.newSessionHandle(ULocale.ENGLISH);
        session.setResourceFolder(this.getTempFolder() + File.separator + "output");
        ReportDesignHandle designHandle = session.openDesign(this.getTempFolder() + "/input/regression_145465.xml");
        LibraryHandle libHandle = designHandle.getLibrary("regression_145465_lib");
        LabelHandle label = (LabelHandle)libHandle.findElement("NewLabel");
        ElementFactory factory = designHandle.getElementFactory();
        LabelHandle extendsLabel = (LabelHandle)factory.newElementFrom((DesignElementHandle)label, "extendsLabel");
        designHandle.getBody().add((DesignElementHandle)extendsLabel);
        designHandle.save();
        boolean deleted = new File(outputLib).delete();
        Regression_145465.assertTrue((boolean)deleted);
        designHandle.reloadLibraries();
    }
}

