/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.adapter.oda.api;

import java.util.Iterator;
import org.eclipse.birt.report.model.adapter.oda.ModelOdaAdapter;
import org.eclipse.birt.report.model.adapter.oda.model.DesignValues;
import org.eclipse.birt.report.model.adapter.oda.model.ModelFactory;
import org.eclipse.birt.report.model.adapter.oda.util.BaseTestCase;
import org.eclipse.birt.report.model.api.OdaDataSetHandle;
import org.eclipse.birt.report.model.api.OdaResultSetColumnHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.datatools.connectivity.oda.design.AxisType;
import org.eclipse.datatools.connectivity.oda.design.ColumnDefinition;
import org.eclipse.datatools.connectivity.oda.design.DataElementAttributes;
import org.eclipse.datatools.connectivity.oda.design.DataElementUIHints;
import org.eclipse.datatools.connectivity.oda.design.DataSetDesign;
import org.eclipse.datatools.connectivity.oda.design.DesignFactory;
import org.eclipse.datatools.connectivity.oda.design.OutputElementAttributes;
import org.eclipse.datatools.connectivity.oda.design.ResultSetDefinition;
import org.eclipse.datatools.connectivity.oda.design.ResultSets;
import org.eclipse.datatools.connectivity.oda.design.ValueFormatHints;
import org.eclipse.emf.common.util.EList;

public class ResultSetColumnAdapterTest
extends BaseTestCase {
    public void testToODAResultSetsWithColumnHint() throws Exception {
        this.openDesign("OdaDataSetConvertResultSetsTest.xml");
        OdaDataSetHandle setHandle = (OdaDataSetHandle)this.designHandle.findDataSet("myDataSet1");
        DataSetDesign setDesign = new ModelOdaAdapter().createDataSetDesign(setHandle);
        DesignValues values = ModelFactory.eINSTANCE.createDesignValues();
        values.setResultSets(setDesign.getResultSets());
        this.saveDesignValuesToFile(values);
        this.save();
        this.saveAndOpenDesign();
        setHandle = (OdaDataSetHandle)this.designHandle.findDataSet("myDataSet1");
        setDesign = new ModelOdaAdapter().createDataSetDesign(setHandle);
        String hint = ((ColumnDefinition)((ResultSetDefinition)setDesign.getResultSets().getResultSetDefinitions().get(0)).getResultSetColumns().getResultColumnDefinitions().get(0)).getUsageHints().getHelpText();
        ResultSetColumnAdapterTest.assertEquals((String)hint, (String)"Help me!");
    }

    public void testToROMResultSetsWithColumnHints() throws Exception {
        this.openDesign("OdaDataSetConvertResultSetsTest.xml");
        OdaDataSetHandle setHandle = (OdaDataSetHandle)this.designHandle.findDataSet("myDataSet1");
        DataSetDesign setDesign = new ModelOdaAdapter().createDataSetDesign(setHandle);
        ResultSets sets = setDesign.getResultSets();
        ResultSetDefinition setDefn = (ResultSetDefinition)sets.getResultSetDefinitions().get(0);
        this.updateOrVerifyResultSetDefinition1(setDefn, true);
        new ModelOdaAdapter().updateDataSetHandle(setDesign, setHandle, false);
        this.save();
        this.saveAndOpenDesign();
        setHandle = (OdaDataSetHandle)this.designHandle.findDataSet("myDataSet1");
        setDesign = new ModelOdaAdapter().createDataSetDesign(setHandle);
        sets = setDesign.getResultSets();
        setDefn = (ResultSetDefinition)sets.getResultSetDefinitions().get(0);
        this.openDesign("OdaDataSetConvertResultSetsTest_1.xml");
        setHandle = (OdaDataSetHandle)this.designHandle.findDataSet("myDataSet1");
        setDesign = new ModelOdaAdapter().createDataSetDesign(setHandle);
        sets = setDesign.getResultSets();
        setDefn = (ResultSetDefinition)sets.getResultSetDefinitions().get(0);
        this.updateOrVerifyResultSetDefinition1(setDefn, true);
        new ModelOdaAdapter().updateDataSetHandle(setDesign, setHandle, false);
        this.save();
        this.saveAndOpenDesign();
        setHandle = (OdaDataSetHandle)this.designHandle.findDataSet("myDataSet1");
        setDesign = new ModelOdaAdapter().createDataSetDesign(setHandle);
        sets = setDesign.getResultSets();
        setDefn = (ResultSetDefinition)sets.getResultSetDefinitions().get(0);
        this.openDesign("OdaDataSetConvertResultSetsTest_1.xml");
        setHandle = (OdaDataSetHandle)this.designHandle.findDataSet("myDataSet1");
        setDesign = new ModelOdaAdapter().createDataSetDesign(setHandle);
        this.updateOrVerifyResultSetColumnAndHint(setDesign, setHandle, true);
        new ModelOdaAdapter().updateDataSetHandle(setDesign, setHandle, false);
        this.save();
        this.saveAndOpenDesign();
        setHandle = (OdaDataSetHandle)this.designHandle.findDataSet("myDataSet1");
        setDesign = new ModelOdaAdapter().createDataSetDesign(setHandle);
    }

    public void testToROMResultSetsWithBlobType() throws Exception {
        this.openDesign("OdaDataSetConvertResultSetsTest_2.xml");
        OdaDataSetHandle setHandle = (OdaDataSetHandle)this.designHandle.findDataSet("myDataSet1");
        DataSetDesign setDesign = new ModelOdaAdapter().createDataSetDesign(setHandle);
        this.updateResultSetDefinition2(setHandle);
        new ModelOdaAdapter().updateDataSetHandle(setDesign, setHandle, false);
        this.save();
        this.saveAndOpenDesign();
        setHandle = (OdaDataSetHandle)this.designHandle.findDataSet("myDataSet1");
        setDesign = new ModelOdaAdapter().createDataSetDesign(setHandle);
        int dataTypeCode = ((ColumnDefinition)((ResultSetDefinition)setDesign.getResultSets().getResultSetDefinitions().get(0)).getResultSetColumns().getResultColumnDefinitions().get(0)).getAttributes().getNativeDataTypeCode();
        ResultSetColumnAdapterTest.assertEquals((int)dataTypeCode, (int)2004);
    }

    private void updateOrVerifyResultSetColumnAndHint(DataSetDesign setDesign, OdaDataSetHandle setHandle, boolean update) throws SemanticException {
        ResultSets sets = setDesign.getResultSets();
        ResultSetDefinition setDefn = (ResultSetDefinition)sets.getResultSetDefinitions().get(0);
        ColumnDefinition columnDef = (ColumnDefinition)setDefn.getResultSetColumns().getResultColumnDefinitions().get(0);
        DataElementAttributes dataAttrs = columnDef.getAttributes();
        DataElementUIHints dataUIHints = dataAttrs.getUiHints();
        OutputElementAttributes usageHints = columnDef.getUsageHints();
        if (columnDef.getMultiDimensionAttributes() == null) {
            columnDef.setMultiDimensionAttributes(DesignFactory.eINSTANCE.createAxisAttributes());
        }
        if (update) {
            dataAttrs.setNativeDataTypeCode(4);
            dataUIHints.setDisplayName("new display name for column 1");
            usageHints.setHelpText("new help text for column 1");
            ValueFormatHints format = DesignFactory.eINSTANCE.createValueFormatHints();
            format.setDisplayFormat("new format");
            usageHints.setFormattingHints(format);
            columnDef.setUsageHints(usageHints);
            columnDef.getMultiDimensionAttributes().setAxisType(AxisType.MEASURE_LITERAL);
            columnDef.getMultiDimensionAttributes().setOnColumnLayout(true);
        } else {
            ResultSetColumnAdapterTest.assertEquals((int)4, (int)dataAttrs.getNativeDataTypeCode());
            ResultSetColumnAdapterTest.assertEquals((String)"new display name for column 1", (String)dataUIHints.getDisplayName());
            ResultSetColumnAdapterTest.assertEquals((String)"new help text for column 1", (String)usageHints.getHelpText());
            ResultSetColumnAdapterTest.assertEquals((String)"new format", (String)usageHints.getFormattingHints().getDisplayFormat());
            ResultSetColumnAdapterTest.assertEquals((Object)AxisType.MEASURE_LITERAL, (Object)columnDef.getMultiDimensionAttributes().getAxisType());
            ResultSetColumnAdapterTest.assertTrue((boolean)columnDef.getMultiDimensionAttributes().isSetOnColumnLayout());
        }
    }

    private void updateOrVerifyResultSetDefinition1(ResultSetDefinition setDefn, boolean update) {
        EList columns = setDefn.getResultSetColumns().getResultColumnDefinitions();
        ColumnDefinition column1 = (ColumnDefinition)columns.get(0);
        ColumnDefinition column2 = (ColumnDefinition)columns.get(1);
        DataElementAttributes dataAttrs = column1.getAttributes();
        DataElementUIHints dataUIHints = dataAttrs.getUiHints();
        if (update) {
            dataUIHints.setDisplayName("new display name for column 1");
        } else {
            ResultSetColumnAdapterTest.assertEquals((String)"new display name for column 1", (String)dataUIHints.getDisplayName());
        }
        OutputElementAttributes usageHints = column1.getUsageHints();
        if (update) {
            usageHints.setHelpText("new help text for column 1");
        } else {
            ResultSetColumnAdapterTest.assertEquals((String)"new help text for column 1", (String)usageHints.getHelpText());
        }
        if (update) {
            usageHints.getFormattingHints().setDisplayFormat("new format for column 1");
        } else {
            ResultSetColumnAdapterTest.assertEquals(null, (String)usageHints.getFormattingHints().getDisplayFormat());
        }
        if (update) {
            axisAttrs = DesignFactory.eINSTANCE.createAxisAttributes();
            axisAttrs.setAxisType(AxisType.DIMENSION_MEMBER_LITERAL);
            axisAttrs.setOnColumnLayout(false);
            column1.setMultiDimensionAttributes(axisAttrs);
        } else {
            axisAttrs = column1.getMultiDimensionAttributes();
            ResultSetColumnAdapterTest.assertEquals((Object)AxisType.DIMENSION_MEMBER_LITERAL, (Object)axisAttrs.getAxisType());
            ResultSetColumnAdapterTest.assertFalse((boolean)axisAttrs.isOnColumnLayout());
        }
        if (update) {
            dataUIHints = DesignFactory.eINSTANCE.createDataElementUIHints();
            dataUIHints.setDisplayName("new display name for column 2");
            dataAttrs = column2.getAttributes();
            dataAttrs.setUiHints(dataUIHints);
        } else {
            dataUIHints = column2.getAttributes().getUiHints();
            ResultSetColumnAdapterTest.assertEquals((String)"new display name for column 2", (String)dataUIHints.getDisplayName());
        }
        if (update) {
            usageHints = DesignFactory.eINSTANCE.createOutputElementAttributes();
            usageHints.setHelpText("new help text for column 2");
            format = DesignFactory.eINSTANCE.createValueFormatHints();
            format.setDisplayFormat("new format for column 2");
            usageHints.setFormattingHints(format);
            column2.setUsageHints(usageHints);
        } else {
            usageHints = column2.getUsageHints();
            ResultSetColumnAdapterTest.assertEquals((String)"new help text for column 2", (String)usageHints.getHelpText());
            format = usageHints.getFormattingHints();
            ResultSetColumnAdapterTest.assertEquals((String)"new format for column 2", (String)format.getDisplayFormat());
        }
    }

    private void updateResultSetDefinition2(OdaDataSetHandle setHandle) throws SemanticException {
        Iterator iter1 = setHandle.resultSetIterator();
        OdaResultSetColumnHandle column = (OdaResultSetColumnHandle)iter1.next();
        column.setNativeDataType(new Integer(10));
    }
}

